/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.teavm.chromerdp.BaseChromeRDPDebugger;
import org.teavm.chromerdp.ChromeRDPScript;
import org.teavm.chromerdp.RDPBreakpoint;
import org.teavm.chromerdp.RDPCallFrame;
import org.teavm.chromerdp.RDPLocalVariable;
import org.teavm.chromerdp.RDPNativeBreakpoint;
import org.teavm.chromerdp.RDPValue;
import org.teavm.chromerdp.data.CallArgumentDTO;
import org.teavm.chromerdp.data.CallFrameDTO;
import org.teavm.chromerdp.data.LocationDTO;
import org.teavm.chromerdp.data.Message;
import org.teavm.chromerdp.data.PropertyDescriptorDTO;
import org.teavm.chromerdp.data.RemoteObjectDTO;
import org.teavm.chromerdp.data.ScopeDTO;
import org.teavm.chromerdp.messages.CallFunctionCommand;
import org.teavm.chromerdp.messages.CallFunctionResponse;
import org.teavm.chromerdp.messages.CompileScriptCommand;
import org.teavm.chromerdp.messages.CompileScriptResponse;
import org.teavm.chromerdp.messages.GetPropertiesCommand;
import org.teavm.chromerdp.messages.GetPropertiesResponse;
import org.teavm.chromerdp.messages.GetScriptSourceCommand;
import org.teavm.chromerdp.messages.RemoveBreakpointCommand;
import org.teavm.chromerdp.messages.RunScriptCommand;
import org.teavm.chromerdp.messages.ScriptParsedNotification;
import org.teavm.chromerdp.messages.ScriptSource;
import org.teavm.chromerdp.messages.SetBreakpointCommand;
import org.teavm.chromerdp.messages.SetBreakpointResponse;
import org.teavm.chromerdp.messages.SuspendedNotification;
import org.teavm.common.CompletablePromise;
import org.teavm.common.Promise;
import org.teavm.debugging.javascript.JavaScriptBreakpoint;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptDebuggerListener;
import org.teavm.debugging.javascript.JavaScriptLanguage;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.debugging.javascript.JavaScriptScript;
import org.teavm.debugging.javascript.JavaScriptVariable;

public class ChromeRDPDebugger
extends BaseChromeRDPDebugger
implements JavaScriptDebugger {
    private static final Promise<Map<String, ? extends JavaScriptVariable>> EMPTY_SCOPE = Promise.of(Collections.emptyMap());
    private Map<JavaScriptLocation, RDPNativeBreakpoint> breakpointLocationMap = new HashMap<JavaScriptLocation, RDPNativeBreakpoint>();
    private Set<RDPBreakpoint> breakpoints = new LinkedHashSet<RDPBreakpoint>();
    private Map<String, RDPNativeBreakpoint> breakpointsByChromeId = new HashMap<String, RDPNativeBreakpoint>();
    private volatile RDPCallFrame[] callStack = new RDPCallFrame[0];
    private Map<String, ChromeRDPScript> scripts = new LinkedHashMap<String, ChromeRDPScript>();
    private Map<String, JavaScriptScript> readonlyScripts = Collections.unmodifiableMap(this.scripts);
    private volatile boolean suspended;
    private Promise<Void> runtimeEnabledPromise;

    public ChromeRDPDebugger(Executor executor) {
        super(executor);
    }

    @Override
    protected void onAttach() {
        for (RDPBreakpoint breakpoint : this.breakpoints.toArray(new RDPBreakpoint[0])) {
            this.updateBreakpoint(breakpoint.nativeBreakpoint);
        }
    }

    @Override
    protected void onDetach() {
        this.suspended = false;
        this.callStack = null;
    }

    private Promise<Void> injectFunctions(int contextId) {
        return this.enableRuntime().thenAsync(v -> {
            CompileScriptCommand compileParams = new CompileScriptCommand();
            compileParams.expression = "$dbg_class = function(obj) { return typeof obj === 'object' && obj !== null && '__teavm_class__' in obj ? obj.__teavm_class__() : null; };\n$dbg_repr = function(obj) { return typeof obj === 'object' && obj !== null && 'toString' in obj ? obj.toString() : null; }\n";
            compileParams.sourceURL = "file://fake";
            compileParams.persistScript = true;
            compileParams.executionContextId = contextId;
            return this.callMethodAsync("Runtime.compileScript", CompileScriptResponse.class, compileParams);
        }).thenAsync(response -> {
            RunScriptCommand runParams = new RunScriptCommand();
            runParams.scriptId = response.scriptId;
            return this.callMethodAsync("Runtime.runScript", Void.TYPE, runParams);
        });
    }

    private Promise<Void> injectWasmFunctions(int contextId) {
        return this.enableRuntime().thenAsync(v -> {
            CompileScriptCommand compileParams = new CompileScriptCommand();
            compileParams.expression = "$dbg_memory = function(buffer, offset, count) { return btoa(String.fromCharCode.apply(null, new Uint8Array(buffer, offset, count))) };\n";
            compileParams.sourceURL = "file://fake-wasm";
            compileParams.persistScript = true;
            compileParams.executionContextId = contextId;
            return this.callMethodAsync("Runtime.compileScript", CompileScriptResponse.class, compileParams);
        }).thenAsync(response -> {
            RunScriptCommand runParams = new RunScriptCommand();
            runParams.scriptId = response.scriptId;
            return this.callMethodAsync("Runtime.runScript", Void.TYPE, runParams);
        });
    }

    private Promise<Void> enableRuntime() {
        if (this.runtimeEnabledPromise == null) {
            this.runtimeEnabledPromise = this.callMethodAsync("Runtime.enable", Void.TYPE, null);
        }
        return this.runtimeEnabledPromise;
    }

    @Override
    protected Promise<Void> handleMessage(Message message) throws IOException {
        switch (message.getMethod()) {
            case "TeaVM.ping": {
                this.sendPong();
                return Promise.VOID;
            }
            case "Debugger.paused": {
                return this.firePaused(this.parseJson(SuspendedNotification.class, message.getParams()));
            }
            case "Debugger.resumed": {
                return this.fireResumed();
            }
            case "Debugger.scriptParsed": {
                return this.scriptParsed(this.parseJson(ScriptParsedNotification.class, message.getParams()));
            }
        }
        return Promise.VOID;
    }

    private void sendPong() {
        Message message = new Message();
        message.setMethod("TeaVM.pong");
        this.sendMessage(message);
    }

    private Promise<Void> firePaused(SuspendedNotification params) {
        this.suspended = true;
        CallFrameDTO[] callFrameDTOs = params.getCallFrames();
        RDPCallFrame[] callStack = new RDPCallFrame[callFrameDTOs.length];
        for (int i = 0; i < callStack.length; ++i) {
            callStack[i] = this.map(callFrameDTOs[i]);
        }
        this.callStack = callStack;
        RDPNativeBreakpoint nativeBreakpoint = null;
        if (params.getHitBreakpoints() != null && !params.getHitBreakpoints().isEmpty()) {
            nativeBreakpoint = this.breakpointsByChromeId.get(params.getHitBreakpoints().get(0));
        }
        RDPBreakpoint breakpoint = nativeBreakpoint != null && !nativeBreakpoint.breakpoints.isEmpty() ? nativeBreakpoint.breakpoints.iterator().next() : null;
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.paused((JavaScriptBreakpoint)breakpoint);
        }
        return Promise.VOID;
    }

    private Promise<Void> fireResumed() {
        this.suspended = false;
        this.callStack = null;
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.resumed();
        }
        return Promise.VOID;
    }

    private Promise<Void> scriptParsed(ScriptParsedNotification params) {
        if (params.getUrl() == null) {
            return Promise.VOID;
        }
        JavaScriptLanguage language = JavaScriptLanguage.JS;
        if (params.getScriptLanguage() != null) {
            switch (params.getScriptLanguage()) {
                case "WebAssembly": {
                    language = JavaScriptLanguage.WASM;
                    break;
                }
                case "JavaScript": {
                    language = JavaScriptLanguage.JS;
                    break;
                }
                default: {
                    language = JavaScriptLanguage.UNKNOWN;
                }
            }
        }
        ChromeRDPScript script = new ChromeRDPScript(this, params.getScriptId(), language, params.getUrl());
        this.scripts.put(script.getId(), script);
        if (params.getUrl().startsWith("file://fake")) {
            return Promise.VOID;
        }
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.scriptAdded((JavaScriptScript)script);
        }
        if (language == JavaScriptLanguage.JS) {
            return this.injectFunctions(params.getExecutionContextId());
        }
        if (language == JavaScriptLanguage.WASM) {
            return this.injectWasmFunctions(params.getExecutionContextId());
        }
        return Promise.VOID;
    }

    public Map<? extends String, ? extends JavaScriptScript> getScripts() {
        return this.readonlyScripts;
    }

    public void addListener(JavaScriptDebuggerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JavaScriptDebuggerListener listener) {
        this.listeners.remove(listener);
    }

    public Promise<Void> suspend() {
        return this.callMethodAsync("Debugger.pause", Void.TYPE, null);
    }

    public Promise<Void> resume() {
        return this.callMethodAsync("Debugger.resume", Void.TYPE, null);
    }

    public Promise<Void> stepInto() {
        return this.callMethodAsync("Debugger.stepInto", Void.TYPE, null);
    }

    public Promise<Void> stepOut() {
        return this.callMethodAsync("Debugger.stepOut", Void.TYPE, null);
    }

    public Promise<Void> stepOver() {
        return this.callMethodAsync("Debugger.stepOver", Void.TYPE, null);
    }

    public boolean isSuspended() {
        return this.isAttached() && this.suspended;
    }

    public JavaScriptCallFrame[] getCallStack() {
        if (!this.isAttached()) {
            return null;
        }
        RDPCallFrame[] callStack = this.callStack;
        return callStack != null ? (JavaScriptCallFrame[])callStack.clone() : null;
    }

    public Promise<JavaScriptBreakpoint> createBreakpoint(JavaScriptLocation location) {
        RDPBreakpoint breakpoint = new RDPBreakpoint(this);
        breakpoint.nativeBreakpoint = this.lockNativeBreakpoint(location, breakpoint);
        CompletablePromise result = new CompletablePromise();
        this.breakpoints.add(breakpoint);
        breakpoint.nativeBreakpoint.initPromise.thenVoid(v -> result.complete((Object)breakpoint));
        return result;
    }

    Promise<Void> destroyBreakpoint(RDPBreakpoint breakpoint) {
        if (breakpoint.nativeBreakpoint == null) {
            return Promise.VOID;
        }
        RDPNativeBreakpoint nativeBreakpoint = breakpoint.nativeBreakpoint;
        breakpoint.nativeBreakpoint = null;
        nativeBreakpoint.breakpoints.remove(breakpoint);
        this.breakpoints.remove(breakpoint);
        return this.releaseNativeBreakpoint(nativeBreakpoint, breakpoint);
    }

    private RDPNativeBreakpoint lockNativeBreakpoint(JavaScriptLocation location, RDPBreakpoint bp) {
        RDPNativeBreakpoint breakpoint = this.breakpointLocationMap.get(location);
        if (breakpoint != null) {
            breakpoint.breakpoints.add(bp);
            return breakpoint;
        }
        breakpoint = new RDPNativeBreakpoint(this, location);
        breakpoint.breakpoints.add(bp);
        this.breakpointLocationMap.put(location, breakpoint);
        RDPNativeBreakpoint finalBreakpoint = breakpoint;
        breakpoint.initPromise = this.updateBreakpoint(breakpoint).then(v -> {
            this.checkBreakpoint(finalBreakpoint);
            return null;
        });
        return breakpoint;
    }

    private Promise<Void> releaseNativeBreakpoint(RDPNativeBreakpoint breakpoint, RDPBreakpoint bp) {
        breakpoint.breakpoints.remove(bp);
        return this.checkBreakpoint(breakpoint);
    }

    private Promise<Void> checkBreakpoint(RDPNativeBreakpoint breakpoint) {
        if (!breakpoint.breakpoints.isEmpty()) {
            return Promise.VOID;
        }
        if (this.breakpointLocationMap.get(breakpoint.getLocation()) == breakpoint) {
            this.breakpointLocationMap.remove(breakpoint.getLocation());
        }
        if (breakpoint.destroyPromise == null) {
            breakpoint.destroyPromise = breakpoint.initPromise.thenAsync(v -> {
                this.breakpointsByChromeId.remove(breakpoint.chromeId);
                if (logger.isInfoEnabled()) {
                    logger.info("Removing breakpoint at {}", (Object)breakpoint.getLocation());
                }
                RemoveBreakpointCommand params = new RemoveBreakpointCommand();
                params.setBreakpointId(breakpoint.chromeId);
                return this.callMethodAsync("Debugger.removeBreakpoint", Void.TYPE, params);
            });
            breakpoint.debugger = null;
        }
        return breakpoint.destroyPromise;
    }

    private Promise<Void> updateBreakpoint(RDPNativeBreakpoint breakpoint) {
        if (breakpoint.chromeId != null) {
            return Promise.VOID;
        }
        SetBreakpointCommand params = new SetBreakpointCommand();
        params.setLocation(this.unmap(breakpoint.getLocation()));
        if (logger.isInfoEnabled()) {
            logger.info("Setting breakpoint at {}", (Object)breakpoint.getLocation());
        }
        return this.callMethodAsync("Debugger.setBreakpoint", SetBreakpointResponse.class, params).thenVoid(response -> {
            if (response != null) {
                breakpoint.chromeId = response.getBreakpointId();
                if (breakpoint.chromeId != null) {
                    this.breakpointsByChromeId.put(breakpoint.chromeId, breakpoint);
                }
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("Error setting breakpoint at {}", (Object)breakpoint.getLocation());
                }
                breakpoint.chromeId = null;
            }
            for (RDPBreakpoint bp : breakpoint.breakpoints) {
                for (JavaScriptDebuggerListener listener : this.getListeners()) {
                    listener.breakpointChanged((JavaScriptBreakpoint)bp);
                }
            }
        });
    }

    Promise<List<RDPLocalVariable>> getScope(String scopeId) {
        GetPropertiesCommand params = new GetPropertiesCommand();
        params.setObjectId(scopeId);
        params.setOwnProperties(true);
        return this.callMethodAsync("Runtime.getProperties", GetPropertiesResponse.class, params).thenAsync(response -> {
            if (response == null) {
                return Promise.of(Collections.emptyList());
            }
            PropertyDescriptorDTO proto = Arrays.asList(response.getResult()).stream().filter(p -> p.getName().equals("__proto__")).findAny().orElse(null);
            if (proto == null || proto.getValue() == null || proto.getValue().getObjectId() == null) {
                return Promise.of(this.parseProperties(scopeId, response.getResult(), null));
            }
            GetPropertiesCommand protoParams = new GetPropertiesCommand();
            protoParams.setObjectId(proto.getValue().getObjectId());
            protoParams.setOwnProperties(false);
            return this.callMethodAsync("Runtime.getProperties", GetPropertiesResponse.class, protoParams).then(protoProperties -> {
                PropertyDescriptorDTO[] getters = (PropertyDescriptorDTO[])Arrays.asList(protoProperties.getResult()).stream().filter(p -> p.getGetter() != null && p.getValue() == null && !p.getName().equals("__proto__")).toArray(PropertyDescriptorDTO[]::new);
                return this.parseProperties(scopeId, response.getResult(), getters);
            });
        });
    }

    Promise<List<RDPLocalVariable>> getSpecialScope(String scopeId) {
        GetPropertiesCommand params = new GetPropertiesCommand();
        params.setObjectId(scopeId);
        params.setOwnProperties(false);
        return this.callMethodAsync("Runtime.getProperties", GetPropertiesResponse.class, params).then(response -> {
            if (response == null) {
                return Collections.emptyList();
            }
            return this.parseProperties(scopeId, response.getResult(), null);
        });
    }

    Promise<String> getClassName(String objectId) {
        CallFunctionCommand params = new CallFunctionCommand();
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("$dbg_class");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result = response != null ? response.getResult() : null;
            return result.getValue() != null ? result.getValue().textValue() : null;
        });
    }

    Promise<byte[]> getMemory(String objectId, int start, int count) {
        CallFunctionCommand params = new CallFunctionCommand();
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{this.objArg(objectId), this.intArg(start), this.intArg(count)});
        params.setFunctionDeclaration("$dbg_memory");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result;
            RemoteObjectDTO remoteObjectDTO = result = response != null ? response.getResult() : null;
            if (result.getValue() == null) {
                return null;
            }
            return Base64.getDecoder().decode(result.getValue().textValue());
        });
    }

    private CallArgumentDTO objArg(String objectId) {
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        return arg;
    }

    private CallArgumentDTO intArg(int value) {
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setValue((JsonNode)new IntNode(value));
        return arg;
    }

    Promise<String> getRepresentation(String objectId) {
        CallFunctionCommand params = new CallFunctionCommand();
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("$dbg_repr");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result = response != null ? response.getResult() : null;
            return result.getValue() != null ? result.getValue().textValue() : null;
        });
    }

    private List<RDPLocalVariable> parseProperties(String scopeId, PropertyDescriptorDTO[] properties, PropertyDescriptorDTO[] getters) {
        ArrayList<RDPLocalVariable> variables = new ArrayList<RDPLocalVariable>();
        if (properties != null) {
            for (PropertyDescriptorDTO property : properties) {
                RemoteObjectDTO remoteValue = property.getValue();
                RemoteObjectDTO getter = property.getGetter();
                RDPValue value = remoteValue != null && remoteValue.getType() != null ? this.mapValue(remoteValue) : (getter != null && getter.getObjectId() != null ? this.mapValue(getter) : new RDPValue(this, "null", "null", null, false));
                RDPLocalVariable var = new RDPLocalVariable(property.getName(), value);
                variables.add(var);
            }
        }
        if (getters != null) {
            for (PropertyDescriptorDTO property : getters) {
                RDPValue value = new RDPValue(this, "<get>", "@Function", scopeId, true);
                value.getter = property.getGetter();
                RDPLocalVariable var = new RDPLocalVariable(property.getName(), value);
                variables.add(var);
            }
        }
        return variables;
    }

    Promise<RDPValue> invokeGetter(String functionId, String objectId) {
        CallFunctionCommand params = new CallFunctionCommand();
        params.setObjectId(functionId);
        CallArgumentDTO functionArg = new CallArgumentDTO();
        functionArg.setObjectId(functionId);
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("Function.prototype.call");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result = response != null ? response.getResult() : null;
            return result.getValue() != null ? this.mapValue(result) : null;
        });
    }

    RDPValue mapValue(RemoteObjectDTO remoteValue) {
        switch (remoteValue.getType()) {
            case "undefined": {
                return new RDPValue(this, "undefined", "undefined", null, false);
            }
            case "object": 
            case "function": {
                if (remoteValue.getValue() instanceof NullNode) {
                    return new RDPValue(this, "null", "null", null, false);
                }
                return new RDPValue(this, null, remoteValue.getType(), remoteValue.getObjectId(), true);
            }
        }
        String valueAsText = remoteValue.getValue() != null ? remoteValue.getValue().asText() : "null";
        return new RDPValue(this, valueAsText, remoteValue.getType(), remoteValue.getObjectId(), false);
    }

    private RDPCallFrame map(CallFrameDTO dto) {
        String scopeId = null;
        RDPValue thisObject = null;
        RDPValue closure = null;
        RDPValue module = null;
        block12: for (ScopeDTO scope : dto.getScopeChain()) {
            switch (scope.getType()) {
                case "local": {
                    scopeId = scope.getObject().getObjectId();
                    continue block12;
                }
                case "closure": {
                    closure = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
                    continue block12;
                }
                case "global": {
                    thisObject = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
                    continue block12;
                }
                case "module": {
                    module = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
                }
            }
        }
        return new RDPCallFrame(this, dto.getCallFrameId(), this.map(dto.getLocation()), scopeId, thisObject, module, closure);
    }

    private JavaScriptLocation map(LocationDTO dto) {
        return new JavaScriptLocation((JavaScriptScript)this.scripts.get(dto.getScriptId()), dto.getLineNumber(), dto.getColumnNumber());
    }

    private LocationDTO unmap(JavaScriptLocation location) {
        LocationDTO dto = new LocationDTO();
        dto.setScriptId(location.getScript().getId());
        dto.setLineNumber(location.getLine());
        dto.setColumnNumber(location.getColumn());
        return dto;
    }

    Promise<Map<String, ? extends JavaScriptVariable>> createScope(String id) {
        if (id == null) {
            return EMPTY_SCOPE;
        }
        return this.getScope(id).then(scope -> {
            HashMap<String, RDPLocalVariable> newBackingMap = new HashMap<String, RDPLocalVariable>();
            for (RDPLocalVariable variable : scope) {
                newBackingMap.put(variable.getName(), variable);
            }
            return Collections.unmodifiableMap(newBackingMap);
        });
    }

    Promise<String> getScriptSource(String id) {
        GetScriptSourceCommand callArgs = new GetScriptSourceCommand();
        callArgs.scriptId = id;
        return this.callMethodAsync("Debugger.getScriptSource", ScriptSource.class, callArgs).then(source -> source.bytecode);
    }
}

