/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.util.HashMap;
import java.util.Map;
import org.teavm.chromerdp.ChromeRDPDebugger;
import org.teavm.chromerdp.RDPLocalVariable;
import org.teavm.chromerdp.data.RemoteObjectDTO;
import org.teavm.common.Promise;
import org.teavm.debugging.javascript.JavaScriptValue;
import org.teavm.debugging.javascript.JavaScriptVariable;

class RDPValue
implements JavaScriptValue {
    private ChromeRDPDebugger debugger;
    private String objectId;
    private Promise<Map<String, ? extends JavaScriptVariable>> properties;
    private boolean innerStructure;
    private Promise<String> className;
    private Promise<String> representation;
    private final String defaultRepresentation;
    private final String typeName;
    RemoteObjectDTO getter;

    RDPValue(ChromeRDPDebugger debugger, String representation, String typeName, String objectId, boolean innerStructure) {
        this.debugger = debugger;
        this.objectId = objectId;
        this.innerStructure = innerStructure;
        this.typeName = typeName;
        this.defaultRepresentation = representation;
    }

    public Promise<String> getRepresentation() {
        if (this.representation == null) {
            this.representation = this.objectId != null ? (this.defaultRepresentation != null ? Promise.of((Object)this.defaultRepresentation) : this.debugger.getRepresentation(this.objectId)) : Promise.of((Object)(this.defaultRepresentation != null ? this.defaultRepresentation : ""));
        }
        return this.representation;
    }

    public Promise<String> getClassName() {
        if (this.className == null) {
            this.className = this.objectId == null ? Promise.of((Object)("@" + this.typeName)) : this.debugger.getClassName(this.objectId).then(c -> c != null ? c : "@Object");
        }
        return this.className;
    }

    public Promise<Map<String, ? extends JavaScriptVariable>> getProperties() {
        if (this.properties == null) {
            this.properties = this.getter == null ? this.debugger.createScope(this.objectId) : this.debugger.invokeGetter(this.getter.getObjectId(), this.objectId).then(value -> {
                if (value == null) {
                    value = new RDPValue(this.debugger, "null", "null", null, false);
                }
                HashMap<String, RDPLocalVariable> map = new HashMap<String, RDPLocalVariable>();
                map.put("<value>", new RDPLocalVariable("<value>", (RDPValue)value));
                map.put("<function>", new RDPLocalVariable("<function>", this.debugger.mapValue(this.getter)));
                return map;
            });
        }
        return this.properties;
    }

    public boolean hasInnerStructure() {
        return this.innerStructure;
    }

    public String getInstanceId() {
        return this.objectId;
    }
}

