/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.util.Map;
import org.teavm.chromerdp.ChromeRDPDebugger;
import org.teavm.common.Promise;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.debugging.javascript.JavaScriptValue;
import org.teavm.debugging.javascript.JavaScriptVariable;

class RDPCallFrame
implements JavaScriptCallFrame {
    private ChromeRDPDebugger debugger;
    private String chromeId;
    private JavaScriptLocation location;
    private Promise<Map<String, ? extends JavaScriptVariable>> variables;
    private JavaScriptValue thisObject;
    private JavaScriptValue closure;
    private String scopeId;

    RDPCallFrame(ChromeRDPDebugger debugger, String chromeId, JavaScriptLocation location, String scopeId, JavaScriptValue thisObject, JavaScriptValue closure) {
        this.debugger = debugger;
        this.chromeId = chromeId;
        this.location = location;
        this.scopeId = scopeId;
        this.thisObject = thisObject;
        this.closure = closure;
    }

    public String getChromeId() {
        return this.chromeId;
    }

    public JavaScriptLocation getLocation() {
        return this.location;
    }

    public Promise<Map<String, ? extends JavaScriptVariable>> getVariables() {
        if (this.variables == null) {
            this.variables = this.debugger.createScope(this.scopeId);
        }
        return this.variables;
    }

    public JavaScriptDebugger getDebugger() {
        return this.debugger;
    }

    public JavaScriptValue getThisVariable() {
        return this.thisObject;
    }

    public JavaScriptValue getClosureVariable() {
        return this.closure;
    }
}

