/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.teavm.chromerdp.ChromeRDPDebugger;
import org.teavm.chromerdp.ChromeRDPServer;
import org.teavm.common.Promise;
import org.teavm.debugging.Breakpoint;
import org.teavm.debugging.CallFrame;
import org.teavm.debugging.Debugger;
import org.teavm.debugging.DebuggerListener;
import org.teavm.debugging.Variable;
import org.teavm.debugging.information.DebugInformationProvider;
import org.teavm.debugging.information.URLDebugInformationProvider;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.debugging.javascript.JavaScriptVariable;

public final class ChromeRDPRunner {
    private ChromeRDPServer server;
    private Debugger debugger;
    private Map<Breakpoint, Integer> breakpointIds = new WeakHashMap<Breakpoint, Integer>();
    private int currentFrame;
    private int breakpointIdGen;
    BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private DebuggerListener listener = new DebuggerListener(){

        public void resumed() {
        }

        public void paused(Breakpoint breakpoint) {
            CallFrame[] stack = ChromeRDPRunner.this.debugger.getCallStack();
            if (stack.length > 0) {
                System.out.println();
                System.out.println("Suspended at " + stack[0].getLocation());
            }
            if (breakpoint != null) {
                System.out.println("Breakpoint #" + ChromeRDPRunner.this.breakpointIds.get(breakpoint) + " hit");
            }
            ChromeRDPRunner.this.currentFrame = 0;
        }

        public void breakpointStatusChanged(Breakpoint breakpoint) {
        }

        public void attached() {
        }

        public void detached() {
        }
    };
    private Command resumeCommand = args -> this.debugger.resume();
    private Command breakpointCommand = args -> {
        if (args.length < 2 || args.length > 4) {
            System.out.println("Expected 2 arguments");
            return Promise.VOID;
        }
        if (args.length == 4) {
            return this.tryResolveJsBreakpoint(args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
        }
        Object[] fileNames = this.resolveFileName(args[1]);
        if (fileNames.length == 0) {
            return this.tryResolveJsBreakpoint(args[1], Integer.parseInt(args[2]), args.length == 3 ? 1 : Integer.parseInt(args[3]));
        }
        if (fileNames.length > 1) {
            System.out.println("Ambiguous file name: " + args[1] + ". Possible names are: " + Arrays.toString(fileNames));
            return Promise.VOID;
        }
        return this.debugger.createBreakpoint(fileNames[0], Integer.parseInt(args[2])).thenVoid(bp -> {
            int id = this.breakpointIdGen++;
            this.breakpointIds.put((Breakpoint)bp, id);
            System.out.println("Breakpoint #" + id + " was set at " + bp.getLocation());
        });
    };
    private Command backtraceCommand = args -> {
        CallFrame[] callStack = this.debugger.getCallStack();
        for (int i = 0; i < callStack.length; ++i) {
            StringBuilder sb = new StringBuilder(i == this.currentFrame ? " -> " : "    ");
            sb.append("#").append(i).append(": ");
            CallFrame frame = callStack[i];
            if (frame.getMethod() != null) {
                sb.append(frame.getMethod().getClassName()).append('.').append(frame.getMethod().getName());
            } else {
                sb.append("[unknown method]");
            }
            if (frame.getLocation() != null) {
                sb.append('(').append(frame.getLocation()).append(')');
            }
            System.out.println(sb.toString());
        }
        return Promise.VOID;
    };
    private Command frameCommand = args -> {
        if (args.length != 2) {
            System.out.println("Expected 1 argument");
            return Promise.VOID;
        }
        int index = Integer.parseInt(args[1]);
        int max = this.debugger.getCallStack().length - 1;
        if (index < 0 || index > max) {
            System.out.println("Given frame index is outside of valid range 0.." + max);
            return Promise.VOID;
        }
        this.currentFrame = index;
        return Promise.VOID;
    };
    private Command stepCommand = args -> this.debugger.stepInto();
    private Command nextCommand = args -> this.debugger.stepOver();
    private Command outCommand = args -> this.debugger.stepOut();
    private Command infoCommand = args -> {
        if (args.length != 2) {
            System.out.println("Expected 1 argument");
            return Promise.VOID;
        }
        switch (args[1]) {
            case "breakpoints": {
                List sortedBreakpoints = this.debugger.getBreakpoints().stream().sorted(Comparator.comparing(this.breakpointIds::get)).collect(Collectors.toList());
                for (Breakpoint breakpoint : sortedBreakpoints) {
                    int id = this.breakpointIds.get(breakpoint);
                    System.out.println("    #" + id + ": " + breakpoint.getLocation());
                }
                return Promise.VOID;
            }
            case "variables": {
                CallFrame frame = this.debugger.getCallStack()[this.currentFrame];
                return this.printScope((Promise<Map<String, Variable>>)frame.getVariables());
            }
        }
        System.out.println("Invalid argument");
        return Promise.VOID;
    };
    private Command printCommand = args -> {
        if (args.length != 2) {
            System.out.println("Expected 1 argument");
            return Promise.VOID;
        }
        String[] path = args[1].split("\\.");
        return this.followPath(path, 0, (Promise<Map<String, Variable>>)this.debugger.getCallStack()[this.currentFrame].getVariables());
    };

    private ChromeRDPRunner() {
        this.server = new ChromeRDPServer();
        this.server.setPort(2357);
        ChromeRDPDebugger jsDebugger = new ChromeRDPDebugger(this.queue::offer);
        this.server.setExchangeConsumer(jsDebugger);
        new Thread(this.server::start).start();
        this.debugger = new Debugger((JavaScriptDebugger)jsDebugger, (DebugInformationProvider)new URLDebugInformationProvider(""));
        this.debugger.addListener(this.listener);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            System.err.println("Uncaught exception in thread " + t);
            e.printStackTrace();
        });
    }

    public static void main(String[] args) {
        ChromeRDPRunner runner = new ChromeRDPRunner();
        try {
            runner.acceptInput();
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted");
        }
    }

    public void acceptInput() throws InterruptedException {
        boolean wasAttached = this.debugger.isAttached();
        if (!wasAttached) {
            System.out.println("Waiting for remote process to attach...");
        }
        while (true) {
            this.queue.take().run();
            if (this.debugger.isAttached() && !wasAttached) {
                wasAttached = true;
                System.out.println("Attached");
                new Thread(() -> {
                    try {
                        this.stdinThread();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }).start();
                continue;
            }
            if (!this.debugger.isAttached() && wasAttached) break;
        }
        this.queue.offer(() -> {
            this.debugger.detach();
            this.server.stop();
        });
    }

    /*
     * Exception decompiling
     */
    private void stdinThread() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Promise<Boolean> processSingleCommand(String line) {
        String[] parts = (String[])Arrays.stream((line = line.trim()).split(" +")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (parts.length == 0) {
            return Promise.of((Object)true);
        }
        switch (parts[0]) {
            case "suspend": {
                if (this.debugger.isSuspended()) {
                    System.out.println("Suspend command is only available when program is running");
                    return Promise.of((Object)true);
                }
                return this.debugger.suspend().then(v -> true);
            }
            case "detach": {
                return Promise.of((Object)false);
            }
            case "continue": 
            case "cont": 
            case "c": {
                return this.suspended(parts, this.resumeCommand);
            }
            case "breakpoint": 
            case "break": 
            case "br": 
            case "bp": {
                return this.breakpointCommand.execute(parts).then(v -> true);
            }
            case "backtrace": 
            case "bt": {
                return this.suspended(parts, this.backtraceCommand);
            }
            case "frame": 
            case "fr": 
            case "f": {
                return this.suspended(parts, this.frameCommand);
            }
            case "step": 
            case "s": {
                return this.suspended(parts, this.stepCommand);
            }
            case "next": 
            case "n": {
                return this.suspended(parts, this.nextCommand);
            }
            case "out": 
            case "o": {
                return this.suspended(parts, this.outCommand);
            }
            case "info": {
                return this.suspended(parts, this.infoCommand);
            }
            case "print": 
            case "p": {
                return this.suspended(parts, this.printCommand);
            }
        }
        System.out.println("Unknown command");
        return Promise.of((Object)true);
    }

    private Promise<Boolean> suspended(String[] arguments, Command command) {
        if (!this.debugger.isSuspended()) {
            System.out.println("This command is only available when remote process is suspended");
            return Promise.of((Object)true);
        }
        return command.execute(arguments).then(v -> true);
    }

    private Promise<Void> tryResolveJsBreakpoint(String fileName, int lineNumber, int columnNumber) {
        Object[] fileNames = this.resolveJsFileName(fileName);
        if (fileNames.length == 0) {
            System.out.println("Unknown file: " + fileName);
            return Promise.VOID;
        }
        if (fileNames.length > 1) {
            System.out.println("Ambiguous file name: " + fileName + ". Possible names are: " + Arrays.toString(fileNames));
            return Promise.VOID;
        }
        JavaScriptLocation location = new JavaScriptLocation(fileNames[0], lineNumber - 1, columnNumber - 1);
        return this.debugger.getJavaScriptDebugger().createBreakpoint(location).thenVoid(bp -> System.out.println("Native breakpoint was set at " + bp.getLocation()));
    }

    private String[] resolveJsFileName(String fileName) {
        if (this.debugger.getScriptNames().contains(fileName)) {
            return new String[]{fileName};
        }
        String[] result = (String[])this.debugger.getScriptNames().stream().filter(f -> f.endsWith(fileName) && ChromeRDPRunner.isPrecededByPathSeparator(f, fileName)).toArray(String[]::new);
        if (result.length == 1) {
            return result;
        }
        return (String[])this.debugger.getSourceFiles().stream().filter(f -> {
            int index = f.lastIndexOf(46);
            if (index <= 0) {
                return false;
            }
            String nameWithoutExt = f.substring(0, index);
            return nameWithoutExt.endsWith(fileName) && ChromeRDPRunner.isPrecededByPathSeparator(nameWithoutExt, fileName);
        }).toArray(String[]::new);
    }

    private String[] resolveFileName(String fileName) {
        if (this.debugger.getSourceFiles().contains(fileName)) {
            return new String[]{fileName};
        }
        String[] result = (String[])this.debugger.getSourceFiles().stream().filter(f -> f.endsWith(fileName) && ChromeRDPRunner.isPrecededByPathSeparator(f, fileName)).toArray(String[]::new);
        if (result.length == 1) {
            return result;
        }
        return (String[])this.debugger.getSourceFiles().stream().filter(f -> {
            int index = f.lastIndexOf(46);
            if (index <= 0) {
                return false;
            }
            String nameWithoutExt = f.substring(0, index);
            return nameWithoutExt.endsWith(fileName) && ChromeRDPRunner.isPrecededByPathSeparator(nameWithoutExt, fileName);
        }).toArray(String[]::new);
    }

    private static boolean isPrecededByPathSeparator(String actualName, String specifiedName) {
        if (actualName.length() < specifiedName.length() + 1) {
            return false;
        }
        char c = actualName.charAt(actualName.length() - specifiedName.length() - 1);
        return c == '/' || c == '\\';
    }

    private Promise<Void> followPath(String[] path, int index, Promise<Map<String, Variable>> scope) {
        String elem = path[index];
        return scope.thenAsync(map -> {
            Variable var = (Variable)map.get(elem);
            if (var != null) {
                if (index == path.length - 1) {
                    return this.variableToString(var).thenVoid(str -> System.out.println((String)str)).thenAsync(v -> var.getValue().getType().thenAsync(type -> type.startsWith("@") ? this.printJsScope((Promise<Map<String, ? extends JavaScriptVariable>>)var.getValue().getOriginalValue().getProperties()) : this.printScope((Promise<Map<String, Variable>>)var.getValue().getProperties())));
                }
                return var.getValue().getType().thenAsync(type -> type.startsWith("@") ? this.followJsPath(path, index + 1, (Promise<Map<String, ? extends JavaScriptVariable>>)var.getValue().getOriginalValue().getProperties()) : this.followPath(path, index + 1, (Promise<Map<String, Variable>>)var.getValue().getProperties()));
            }
            System.out.println("Invalid path specified");
            return Promise.VOID;
        });
    }

    private Promise<Void> followJsPath(String[] path, int index, Promise<Map<String, ? extends JavaScriptVariable>> scope) {
        String elem = path[index];
        return scope.thenAsync(map -> {
            JavaScriptVariable var = (JavaScriptVariable)map.get(elem);
            if (var != null) {
                if (index == path.length - 1) {
                    return this.jsVariableToString(var).thenVoid(str -> System.out.println((String)str)).thenAsync(v -> this.printJsScope((Promise<Map<String, ? extends JavaScriptVariable>>)var.getValue().getProperties()));
                }
                return this.followJsPath(path, index + 1, (Promise<Map<String, ? extends JavaScriptVariable>>)var.getValue().getProperties());
            }
            System.out.println("Invalid path specified");
            return Promise.VOID;
        });
    }

    private Promise<Void> printScope(Promise<Map<String, Variable>> scope) {
        return scope.then(vars -> vars.values()).then(vars -> vars.stream().sorted(Comparator.comparing(Variable::getName)).map(this::variableToString).collect(Collectors.toList())).thenAsync(Promise::all).thenVoid(vars -> {
            for (String var : vars) {
                System.out.println("    " + var);
            }
        });
    }

    private Promise<Void> printJsScope(Promise<Map<String, ? extends JavaScriptVariable>> scope) {
        return scope.then(vars -> vars.values()).then(vars -> vars.stream().sorted(Comparator.comparing(JavaScriptVariable::getName)).map(this::jsVariableToString).collect(Collectors.toList())).thenAsync(Promise::all).thenVoid(vars -> {
            for (String var : vars) {
                System.out.println("    " + var);
            }
        });
    }

    private Promise<String> variableToString(Variable variable) {
        return variable.getValue().getType().thenAsync(type -> variable.getValue().getRepresentation().then(repr -> variable.getName() + ": " + type + " (" + repr + ")"));
    }

    private Promise<String> jsVariableToString(JavaScriptVariable variable) {
        return variable.getValue().getClassName().thenAsync(type -> variable.getValue().getRepresentation().then(repr -> variable.getName() + ": " + type + " (" + repr + ")"));
    }

    private /* synthetic */ void lambda$stdinThread$5(String line, BlockingQueue callbackQueue) {
        this.processSingleCommand(line).then(r -> callbackQueue.offer(r)).catchError(e -> {
            e.printStackTrace();
            return true;
        });
    }

    private static interface Command {
        public Promise<Void> execute(String[] var1);
    }
}

