/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.chromerdp.ChromeRDPExchange;
import org.teavm.chromerdp.ChromeRDPExchangeConsumer;
import org.teavm.chromerdp.ChromeRDPExchangeListener;
import org.teavm.chromerdp.RDPBreakpoint;
import org.teavm.chromerdp.RDPCallFrame;
import org.teavm.chromerdp.RDPLocalVariable;
import org.teavm.chromerdp.RDPNativeBreakpoint;
import org.teavm.chromerdp.RDPValue;
import org.teavm.chromerdp.data.CallArgumentDTO;
import org.teavm.chromerdp.data.CallFrameDTO;
import org.teavm.chromerdp.data.LocationDTO;
import org.teavm.chromerdp.data.Message;
import org.teavm.chromerdp.data.PropertyDescriptorDTO;
import org.teavm.chromerdp.data.RemoteObjectDTO;
import org.teavm.chromerdp.data.Response;
import org.teavm.chromerdp.data.ScopeDTO;
import org.teavm.chromerdp.messages.CallFunctionCommand;
import org.teavm.chromerdp.messages.CallFunctionResponse;
import org.teavm.chromerdp.messages.CompileScriptCommand;
import org.teavm.chromerdp.messages.CompileScriptResponse;
import org.teavm.chromerdp.messages.ContinueToLocationCommand;
import org.teavm.chromerdp.messages.GetPropertiesCommand;
import org.teavm.chromerdp.messages.GetPropertiesResponse;
import org.teavm.chromerdp.messages.RemoveBreakpointCommand;
import org.teavm.chromerdp.messages.RunScriptCommand;
import org.teavm.chromerdp.messages.ScriptParsedNotification;
import org.teavm.chromerdp.messages.SetBreakpointCommand;
import org.teavm.chromerdp.messages.SetBreakpointResponse;
import org.teavm.chromerdp.messages.SuspendedNotification;
import org.teavm.common.CompletablePromise;
import org.teavm.common.Promise;
import org.teavm.debugging.javascript.JavaScriptBreakpoint;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptDebuggerListener;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.debugging.javascript.JavaScriptVariable;

public class ChromeRDPDebugger
implements JavaScriptDebugger,
ChromeRDPExchangeConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ChromeRDPDebugger.class);
    private static final Promise<Map<String, ? extends JavaScriptVariable>> EMPTY_SCOPE = Promise.of(Collections.emptyMap());
    private volatile ChromeRDPExchange exchange;
    private Set<JavaScriptDebuggerListener> listeners = new LinkedHashSet<JavaScriptDebuggerListener>();
    private Map<JavaScriptLocation, RDPNativeBreakpoint> breakpointLocationMap = new HashMap<JavaScriptLocation, RDPNativeBreakpoint>();
    private Set<RDPBreakpoint> breakpoints = new LinkedHashSet<RDPBreakpoint>();
    private Map<String, RDPNativeBreakpoint> breakpointsByChromeId = new HashMap<String, RDPNativeBreakpoint>();
    private volatile RDPCallFrame[] callStack = new RDPCallFrame[0];
    private Map<String, String> scripts = new HashMap<String, String>();
    private Map<String, String> scriptIds = new HashMap<String, String>();
    private volatile boolean suspended;
    private ObjectMapper mapper = new ObjectMapper();
    private ConcurrentMap<Integer, ResponseHandler<Object>> responseHandlers = new ConcurrentHashMap<Integer, ResponseHandler<Object>>();
    private ConcurrentMap<Integer, CompletablePromise<Object>> promises = new ConcurrentHashMap<Integer, CompletablePromise<Object>>();
    private AtomicInteger messageIdGenerator = new AtomicInteger();
    private Promise<Void> runtimeEnabledPromise;
    private Executor executor;
    private ChromeRDPExchangeListener exchangeListener = messageText -> this.callInExecutor(() -> this.receiveMessage(messageText).catchError(e -> {
        logger.error("Error handling message", e);
        return null;
    }));

    private List<JavaScriptDebuggerListener> getListeners() {
        return new ArrayList<JavaScriptDebuggerListener>(this.listeners);
    }

    public ChromeRDPDebugger(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void setExchange(ChromeRDPExchange exchange) {
        if (this.exchange == exchange) {
            return;
        }
        if (this.exchange != null) {
            this.exchange.removeListener(this.exchangeListener);
        }
        this.exchange = exchange;
        if (exchange != null) {
            for (RDPBreakpoint breakpoint : this.breakpoints.toArray(new RDPBreakpoint[0])) {
                this.updateBreakpoint(breakpoint.nativeBreakpoint);
            }
            for (JavaScriptDebuggerListener listener : this.getListeners()) {
                listener.attached();
            }
        } else {
            this.suspended = false;
            this.callStack = null;
            for (JavaScriptDebuggerListener listener : this.getListeners()) {
                listener.detached();
            }
        }
        if (this.exchange != null) {
            this.exchange.addListener(this.exchangeListener);
        }
    }

    private Promise<Void> injectFunctions(int contextId) {
        return this.enableRuntime().thenAsync(v -> {
            CompileScriptCommand compileParams = new CompileScriptCommand();
            compileParams.expression = "$dbg_class = function(obj) { return typeof obj === 'object' && obj !== null && '__teavm_class__' in obj ? obj.__teavm_class__() : null; };\n$dbg_repr = function(obj) { return typeof obj === 'object' && obj !== null && 'toString' in obj ? obj.toString() : null; }\n";
            compileParams.sourceURL = "file://fake";
            compileParams.persistScript = true;
            compileParams.executionContextId = contextId;
            return this.callMethodAsync("Runtime.compileScript", CompileScriptResponse.class, compileParams);
        }).thenAsync(response -> {
            RunScriptCommand runParams = new RunScriptCommand();
            runParams.scriptId = response.scriptId;
            return this.callMethodAsync("Runtime.runScript", Void.TYPE, runParams);
        });
    }

    private Promise<Void> enableRuntime() {
        if (this.runtimeEnabledPromise == null) {
            this.runtimeEnabledPromise = this.callMethodAsync("Runtime.enable", Void.TYPE, null);
        }
        return this.runtimeEnabledPromise;
    }

    private Promise<Void> receiveMessage(String messageText) {
        try {
            JsonNode jsonMessage = this.mapper.readTree(messageText);
            if (jsonMessage.has("id")) {
                Response response = (Response)this.mapper.readerFor(Response.class).readValue(jsonMessage);
                if (response.getError() != null && logger.isWarnEnabled()) {
                    logger.warn("Error message #{} received from browser: {}", (Object)jsonMessage.get("id"), (Object)response.getError().toString());
                }
                CompletablePromise promise = (CompletablePromise)this.promises.remove(response.getId());
                try {
                    ((ResponseHandler)this.responseHandlers.remove(response.getId())).received(response.getResult(), promise);
                }
                catch (RuntimeException e) {
                    logger.warn("Error processing message ${}", (Object)response.getId(), (Object)e);
                    promise.completeWithError((Throwable)e);
                }
                return Promise.VOID;
            }
            Message message = (Message)this.mapper.readerFor(Message.class).readValue(messageText);
            if (message.getMethod() == null) {
                return Promise.VOID;
            }
            switch (message.getMethod()) {
                case "Debugger.paused": {
                    return this.firePaused(this.parseJson(SuspendedNotification.class, message.getParams()));
                }
                case "Debugger.resumed": {
                    return this.fireResumed();
                }
                case "Debugger.scriptParsed": {
                    return this.scriptParsed(this.parseJson(ScriptParsedNotification.class, message.getParams()));
                }
            }
            return Promise.VOID;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("Error receiving message from Google Chrome", (Throwable)e);
            }
            return Promise.VOID;
        }
    }

    private Promise<Void> firePaused(SuspendedNotification params) {
        this.suspended = true;
        CallFrameDTO[] callFrameDTOs = params.getCallFrames();
        RDPCallFrame[] callStack = new RDPCallFrame[callFrameDTOs.length];
        for (int i = 0; i < callStack.length; ++i) {
            callStack[i] = this.map(callFrameDTOs[i]);
        }
        this.callStack = callStack;
        RDPNativeBreakpoint nativeBreakpoint = null;
        if (params.getHitBreakpoints() != null && !params.getHitBreakpoints().isEmpty()) {
            nativeBreakpoint = this.breakpointsByChromeId.get(params.getHitBreakpoints().get(0));
        }
        RDPBreakpoint breakpoint = !nativeBreakpoint.breakpoints.isEmpty() ? nativeBreakpoint.breakpoints.iterator().next() : null;
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.paused((JavaScriptBreakpoint)breakpoint);
        }
        return Promise.VOID;
    }

    private Promise<Void> fireResumed() {
        this.suspended = false;
        this.callStack = null;
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.resumed();
        }
        return Promise.VOID;
    }

    private Promise<Void> scriptParsed(ScriptParsedNotification params) {
        if (params.getUrl() == null) {
            return Promise.VOID;
        }
        if (this.scripts.putIfAbsent(params.getScriptId(), params.getUrl()) != null) {
            return Promise.VOID;
        }
        if (params.getUrl().equals("file://fake")) {
            return Promise.VOID;
        }
        this.scriptIds.put(params.getUrl(), params.getScriptId());
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.scriptAdded(params.getUrl());
        }
        return this.injectFunctions(params.getExecutionContextId());
    }

    public void addListener(JavaScriptDebuggerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JavaScriptDebuggerListener listener) {
        this.listeners.remove(listener);
    }

    public Promise<Void> suspend() {
        return this.callMethodAsync("Debugger.pause", Void.TYPE, null);
    }

    public Promise<Void> resume() {
        return this.callMethodAsync("Debugger.resume", Void.TYPE, null);
    }

    public Promise<Void> stepInto() {
        return this.callMethodAsync("Debugger.stepInto", Void.TYPE, null);
    }

    public Promise<Void> stepOut() {
        return this.callMethodAsync("Debugger.stepOut", Void.TYPE, null);
    }

    public Promise<Void> stepOver() {
        return this.callMethodAsync("Debugger.stepOver", Void.TYPE, null);
    }

    public Promise<Void> continueToLocation(JavaScriptLocation location) {
        ContinueToLocationCommand params = new ContinueToLocationCommand();
        params.setLocation(this.unmap(location));
        return this.callMethodAsync("Debugger.continueToLocation", Void.TYPE, params);
    }

    public boolean isSuspended() {
        return this.exchange != null && this.suspended;
    }

    public boolean isAttached() {
        return this.exchange != null;
    }

    public void detach() {
        if (this.exchange != null) {
            this.exchange.disconnect();
        }
    }

    public JavaScriptCallFrame[] getCallStack() {
        if (this.exchange == null) {
            return null;
        }
        RDPCallFrame[] callStack = this.callStack;
        return callStack != null ? (JavaScriptCallFrame[])callStack.clone() : null;
    }

    public Promise<JavaScriptBreakpoint> createBreakpoint(JavaScriptLocation location) {
        RDPBreakpoint breakpoint = new RDPBreakpoint(this);
        breakpoint.nativeBreakpoint = this.lockNativeBreakpoint(location, breakpoint);
        CompletablePromise result = new CompletablePromise();
        this.breakpoints.add(breakpoint);
        breakpoint.nativeBreakpoint.initPromise.thenVoid(v -> result.complete((Object)breakpoint));
        return result;
    }

    Promise<Void> destroyBreakpoint(RDPBreakpoint breakpoint) {
        if (breakpoint.nativeBreakpoint == null) {
            return Promise.VOID;
        }
        RDPNativeBreakpoint nativeBreakpoint = breakpoint.nativeBreakpoint;
        breakpoint.nativeBreakpoint = null;
        nativeBreakpoint.breakpoints.remove(breakpoint);
        this.breakpoints.remove(breakpoint);
        return this.releaseNativeBreakpoint(nativeBreakpoint, breakpoint);
    }

    private RDPNativeBreakpoint lockNativeBreakpoint(JavaScriptLocation location, RDPBreakpoint bp) {
        RDPNativeBreakpoint breakpoint = this.breakpointLocationMap.get(location);
        if (breakpoint != null) {
            breakpoint.breakpoints.add(bp);
            return breakpoint;
        }
        breakpoint = new RDPNativeBreakpoint(this, location);
        breakpoint.breakpoints.add(bp);
        this.breakpointLocationMap.put(location, breakpoint);
        RDPNativeBreakpoint finalBreakpoint = breakpoint;
        breakpoint.initPromise = this.updateBreakpoint(breakpoint).then(v -> {
            this.checkBreakpoint(finalBreakpoint);
            return null;
        });
        return breakpoint;
    }

    private Promise<Void> releaseNativeBreakpoint(RDPNativeBreakpoint breakpoint, RDPBreakpoint bp) {
        breakpoint.breakpoints.remove(bp);
        return this.checkBreakpoint(breakpoint);
    }

    private Promise<Void> checkBreakpoint(RDPNativeBreakpoint breakpoint) {
        if (!breakpoint.breakpoints.isEmpty()) {
            return Promise.VOID;
        }
        if (this.breakpointLocationMap.get(breakpoint.getLocation()) == breakpoint) {
            this.breakpointLocationMap.remove(breakpoint.getLocation());
        }
        if (breakpoint.destroyPromise == null) {
            breakpoint.destroyPromise = breakpoint.initPromise.thenAsync(v -> {
                this.breakpointsByChromeId.remove(breakpoint.chromeId);
                if (logger.isInfoEnabled()) {
                    logger.info("Removing breakpoint at {}", (Object)breakpoint.getLocation());
                }
                RemoveBreakpointCommand params = new RemoveBreakpointCommand();
                params.setBreakpointId(breakpoint.chromeId);
                return this.callMethodAsync("Debugger.removeBreakpoint", Void.TYPE, params);
            });
            breakpoint.debugger = null;
        }
        return breakpoint.destroyPromise;
    }

    private Promise<Void> updateBreakpoint(RDPNativeBreakpoint breakpoint) {
        if (breakpoint.chromeId != null) {
            return Promise.VOID;
        }
        SetBreakpointCommand params = new SetBreakpointCommand();
        params.setLocation(this.unmap(breakpoint.getLocation()));
        if (logger.isInfoEnabled()) {
            logger.info("Setting breakpoint at {}", (Object)breakpoint.getLocation());
        }
        return this.callMethodAsync("Debugger.setBreakpoint", SetBreakpointResponse.class, params).thenVoid(response -> {
            if (response != null) {
                breakpoint.chromeId = response.getBreakpointId();
                if (breakpoint.chromeId != null) {
                    this.breakpointsByChromeId.put(breakpoint.chromeId, breakpoint);
                }
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("Error setting breakpoint at {}", (Object)breakpoint.getLocation());
                }
                breakpoint.chromeId = null;
            }
            for (RDPBreakpoint bp : breakpoint.breakpoints) {
                for (JavaScriptDebuggerListener listener : this.getListeners()) {
                    listener.breakpointChanged((JavaScriptBreakpoint)bp);
                }
            }
        });
    }

    Promise<List<RDPLocalVariable>> getScope(String scopeId) {
        GetPropertiesCommand params = new GetPropertiesCommand();
        params.setObjectId(scopeId);
        params.setOwnProperties(true);
        return this.callMethodAsync("Runtime.getProperties", GetPropertiesResponse.class, params).thenAsync(response -> {
            if (response == null) {
                return Promise.of(Collections.emptyList());
            }
            PropertyDescriptorDTO proto = Arrays.asList(response.getResult()).stream().filter(p -> p.getName().equals("__proto__")).findAny().orElse(null);
            if (proto == null || proto.getValue() == null || proto.getValue().getObjectId() == null) {
                return Promise.of(this.parseProperties(scopeId, response.getResult(), null));
            }
            GetPropertiesCommand protoParams = new GetPropertiesCommand();
            protoParams.setObjectId(proto.getValue().getObjectId());
            protoParams.setOwnProperties(false);
            return this.callMethodAsync("Runtime.getProperties", GetPropertiesResponse.class, protoParams).then(protoProperties -> {
                PropertyDescriptorDTO[] getters = (PropertyDescriptorDTO[])Arrays.asList(protoProperties.getResult()).stream().filter(p -> p.getGetter() != null && p.getValue() == null && !p.getName().equals("__proto__")).toArray(PropertyDescriptorDTO[]::new);
                return this.parseProperties(scopeId, response.getResult(), getters);
            });
        });
    }

    Promise<String> getClassName(String objectId) {
        CallFunctionCommand params = new CallFunctionCommand();
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("$dbg_class");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result = response != null ? response.getResult() : null;
            return result.getValue() != null ? result.getValue().textValue() : null;
        });
    }

    Promise<String> getRepresentation(String objectId) {
        CallFunctionCommand params = new CallFunctionCommand();
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("$dbg_repr");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result = response != null ? response.getResult() : null;
            return result.getValue() != null ? result.getValue().textValue() : null;
        });
    }

    private List<RDPLocalVariable> parseProperties(String scopeId, PropertyDescriptorDTO[] properties, PropertyDescriptorDTO[] getters) {
        ArrayList<RDPLocalVariable> variables = new ArrayList<RDPLocalVariable>();
        if (properties != null) {
            for (PropertyDescriptorDTO property : properties) {
                RemoteObjectDTO remoteValue = property.getValue();
                RemoteObjectDTO getter = property.getGetter();
                RDPValue value = remoteValue != null && remoteValue.getType() != null ? this.mapValue(remoteValue) : (getter != null && getter.getObjectId() != null ? this.mapValue(getter) : new RDPValue(this, "null", "null", null, false));
                RDPLocalVariable var = new RDPLocalVariable(property.getName(), value);
                variables.add(var);
            }
        }
        if (getters != null) {
            for (PropertyDescriptorDTO property : getters) {
                RDPValue value = new RDPValue(this, "<get>", "@Function", scopeId, true);
                value.getter = property.getGetter();
                RDPLocalVariable var = new RDPLocalVariable(property.getName(), value);
                variables.add(var);
            }
        }
        return variables;
    }

    Promise<RDPValue> invokeGetter(String functionId, String objectId) {
        CallFunctionCommand params = new CallFunctionCommand();
        params.setObjectId(functionId);
        CallArgumentDTO functionArg = new CallArgumentDTO();
        functionArg.setObjectId(functionId);
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("Function.prototype.call");
        return this.callMethodAsync("Runtime.callFunctionOn", CallFunctionResponse.class, params).then(response -> {
            RemoteObjectDTO result = response != null ? response.getResult() : null;
            return result.getValue() != null ? this.mapValue(result) : null;
        });
    }

    RDPValue mapValue(RemoteObjectDTO remoteValue) {
        switch (remoteValue.getType()) {
            case "undefined": {
                return new RDPValue(this, "undefined", "undefined", null, false);
            }
            case "object": 
            case "function": {
                if (remoteValue.getValue() instanceof NullNode) {
                    return new RDPValue(this, "null", "null", null, false);
                }
                return new RDPValue(this, null, remoteValue.getType(), remoteValue.getObjectId(), true);
            }
        }
        return new RDPValue(this, remoteValue.getValue().asText(), remoteValue.getType(), remoteValue.getObjectId(), false);
    }

    private <T> T parseJson(Class<T> type, JsonNode node) throws IOException {
        return (T)this.mapper.readerFor(type).readValue(node);
    }

    private void sendMessage(Message message) {
        if (this.exchange == null) {
            return;
        }
        try {
            this.exchange.send(this.mapper.writer().writeValueAsString((Object)message));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RDPCallFrame map(CallFrameDTO dto) {
        String scopeId = null;
        RDPValue thisObject = null;
        RDPValue closure = null;
        block10: for (ScopeDTO scope : dto.getScopeChain()) {
            switch (scope.getType()) {
                case "local": {
                    scopeId = scope.getObject().getObjectId();
                    continue block10;
                }
                case "closure": {
                    closure = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
                    continue block10;
                }
                case "global": {
                    thisObject = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
                }
            }
        }
        return new RDPCallFrame(this, dto.getCallFrameId(), this.map(dto.getLocation()), scopeId, thisObject, closure);
    }

    private JavaScriptLocation map(LocationDTO dto) {
        return new JavaScriptLocation(this.scripts.get(dto.getScriptId()), dto.getLineNumber(), dto.getColumnNumber());
    }

    private LocationDTO unmap(JavaScriptLocation location) {
        LocationDTO dto = new LocationDTO();
        dto.setScriptId(this.scriptIds.get(location.getScript()));
        dto.setLineNumber(location.getLine());
        dto.setColumnNumber(location.getColumn());
        return dto;
    }

    private <R> Promise<R> callMethodAsync(String method, Class<R> returnType, Object params) {
        if (this.exchange == null) {
            return Promise.of(null);
        }
        Message message = new Message();
        message.setId(this.messageIdGenerator.incrementAndGet());
        message.setMethod(method);
        if (params != null) {
            message.setParams(this.mapper.valueToTree(params));
        }
        this.sendMessage(message);
        return this.setResponseHandler(message.getId(), (node, out) -> {
            if (node == null) {
                out.complete(null);
            } else {
                Object response = returnType != Void.TYPE ? this.mapper.readerFor(returnType).readValue(node) : null;
                out.complete(response);
            }
        });
    }

    private <T> Promise<T> setResponseHandler(int messageId, ResponseHandler<T> handler) {
        CompletablePromise promise = new CompletablePromise();
        this.promises.put(messageId, (CompletablePromise<Object>)promise);
        this.responseHandlers.put(messageId, handler);
        return promise;
    }

    Promise<Map<String, ? extends JavaScriptVariable>> createScope(String id) {
        if (id == null) {
            return EMPTY_SCOPE;
        }
        return this.getScope(id).then(scope -> {
            HashMap<String, RDPLocalVariable> newBackingMap = new HashMap<String, RDPLocalVariable>();
            for (RDPLocalVariable variable : scope) {
                newBackingMap.put(variable.getName(), variable);
            }
            return Collections.unmodifiableMap(newBackingMap);
        });
    }

    private <T> Promise<T> callInExecutor(Supplier<Promise<T>> f) {
        CompletablePromise result = new CompletablePromise();
        this.executor.execute(() -> ((Promise)f.get()).thenVoid(arg_0 -> ((CompletablePromise)result).complete(arg_0)).catchVoid(arg_0 -> ((CompletablePromise)result).completeWithError(arg_0)));
        return result;
    }

    static interface ResponseHandler<T> {
        public void received(JsonNode var1, CompletablePromise<T> var2) throws IOException;
    }
}

