/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.chromerdp.ChromeRDPDebugger;
import org.teavm.chromerdp.RDPScope;
import org.teavm.debugging.javascript.JavaScriptValue;
import org.teavm.debugging.javascript.JavaScriptVariable;

public class RDPValue
implements JavaScriptValue {
    private AtomicReference<String> representation = new AtomicReference();
    private AtomicReference<String> className = new AtomicReference();
    private String typeName;
    private ChromeRDPDebugger debugger;
    private String objectId;
    private Map<String, ? extends JavaScriptVariable> properties;
    private boolean innerStructure;

    public RDPValue(ChromeRDPDebugger debugger, String representation, String typeName, String objectId, boolean innerStructure) {
        this.representation.set(representation == null && objectId == null ? "" : representation);
        this.typeName = typeName;
        this.debugger = debugger;
        this.objectId = objectId;
        this.innerStructure = innerStructure;
        this.properties = objectId != null ? new RDPScope(debugger, objectId) : Collections.emptyMap();
    }

    public String getRepresentation() {
        if (this.representation.get() == null) {
            this.representation.compareAndSet(null, this.debugger.getRepresentation(this.objectId));
        }
        return this.representation.get();
    }

    public String getClassName() {
        if (this.className.get() == null) {
            if (this.objectId != null) {
                String computedClassName = this.debugger.getClassName(this.objectId);
                this.className.compareAndSet(null, computedClassName != null ? computedClassName : "@Object");
            } else {
                this.className.compareAndSet(null, "@" + this.typeName);
            }
        }
        return this.className.get();
    }

    public Map<String, JavaScriptVariable> getProperties() {
        return this.properties;
    }

    public boolean hasInnerStructure() {
        return this.innerStructure;
    }

    public String getInstanceId() {
        return this.objectId;
    }
}

