/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.chromerdp.ChromeRDPExchange;
import org.teavm.chromerdp.ChromeRDPExchangeConsumer;
import org.teavm.chromerdp.ChromeRDPExchangeListener;
import org.teavm.chromerdp.RDPBreakpoint;
import org.teavm.chromerdp.RDPCallFrame;
import org.teavm.chromerdp.RDPLocalVariable;
import org.teavm.chromerdp.RDPScope;
import org.teavm.chromerdp.RDPValue;
import org.teavm.chromerdp.data.CallArgumentDTO;
import org.teavm.chromerdp.data.CallFrameDTO;
import org.teavm.chromerdp.data.LocationDTO;
import org.teavm.chromerdp.data.Message;
import org.teavm.chromerdp.data.PropertyDescriptorDTO;
import org.teavm.chromerdp.data.RemoteObjectDTO;
import org.teavm.chromerdp.data.Response;
import org.teavm.chromerdp.data.ScopeDTO;
import org.teavm.chromerdp.messages.CallFunctionCommand;
import org.teavm.chromerdp.messages.CallFunctionResponse;
import org.teavm.chromerdp.messages.ContinueToLocationCommand;
import org.teavm.chromerdp.messages.GetPropertiesCommand;
import org.teavm.chromerdp.messages.GetPropertiesResponse;
import org.teavm.chromerdp.messages.RemoveBreakpointCommand;
import org.teavm.chromerdp.messages.ScriptParsedNotification;
import org.teavm.chromerdp.messages.SetBreakpointCommand;
import org.teavm.chromerdp.messages.SetBreakpointResponse;
import org.teavm.chromerdp.messages.SuspendedNotification;
import org.teavm.debugging.javascript.JavaScriptBreakpoint;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptDebuggerListener;
import org.teavm.debugging.javascript.JavaScriptLocation;

public class ChromeRDPDebugger
implements JavaScriptDebugger,
ChromeRDPExchangeConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ChromeRDPDebugger.class);
    private static final Object dummy = new Object();
    private ChromeRDPExchange exchange;
    private ConcurrentMap<JavaScriptDebuggerListener, Object> listeners = new ConcurrentHashMap<JavaScriptDebuggerListener, Object>();
    private ConcurrentMap<JavaScriptLocation, RDPBreakpoint> breakpointLocationMap = new ConcurrentHashMap<JavaScriptLocation, RDPBreakpoint>();
    private ConcurrentMap<RDPBreakpoint, Object> breakpoints = new ConcurrentHashMap<RDPBreakpoint, Object>();
    private volatile RDPCallFrame[] callStack = new RDPCallFrame[0];
    private ConcurrentMap<String, String> scripts = new ConcurrentHashMap<String, String>();
    private ConcurrentMap<String, String> scriptIds = new ConcurrentHashMap<String, String>();
    private boolean suspended;
    private ObjectMapper mapper = new ObjectMapper();
    private ConcurrentMap<Integer, ResponseHandler> responseHandlers = new ConcurrentHashMap<Integer, ResponseHandler>();
    private AtomicInteger messageIdGenerator = new AtomicInteger();
    private Lock breakpointLock = new ReentrantLock();
    private ChromeRDPExchangeListener exchangeListener = new ChromeRDPExchangeListener(){

        @Override
        public void received(String messageText) throws IOException {
            ChromeRDPDebugger.this.receiveMessage(messageText);
        }
    };

    private List<JavaScriptDebuggerListener> getListeners() {
        return new ArrayList<JavaScriptDebuggerListener>(this.listeners.keySet());
    }

    @Override
    public void setExchange(ChromeRDPExchange exchange) {
        if (this.exchange == exchange) {
            return;
        }
        if (this.exchange != null) {
            this.exchange.removeListener(this.exchangeListener);
        }
        this.exchange = exchange;
        if (exchange != null) {
            for (RDPBreakpoint breakpoint : this.breakpoints.keySet().toArray(new RDPBreakpoint[0])) {
                this.updateBreakpoint(breakpoint);
            }
            for (JavaScriptDebuggerListener listener : this.getListeners()) {
                listener.attached();
            }
        } else {
            this.suspended = false;
            this.callStack = null;
            for (JavaScriptDebuggerListener listener : this.getListeners()) {
                listener.detached();
            }
        }
        if (this.exchange != null) {
            this.exchange.addListener(this.exchangeListener);
        }
    }

    private void receiveMessage(final String messageText) {
        new Thread(){

            @Override
            public void run() {
                block16: {
                    try {
                        JsonNode jsonMessage = ChromeRDPDebugger.this.mapper.readTree(messageText);
                        if (jsonMessage.has("id")) {
                            Response response = (Response)ChromeRDPDebugger.this.mapper.reader(Response.class).readValue(jsonMessage);
                            if (response.getError() != null && logger.isWarnEnabled()) {
                                logger.warn("Error message #{} received from browser: {}", (Object)jsonMessage.get("id"), (Object)response.getError().toString());
                            }
                            ((ResponseHandler)ChromeRDPDebugger.this.responseHandlers.remove(response.getId())).received(response.getResult());
                        } else {
                            Message message = (Message)ChromeRDPDebugger.this.mapper.reader(Message.class).readValue(messageText);
                            if (message.getMethod() == null) {
                                return;
                            }
                            switch (message.getMethod()) {
                                case "Debugger.paused": {
                                    ChromeRDPDebugger.this.firePaused((SuspendedNotification)ChromeRDPDebugger.this.parseJson(SuspendedNotification.class, message.getParams()));
                                    break;
                                }
                                case "Debugger.resumed": {
                                    ChromeRDPDebugger.this.fireResumed();
                                    break;
                                }
                                case "Debugger.scriptParsed": {
                                    ChromeRDPDebugger.this.scriptParsed((ScriptParsedNotification)ChromeRDPDebugger.this.parseJson(ScriptParsedNotification.class, message.getParams()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) break block16;
                        logger.error("Error receiving message from Google Chrome", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    private synchronized void firePaused(SuspendedNotification params) {
        this.suspended = true;
        CallFrameDTO[] callFrameDTOs = params.getCallFrames();
        RDPCallFrame[] callStack = new RDPCallFrame[callFrameDTOs.length];
        for (int i = 0; i < callStack.length; ++i) {
            callStack[i] = this.map(callFrameDTOs[i]);
        }
        this.callStack = callStack;
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.paused();
        }
    }

    private synchronized void fireResumed() {
        this.suspended = false;
        this.callStack = null;
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.resumed();
        }
    }

    private synchronized void scriptParsed(ScriptParsedNotification params) {
        if (this.scripts.putIfAbsent(params.getScriptId(), params.getUrl()) != null) {
            return;
        }
        this.scriptIds.put(params.getUrl(), params.getScriptId());
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.scriptAdded(params.getUrl());
        }
    }

    public void addListener(JavaScriptDebuggerListener listener) {
        this.listeners.put(listener, dummy);
    }

    public void removeListener(JavaScriptDebuggerListener listener) {
        this.listeners.remove(listener);
    }

    public void suspend() {
        if (this.exchange == null) {
            return;
        }
        Message message = new Message();
        message.setMethod("Debugger.pause");
        this.sendMessage(message);
    }

    public void resume() {
        if (this.exchange == null) {
            return;
        }
        Message message = new Message();
        message.setMethod("Debugger.resume");
        this.sendMessage(message);
    }

    public void stepInto() {
        if (this.exchange == null) {
            return;
        }
        Message message = new Message();
        message.setMethod("Debugger.stepInto");
        this.sendMessage(message);
    }

    public void stepOut() {
        if (this.exchange == null) {
            return;
        }
        Message message = new Message();
        message.setMethod("Debugger.stepOut");
        this.sendMessage(message);
    }

    public void stepOver() {
        if (this.exchange == null) {
            return;
        }
        Message message = new Message();
        message.setMethod("Debugger.stepOver");
        this.sendMessage(message);
    }

    public void continueToLocation(JavaScriptLocation location) {
        if (this.exchange == null) {
            return;
        }
        Message message = new Message();
        message.setMethod("Debugger.continueToLocation");
        ContinueToLocationCommand params = new ContinueToLocationCommand();
        params.setLocation(this.unmap(location));
        message.setParams(this.mapper.valueToTree((Object)params));
        this.sendMessage(message);
    }

    public boolean isSuspended() {
        return this.exchange != null && this.suspended;
    }

    public boolean isAttached() {
        return this.exchange != null;
    }

    public void detach() {
        if (this.exchange != null) {
            this.exchange.disconnect();
        }
    }

    public JavaScriptCallFrame[] getCallStack() {
        if (this.exchange == null) {
            return null;
        }
        RDPCallFrame[] callStack = this.callStack;
        return callStack != null ? (JavaScriptCallFrame[])callStack.clone() : null;
    }

    public JavaScriptBreakpoint createBreakpoint(JavaScriptLocation location) {
        RDPBreakpoint breakpoint;
        this.breakpointLock.lock();
        try {
            breakpoint = (RDPBreakpoint)this.breakpointLocationMap.get(location);
            if (breakpoint == null) {
                breakpoint = new RDPBreakpoint(this, location);
                this.breakpointLocationMap.put(location, breakpoint);
                this.updateBreakpoint(breakpoint);
            }
            breakpoint.referenceCount.incrementAndGet();
            this.breakpoints.put(breakpoint, dummy);
        }
        finally {
            this.breakpointLock.unlock();
        }
        return breakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyBreakpoint(RDPBreakpoint breakpoint) {
        if (breakpoint.referenceCount.decrementAndGet() > 0) {
            return;
        }
        this.breakpointLock.lock();
        try {
            if (breakpoint.referenceCount.get() > 0) {
                return;
            }
            this.breakpointLocationMap.remove(breakpoint.getLocation());
            this.breakpoints.remove(breakpoint);
            if (breakpoint.chromeId != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Removing breakpoint at {}", (Object)breakpoint.getLocation());
                }
                Message message = new Message();
                message.setMethod("Debugger.removeBreakpoint");
                RemoveBreakpointCommand params = new RemoveBreakpointCommand();
                params.setBreakpointId(breakpoint.chromeId);
                message.setParams(this.mapper.valueToTree((Object)params));
                this.sendMessage(message);
            }
            breakpoint.debugger = null;
            breakpoint.chromeId = null;
        }
        finally {
            this.breakpointLock.unlock();
        }
    }

    void fireScriptAdded(String script) {
        for (JavaScriptDebuggerListener listener : this.getListeners()) {
            listener.scriptAdded(script);
        }
    }

    void updateBreakpoint(final RDPBreakpoint breakpoint) {
        if (this.exchange == null || breakpoint.chromeId != null) {
            return;
        }
        final Message message = new Message();
        message.setId(this.messageIdGenerator.incrementAndGet());
        message.setMethod("Debugger.setBreakpoint");
        SetBreakpointCommand params = new SetBreakpointCommand();
        params.setLocation(this.unmap(breakpoint.getLocation()));
        message.setParams(this.mapper.valueToTree((Object)params));
        if (logger.isInfoEnabled()) {
            logger.info("Setting breakpoint at {}, message id is ", (Object)breakpoint.getLocation(), (Object)message.getId());
        }
        ResponseHandler handler = new ResponseHandler(){

            @Override
            public void received(JsonNode node) throws IOException {
                if (node != null) {
                    SetBreakpointResponse response = (SetBreakpointResponse)ChromeRDPDebugger.this.mapper.reader(SetBreakpointResponse.class).readValue(node);
                    breakpoint.chromeId = response.getBreakpointId();
                } else {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Error setting breakpoint at {}, message id is {}", (Object)breakpoint.getLocation(), (Object)message.getId());
                    }
                    breakpoint.chromeId = null;
                }
                for (JavaScriptDebuggerListener listener : ChromeRDPDebugger.this.getListeners()) {
                    listener.breakpointChanged((JavaScriptBreakpoint)breakpoint);
                }
            }
        };
        this.responseHandlers.put(message.getId(), handler);
        this.sendMessage(message);
    }

    List<RDPLocalVariable> getScope(String scopeId) {
        if (this.exchange == null) {
            return Collections.emptyList();
        }
        Message message = new Message();
        message.setId(this.messageIdGenerator.incrementAndGet());
        message.setMethod("Runtime.getProperties");
        GetPropertiesCommand params = new GetPropertiesCommand();
        params.setObjectId(scopeId);
        params.setOwnProperties(true);
        message.setParams(this.mapper.valueToTree((Object)params));
        final LinkedTransferQueue sync = new LinkedTransferQueue();
        this.responseHandlers.put(message.getId(), new ResponseHandler(){

            @Override
            public void received(JsonNode node) throws IOException {
                GetPropertiesResponse response = (GetPropertiesResponse)ChromeRDPDebugger.this.mapper.reader(GetPropertiesResponse.class).readValue(node);
                sync.add(ChromeRDPDebugger.this.parseProperties(response.getResult()));
            }
        });
        this.sendMessage(message);
        try {
            return (List)sync.take();
        }
        catch (InterruptedException e) {
            return Collections.emptyList();
        }
    }

    String getClassName(String objectId) {
        if (this.exchange == null) {
            return null;
        }
        Message message = new Message();
        message.setId(this.messageIdGenerator.incrementAndGet());
        message.setMethod("Runtime.callFunctionOn");
        CallFunctionCommand params = new CallFunctionCommand();
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("$dbg_class");
        message.setParams(this.mapper.valueToTree((Object)params));
        final LinkedTransferQueue sync = new LinkedTransferQueue();
        this.responseHandlers.put(message.getId(), new ResponseHandler(){

            @Override
            public void received(JsonNode node) throws IOException {
                if (node == null) {
                    sync.add("");
                } else {
                    CallFunctionResponse response = (CallFunctionResponse)ChromeRDPDebugger.this.mapper.reader(CallFunctionResponse.class).readValue(node);
                    RemoteObjectDTO result = response.getResult();
                    sync.add(result.getValue() != null ? result.getValue().getTextValue() : "");
                }
            }
        });
        this.sendMessage(message);
        try {
            String result = (String)sync.take();
            return result.isEmpty() ? null : result;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    String getRepresentation(String objectId) {
        if (this.exchange == null) {
            return null;
        }
        Message message = new Message();
        message.setId(this.messageIdGenerator.incrementAndGet());
        message.setMethod("Runtime.callFunctionOn");
        CallFunctionCommand params = new CallFunctionCommand();
        CallArgumentDTO arg = new CallArgumentDTO();
        arg.setObjectId(objectId);
        params.setObjectId(objectId);
        params.setArguments(new CallArgumentDTO[]{arg});
        params.setFunctionDeclaration("$dbg_repr");
        message.setParams(this.mapper.valueToTree((Object)params));
        final LinkedTransferQueue sync = new LinkedTransferQueue();
        this.responseHandlers.put(message.getId(), new ResponseHandler(){

            @Override
            public void received(JsonNode node) throws IOException {
                if (node == null) {
                    sync.add(new RepresentationWrapper(null));
                } else {
                    CallFunctionResponse response = (CallFunctionResponse)ChromeRDPDebugger.this.mapper.reader(CallFunctionResponse.class).readValue(node);
                    RemoteObjectDTO result = response.getResult();
                    sync.add(new RepresentationWrapper(result.getValue() != null ? result.getValue().getTextValue() : null));
                }
            }
        });
        this.sendMessage(message);
        try {
            RepresentationWrapper result = (RepresentationWrapper)sync.take();
            return result.repr;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private List<RDPLocalVariable> parseProperties(PropertyDescriptorDTO[] properties) {
        ArrayList<RDPLocalVariable> variables = new ArrayList<RDPLocalVariable>();
        if (properties != null) {
            for (PropertyDescriptorDTO property : properties) {
                RDPValue value;
                RemoteObjectDTO remoteValue = property.getValue();
                if (remoteValue != null && remoteValue.getType() != null) {
                    switch (remoteValue.getType()) {
                        case "undefined": {
                            value = new RDPValue(this, "undefined", "undefined", null, false);
                            break;
                        }
                        case "object": 
                        case "function": {
                            value = new RDPValue(this, null, remoteValue.getType(), remoteValue.getObjectId(), true);
                            break;
                        }
                        default: {
                            value = new RDPValue(this, remoteValue.getValue().asText(), remoteValue.getType(), remoteValue.getObjectId(), false);
                            break;
                        }
                    }
                } else {
                    value = new RDPValue(this, "null", "null", "null", false);
                }
                RDPLocalVariable var = new RDPLocalVariable(property.getName(), value);
                variables.add(var);
            }
        }
        return variables;
    }

    private <T> T parseJson(Class<T> type, JsonNode node) throws IOException {
        return (T)this.mapper.reader(type).readValue(node);
    }

    private void sendMessage(Message message) {
        if (this.exchange == null) {
            return;
        }
        try {
            this.exchange.send(this.mapper.writer().writeValueAsString((Object)message));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    RDPCallFrame map(CallFrameDTO dto) {
        String scopeId = null;
        RDPValue thisObject = null;
        RDPValue closure = null;
        for (ScopeDTO scope : dto.getScopeChain()) {
            if (scope.getType().equals("local")) {
                scopeId = scope.getObject().getObjectId();
                continue;
            }
            if (scope.getType().equals("closure")) {
                closure = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
                continue;
            }
            if (!scope.getType().equals("global")) continue;
            thisObject = new RDPValue(this, scope.getObject().getDescription(), scope.getObject().getType(), scope.getObject().getObjectId(), true);
        }
        return new RDPCallFrame(this, dto.getCallFrameId(), this.map(dto.getLocation()), new RDPScope(this, scopeId), thisObject, closure);
    }

    JavaScriptLocation map(LocationDTO dto) {
        return new JavaScriptLocation((String)this.scripts.get(dto.getScriptId()), dto.getLineNumber(), dto.getColumnNumber());
    }

    LocationDTO unmap(JavaScriptLocation location) {
        LocationDTO dto = new LocationDTO();
        dto.setScriptId((String)this.scriptIds.get(location.getScript()));
        dto.setLineNumber(location.getLine());
        dto.setColumnNumber(location.getColumn());
        return dto;
    }

    static interface ResponseHandler {
        public void received(JsonNode var1) throws IOException;
    }

    private static class RepresentationWrapper {
        String repr;

        public RepresentationWrapper(String repr) {
            this.repr = repr;
        }
    }
}

