/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.chromerdp.ChromeRDPDebugger;
import org.teavm.chromerdp.RDPLocalVariable;

public class RDPScope
extends AbstractMap<String, RDPLocalVariable> {
    private AtomicReference<Map<String, RDPLocalVariable>> backingMap = new AtomicReference();
    private ChromeRDPDebugger debugger;
    private String id;

    public RDPScope(ChromeRDPDebugger debugger, String id) {
        this.debugger = debugger;
        this.id = id;
    }

    @Override
    public Set<Map.Entry<String, RDPLocalVariable>> entrySet() {
        this.initBackingMap();
        return this.backingMap.get().entrySet();
    }

    @Override
    public int size() {
        this.initBackingMap();
        return this.backingMap.get().size();
    }

    @Override
    public RDPLocalVariable get(Object key) {
        this.initBackingMap();
        return this.backingMap.get().get(key);
    }

    private void initBackingMap() {
        if (this.backingMap.get() != null) {
            return;
        }
        HashMap<String, RDPLocalVariable> newBackingMap = new HashMap<String, RDPLocalVariable>();
        if (this.id != null) {
            for (RDPLocalVariable variable : this.debugger.getScope(this.id)) {
                newBackingMap.put(variable.getName(), variable);
            }
        }
        this.backingMap.compareAndSet(null, newBackingMap);
    }
}

