/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.teavm.chromerdp.ChromeRDPDebuggerEndpoint;
import org.teavm.chromerdp.ChromeRDPExchangeConsumer;

public class ChromeRDPServer {
    private int port = 2357;
    private ChromeRDPExchangeConsumer exchangeConsumer;
    private Server server;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ChromeRDPExchangeConsumer getExchangeConsumer() {
        return this.exchangeConsumer;
    }

    public void setExchangeConsumer(ChromeRDPExchangeConsumer exchangeConsumer) {
        this.exchangeConsumer = exchangeConsumer;
    }

    public void start() {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
        try {
            wscontainer.addEndpoint((ServerEndpointConfig)new RPDEndpointConfig());
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class RPDEndpointConfig
    implements ServerEndpointConfig {
        private Map<String, Object> userProperties = new HashMap<String, Object>();

        public RPDEndpointConfig() {
            this.userProperties.put("chrome.rdp", ChromeRDPServer.this.exchangeConsumer);
        }

        public List<Class<? extends Decoder>> getDecoders() {
            return Collections.emptyList();
        }

        public List<Class<? extends Encoder>> getEncoders() {
            return Collections.emptyList();
        }

        public Map<String, Object> getUserProperties() {
            return this.userProperties;
        }

        public ServerEndpointConfig.Configurator getConfigurator() {
            return null;
        }

        public Class<?> getEndpointClass() {
            return ChromeRDPDebuggerEndpoint.class;
        }

        public List<Extension> getExtensions() {
            return Collections.emptyList();
        }

        public String getPath() {
            return "/";
        }

        public List<String> getSubprotocols() {
            return Collections.emptyList();
        }
    }
}

