/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.teavm.chromerdp.ChromeRDPExchange;
import org.teavm.chromerdp.ChromeRDPExchangeConsumer;
import org.teavm.chromerdp.ChromeRDPExchangeListener;

@ServerEndpoint(value="/")
public class ChromeRDPDebuggerEndpoint
implements ChromeRDPExchange {
    public static final int MAX_MESSAGE_SIZE = 65534;
    private Session session;
    private ChromeRDPExchangeConsumer debugger;
    private List<ChromeRDPExchangeListener> listeners = new ArrayList<ChromeRDPExchangeListener>();
    private StringBuilder messageBuffer = new StringBuilder();

    @OnOpen
    public void open(Session session) {
        this.session = session;
        session.setMaxIdleTimeout(0L);
        Object debugger = session.getUserProperties().get("chrome.rdp");
        if (debugger instanceof ChromeRDPExchangeConsumer) {
            this.debugger = (ChromeRDPExchangeConsumer)debugger;
            this.debugger.setExchange(this);
        }
    }

    @OnClose
    public void close() {
        if (this.debugger != null) {
            this.debugger.setExchange(null);
            this.debugger = null;
        }
    }

    @Override
    public void disconnect() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @OnMessage
    public void receive(String message) throws IOException {
        char ctl = message.charAt(0);
        this.messageBuffer.append(message.substring(1));
        if (ctl == '.') {
            message = this.messageBuffer.toString();
            for (ChromeRDPExchangeListener listener : this.listeners) {
                listener.received(message);
            }
            this.messageBuffer = new StringBuilder();
        }
    }

    @Override
    public void send(String message) {
        int index = 0;
        while (message.length() - index > 65534) {
            int next = index + 65534;
            this.session.getAsyncRemote().sendText("," + message.substring(index, next));
            index = next;
        }
        this.session.getAsyncRemote().sendText("." + message.substring(index));
    }

    @Override
    public void addListener(ChromeRDPExchangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ChromeRDPExchangeListener listener) {
        this.listeners.remove(listener);
    }
}

