/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.chromerdp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.chromerdp.ChromeRDPExchange;
import org.teavm.chromerdp.ChromeRDPExchangeConsumer;
import org.teavm.chromerdp.ChromeRDPExchangeListener;
import org.teavm.chromerdp.data.Message;
import org.teavm.chromerdp.data.Response;
import org.teavm.common.CompletablePromise;
import org.teavm.common.Promise;
import org.teavm.debugging.javascript.JavaScriptDebuggerListener;

public abstract class BaseChromeRDPDebugger
implements ChromeRDPExchangeConsumer {
    protected static final Logger logger = LoggerFactory.getLogger(BaseChromeRDPDebugger.class);
    private ChromeRDPExchange exchange;
    protected Set<JavaScriptDebuggerListener> listeners = new LinkedHashSet<JavaScriptDebuggerListener>();
    protected ObjectMapper mapper = new ObjectMapper();
    private ConcurrentMap<Integer, ResponseHandler<Object>> responseHandlers = new ConcurrentHashMap<Integer, ResponseHandler<Object>>();
    private ConcurrentMap<Integer, CompletablePromise<Object>> promises = new ConcurrentHashMap<Integer, CompletablePromise<Object>>();
    private int messageIdGenerator;
    private Executor executor;
    private ChromeRDPExchangeListener exchangeListener = messageText -> this.callInExecutor(() -> this.receiveMessage(messageText).catchError(e -> {
        logger.error("Error handling message", e);
        return null;
    }));

    protected List<JavaScriptDebuggerListener> getListeners() {
        return new ArrayList<JavaScriptDebuggerListener>(this.listeners);
    }

    public BaseChromeRDPDebugger(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void setExchange(ChromeRDPExchange exchange) {
        if (this.exchange == exchange) {
            return;
        }
        if (this.exchange != null) {
            this.exchange.removeListener(this.exchangeListener);
        }
        this.exchange = exchange;
        if (exchange != null) {
            this.onAttach();
            for (JavaScriptDebuggerListener listener : this.getListeners()) {
                listener.attached();
            }
        } else {
            this.onDetach();
            for (JavaScriptDebuggerListener listener : this.getListeners()) {
                listener.detached();
            }
        }
        if (this.exchange != null) {
            this.exchange.addListener(this.exchangeListener);
        }
    }

    private Promise<Void> receiveMessage(String messageText) {
        try {
            JsonNode jsonMessage = this.mapper.readTree(messageText);
            if (jsonMessage.has("id")) {
                Response response = this.parseJson(Response.class, jsonMessage);
                if (response.getError() != null && logger.isWarnEnabled()) {
                    logger.warn("Error message #{} received from browser: {}", (Object)jsonMessage.get("id"), (Object)response.getError().toString());
                }
                CompletablePromise promise = (CompletablePromise)this.promises.remove(response.getId());
                try {
                    ((ResponseHandler)this.responseHandlers.remove(response.getId())).received(response.getResult(), promise);
                }
                catch (RuntimeException e) {
                    logger.warn("Error processing message ${}", (Object)response.getId(), (Object)e);
                    promise.completeWithError((Throwable)e);
                }
                return Promise.VOID;
            }
            Message message = this.parseJson(Message.class, jsonMessage);
            if (message.getMethod() == null) {
                return Promise.VOID;
            }
            return this.handleMessage(message);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("Error receiving message from Google Chrome", (Throwable)e);
            }
            return Promise.VOID;
        }
    }

    public void detach() {
        if (this.exchange != null) {
            this.exchange.disconnect();
        }
    }

    public boolean isAttached() {
        return this.exchange != null;
    }

    protected abstract void onAttach();

    protected abstract void onDetach();

    protected abstract Promise<Void> handleMessage(Message var1) throws IOException;

    private <T> Promise<T> callInExecutor(Supplier<Promise<T>> f) {
        CompletablePromise result = new CompletablePromise();
        this.executor.execute(() -> ((Promise)f.get()).thenVoid(arg_0 -> ((CompletablePromise)result).complete(arg_0)).catchVoid(arg_0 -> ((CompletablePromise)result).completeWithError(arg_0)));
        return result;
    }

    protected <T> T parseJson(Class<T> type, JsonNode node) throws IOException {
        return (T)this.mapper.readerFor(type).readValue(node);
    }

    protected void sendMessage(Message message) {
        if (this.exchange == null) {
            return;
        }
        try {
            this.exchange.send(this.mapper.writer().writeValueAsString((Object)message));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected <R> Promise<R> callMethodAsync(String method, Class<R> returnType, Object params) {
        if (!this.isAttached()) {
            return Promise.of(null);
        }
        Message message = new Message();
        message.setId(++this.messageIdGenerator);
        message.setMethod(method);
        if (params != null) {
            message.setParams(this.mapper.valueToTree(params));
        } else {
            message.setParams((JsonNode)this.mapper.createObjectNode());
        }
        this.sendMessage(message);
        return this.setResponseHandler(message.getId(), (node, out) -> {
            if (node == null) {
                out.complete(null);
            } else {
                Object response = returnType != Void.TYPE ? this.mapper.readerFor(returnType).readValue(node) : null;
                out.complete(response);
            }
        });
    }

    private <T> Promise<T> setResponseHandler(int messageId, ResponseHandler<T> handler) {
        CompletablePromise promise = new CompletablePromise();
        this.promises.put(messageId, (CompletablePromise<Object>)promise);
        this.responseHandlers.put(messageId, handler);
        return promise;
    }

    static interface ResponseHandler<T> {
        public void received(JsonNode var1, CompletablePromise<T> var2) throws IOException;
    }
}

