/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.testng.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.tap4j.ext.testng.model.TestNGAttribute;
import org.tap4j.ext.testng.util.ExecutionDateCompator;
import org.tap4j.ext.testng.util.TapTestNGYamlUtil;
import org.tap4j.model.Directive;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;
import org.testng.IClass;
import org.testng.IResultMap;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.ResultMap;
import org.testng.internal.TestResult;

public final class TapTestNGUtil {
    public static final Comparator<ITestResult> EXECUTION_DATE_COMPARATOR = new ExecutionDateCompator();

    private TapTestNGUtil() {
    }

    public static org.tap4j.model.TestResult generateTAPTestResult(ITestResult testResult, Integer number, boolean yaml) {
        org.tap4j.model.TestResult tapTestResult = new org.tap4j.model.TestResult();
        String testResultDescription = TapTestNGUtil.generateTAPTestResultDescription(testResult);
        tapTestResult.setDescription(testResultDescription);
        TapTestNGUtil.setTapTestResultStatus(tapTestResult, testResult.getStatus());
        if (yaml) {
            TapTestNGYamlUtil.createTestNGYAMLishData(tapTestResult, testResult);
        }
        return tapTestResult;
    }

    public static String generateTAPTestResultDescription(ITestResult testResult) {
        StringBuilder description = new StringBuilder();
        description.append("- ");
        description.append(testResult.getTestClass().getName());
        description.append(':');
        description.append(testResult.getMethod().getMethodName());
        return description.toString();
    }

    public static void setTapTestResultStatus(org.tap4j.model.TestResult tapTestResult, int status) {
        switch (status) {
            case 1: {
                tapTestResult.setStatus(StatusValues.OK);
                break;
            }
            case 3: {
                tapTestResult.setStatus(StatusValues.NOT_OK);
                Directive skip = new Directive(DirectiveValues.SKIP, "TestNG test was skipped");
                tapTestResult.setDirective(skip);
                break;
            }
            default: {
                tapTestResult.setStatus(StatusValues.NOT_OK);
            }
        }
    }

    public static List<ITestResult> getTestNGResultsOrderedByExecutionDate(ITestContext testContext) {
        LinkedHashMap<String, IResultMap> results = new LinkedHashMap<String, IResultMap>();
        results.put("passed", testContext.getPassedTests());
        results.put("failed", testContext.getFailedTests());
        results.put("failedBut", testContext.getFailedButWithinSuccessPercentageTests());
        results.put("skipped", testContext.getSkippedTests());
        ResultMap total = new ResultMap();
        TapTestNGUtil.addAll(total, (IResultMap)results.get("passed"));
        TapTestNGUtil.addAll(total, (IResultMap)results.get("failed"));
        TapTestNGUtil.addAll(total, (IResultMap)results.get("failedBut"));
        TapTestNGUtil.addAll(total, (IResultMap)results.get("skipped"));
        ITestNGMethod[] allMethodsInCtx = testContext.getAllTestMethods();
        for (int i = 0; i < allMethodsInCtx.length; ++i) {
            ITestNGMethod methodInCtx = allMethodsInCtx[i];
            Collection allMethodsFound = total.getAllMethods();
            boolean exists = false;
            for (ITestNGMethod methodFound : allMethodsFound) {
                if (!methodInCtx.getTestClass().getName().equals(methodFound.getTestClass().getName()) || !methodInCtx.getConstructorOrMethod().getName().equals(methodFound.getConstructorOrMethod().getName())) continue;
                exists = true;
            }
            if (exists) continue;
            TestResult skippedTestResult = new TestResult((IClass)methodInCtx.getTestClass(), methodInCtx.getInstance(), methodInCtx, null, testContext.getStartDate().getTime(), testContext.getEndDate().getTime(), testContext);
            skippedTestResult.setStatus(3);
            total.addResult((ITestResult)skippedTestResult, methodInCtx);
        }
        ArrayList<ITestResult> testNGTestResults = new ArrayList<ITestResult>(total.getAllResults());
        Collections.sort(testNGTestResults, EXECUTION_DATE_COMPARATOR);
        return testNGTestResults;
    }

    public static List<ITestResult> getTestNGResultsOrderedByExecutionDate(ResultMap total) {
        ArrayList<ITestResult> testNGTestResults = new ArrayList<ITestResult>(total.getAllResults());
        Collections.sort(testNGTestResults, EXECUTION_DATE_COMPARATOR);
        return testNGTestResults;
    }

    public static void addAll(ResultMap total, IResultMap map) {
        for (ITestResult testResult : map.getAllResults()) {
            total.addResult(testResult, testResult.getMethod());
        }
    }

    public static void fillAttributes(ITestResult tr, ITestContext ctx) {
        Set attrsNames = ctx.getAttributeNames();
        for (String attr : attrsNames) {
            Object o = ctx.getAttribute(attr);
            if (!(o instanceof TestNGAttribute)) continue;
            TestNGAttribute tapAttr = (TestNGAttribute)o;
            ITestNGMethod testNGMethod = tr.getMethod();
            ConstructorOrMethod constructorOrMethod = testNGMethod.getConstructorOrMethod();
            if (constructorOrMethod.getMethod() != tapAttr.getMethod()) continue;
            tr.setAttribute(attr, tapAttr.getValue());
        }
    }
}

