/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.testng.listener;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tap4j.ext.testng.util.TapTestNGUtil;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.producer.Producer;
import org.tap4j.producer.TapProducerFactory;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.ResultMap;

abstract class TapListener
extends TestListenerAdapter {
    private final ResultMap resultMap = new ResultMap();
    private final Map<Class<?>, List<ITestResult>> testResultsPerClass = new LinkedHashMap();
    private final Map<ITestNGMethod, List<ITestResult>> testResultsPerMethod = new LinkedHashMap<ITestNGMethod, List<ITestResult>>();
    private ITestContext ctx;
    private Producer tapProducer = TapProducerFactory.makeTap13YamlProducer();

    TapListener() {
    }

    public void onStart(ITestContext testContext) {
        this.ctx = testContext;
    }

    public void onTestSuccess(ITestResult tr) {
        TapTestNGUtil.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onTestFailure(ITestResult tr) {
        TapTestNGUtil.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onTestSkipped(ITestResult tr) {
        TapTestNGUtil.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        TapTestNGUtil.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public abstract void onFinish(ITestContext var1);

    public abstract boolean isYaml();

    protected void generateTAPPerClass(ITestContext testContext) {
        List<ITestResult> testNGTestResults = TapTestNGUtil.getTestNGResultsOrderedByExecutionDate(this.resultMap);
        for (ITestResult iTestResult : testNGTestResults) {
            Class clazz = iTestResult.getMethod().getRealClass();
            List<ITestResult> testResultsForThisClass = this.testResultsPerClass.get(clazz);
            if (testResultsForThisClass == null) {
                testResultsForThisClass = new LinkedList<ITestResult>();
                this.testResultsPerClass.put(clazz, testResultsForThisClass);
            }
            testResultsForThisClass.add(iTestResult);
        }
        for (Map.Entry entry : this.testResultsPerClass.entrySet()) {
            TestSet testSet = new TestSet();
            List testResults = (List)entry.getValue();
            testSet.setPlan(new Plan(Integer.valueOf(testResults.size())));
            for (ITestResult testResult : testResults) {
                TestResult tapTestResult = TapTestNGUtil.generateTAPTestResult(testResult, testSet.getNumberOfTestResults() + 1, this.isYaml());
                testSet.addTestResult(tapTestResult);
            }
            File output = new File(testContext.getOutputDirectory(), ((Class)entry.getKey()).getName() + ".tap");
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            this.tapProducer.dump(testSet, output);
        }
    }

    protected void generateTAPPerMethod(ITestContext testContext) {
        List<ITestResult> testNGTestResults = TapTestNGUtil.getTestNGResultsOrderedByExecutionDate(this.resultMap);
        for (ITestResult iTestResult : testNGTestResults) {
            ITestNGMethod method = iTestResult.getMethod();
            List<ITestResult> testResultsForThisMethod = this.testResultsPerMethod.get(method);
            if (testResultsForThisMethod == null) {
                testResultsForThisMethod = new LinkedList<ITestResult>();
                this.testResultsPerMethod.put(method, testResultsForThisMethod);
            }
            testResultsForThisMethod.add(iTestResult);
        }
        for (Map.Entry entry : this.testResultsPerMethod.entrySet()) {
            TestSet testSet = new TestSet();
            List testResults = (List)entry.getValue();
            testSet.setPlan(new Plan(Integer.valueOf(testResults.size())));
            for (ITestResult testResult : testResults) {
                TestResult tapTestResult = TapTestNGUtil.generateTAPTestResult(testResult, testSet.getNumberOfTestResults() + 1, this.isYaml());
                testSet.addTestResult(tapTestResult);
            }
            File output = new File(testContext.getOutputDirectory(), ((ITestNGMethod)entry.getKey()).getTestClass().getName() + "#" + ((ITestNGMethod)entry.getKey()).getMethodName() + ".tap");
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            this.tapProducer.dump(testSet, output);
        }
    }
}

