/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.junit.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.tap4j.ext.junit.model.JUnitTestData;
import org.tap4j.ext.junit.util.TapJUnitYamlUtil;
import org.tap4j.model.Directive;
import org.tap4j.model.TestResult;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;
import org.yaml.snakeyaml.DumperOptions;

public final class TapJUnitUtil {
    public static final String LINE_SEPARATOR = DumperOptions.LineBreak.UNIX.getString();

    private TapJUnitUtil() {
    }

    public static TestResult generateTAPTestResult(JUnitTestData testMethod, Integer number, boolean yaml) {
        TestResult tapTestResult = new TestResult();
        String testResultDescription = TapJUnitUtil.generateTAPTestResultDescription(testMethod);
        tapTestResult.setDescription(testResultDescription);
        TapJUnitUtil.setTapTestStatus(tapTestResult, testMethod);
        if (yaml) {
            String message = TapJUnitUtil.getMessage(testMethod);
            String severity = TapJUnitUtil.getSeverity(testMethod);
            String source = TapJUnitUtil.getSource(TapJUnitUtil.extractMethodName(testMethod.getDescription()), TapJUnitUtil.extractClassName(testMethod.getDescription()));
            String datetime = TapJUnitUtil.getDatetime();
            String file = TapJUnitUtil.getFile(testMethod);
            String line = TapJUnitUtil.getLine(testMethod);
            String name = TapJUnitUtil.getName(testMethod);
            String error = TapJUnitUtil.getError(testMethod);
            String backtrace = TapJUnitUtil.getBacktrace(testMethod);
            TapJUnitYamlUtil.createJUnitYAMLishData(tapTestResult, message, severity, source, datetime, file, line, name, error, backtrace);
        }
        return tapTestResult;
    }

    public static String generateTAPTestResultDescription(JUnitTestData testMethod) {
        StringBuilder description = new StringBuilder();
        description.append("- ");
        description.append(TapJUnitUtil.extractClassName(testMethod.getDescription()));
        description.append(':');
        description.append(TapJUnitUtil.extractMethodName(testMethod.getDescription()));
        return description.toString();
    }

    public static void setTapTestStatus(TestResult tapTestResult, JUnitTestData testMethod) {
        if (testMethod.isIgnored().booleanValue()) {
            tapTestResult.setStatus(StatusValues.NOT_OK);
            Directive skip = new Directive(DirectiveValues.SKIP, "JUnit test was skipped");
            tapTestResult.setDirective(skip);
        } else if (testMethod.isFailed().booleanValue()) {
            tapTestResult.setStatus(StatusValues.NOT_OK);
        } else {
            tapTestResult.setStatus(StatusValues.OK);
        }
    }

    public static String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        String regex = "^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$";
        Pattern parens = Pattern.compile("^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$");
        Matcher m = parens.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }

    public static String extractSimpleClassName(Description description) {
        String simpleClassName = null;
        String className = TapJUnitUtil.extractClassName(description);
        String[] splitClassName = className.split("\\.");
        if (splitClassName.length > 0) {
            simpleClassName = splitClassName[splitClassName.length - 1];
        }
        return simpleClassName;
    }

    public static String extractMethodName(Description description) {
        String methodName = null;
        String[] splitDisplayName = description.getDisplayName().split("\\(");
        if (splitDisplayName.length > 0) {
            methodName = splitDisplayName[0];
        }
        return methodName;
    }

    public static String getFile(JUnitTestData testMethod) {
        return TapJUnitUtil.extractClassName(testMethod.getDescription());
    }

    public static String getName(JUnitTestData testMethod) {
        return TapJUnitUtil.extractMethodName(testMethod.getDescription());
    }

    public static String getLine(JUnitTestData testMethod) {
        String line = "~";
        Throwable testException = testMethod.getFailException();
        if (testException != null) {
            StackTraceElement el;
            StringBuilder lookFor = new StringBuilder();
            lookFor.append(TapJUnitUtil.extractClassName(testMethod.getDescription()));
            lookFor.append('.');
            lookFor.append(TapJUnitUtil.extractMethodName(testMethod.getDescription()));
            lookFor.append('(');
            lookFor.append(TapJUnitUtil.extractSimpleClassName(testMethod.getDescription()));
            lookFor.append(".java:");
            StackTraceElement[] els = testException.getStackTrace();
            for (int i = 0; i < els.length && (line = TapJUnitUtil.getLineNumberFromExceptionTraceLine((el = els[i]).toString(), lookFor.toString())).equals("") != Boolean.FALSE.booleanValue(); ++i) {
            }
        }
        return line;
    }

    public static String getLineNumberFromExceptionTraceLine(String exceptionTraceLine, String substrToSearch) {
        String lineNumber = "";
        int index = exceptionTraceLine.indexOf(substrToSearch);
        if (index >= 0) {
            int length = substrToSearch.length() + index;
            if (exceptionTraceLine.lastIndexOf(41) > length) {
                lineNumber = exceptionTraceLine.substring(length, exceptionTraceLine.lastIndexOf(41));
            }
        }
        return lineNumber;
    }

    public static String getError(JUnitTestData testMethod) {
        String error = "~";
        Throwable t = testMethod.getFailException();
        if (t != null) {
            error = t.getMessage();
        }
        return error;
    }

    public static String getMessage(JUnitTestData testMethod) {
        return "JUnit 4.0 Test " + testMethod.getDescription().getDisplayName();
    }

    public static String getSeverity(JUnitTestData testMethod) {
        String severity = "~";
        if (testMethod.getFailException() != null) {
            severity = "High";
        }
        return severity;
    }

    public static String getSource(String testMethod, String testClass) {
        return testClass + ":" + testMethod;
    }

    public static String getDatetime() {
        long currentTimeMillis = System.currentTimeMillis();
        Date date = new Date(currentTimeMillis);
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
    }

    public static String getBacktrace(JUnitTestData testMethod) {
        StringBuilder stackTrace = new StringBuilder();
        Throwable throwable = testMethod.getFailException();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stackTraceString = sw.toString();
            stackTraceString = stackTraceString.trim().replaceAll("\\r\\n", "\n");
            StringTokenizer st = new StringTokenizer(stackTraceString, LINE_SEPARATOR);
            while (st.hasMoreTokens()) {
                String stackTraceLine = st.nextToken();
                stackTrace.append(stackTraceLine);
                stackTrace.append(LINE_SEPARATOR);
            }
        } else {
            stackTrace.append('~');
        }
        return stackTrace.toString();
    }
}

