/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin.util;

import org.tap4j.model.Directive;
import org.tap4j.model.TestResult;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public final class Util {
    private Util() {
    }

    public static String normalizeFolders(String workspace, String relative) {
        workspace = workspace.replaceAll("\\\\", "\\/");
        if ((relative = relative.replaceAll("\\\\", "\\/")).length() > workspace.length() && relative.contains(workspace)) {
            String temp = relative.substring(workspace.length(), relative.length());
            if (temp.startsWith("/") || temp.startsWith("\\")) {
                temp = temp.substring(1, temp.length());
            }
            return temp;
        }
        return relative;
    }

    public static boolean isSkipped(TestResult testResult) {
        boolean r = false;
        Directive directive = testResult.getDirective();
        if (directive != null && directive.getDirectiveValue() == DirectiveValues.SKIP) {
            r = true;
        }
        return r;
    }

    public static boolean isTodo(TestResult testResult) {
        boolean r = false;
        Directive directive = testResult.getDirective();
        if (directive != null && directive.getDirectiveValue() == DirectiveValues.TODO) {
            r = true;
        }
        return r;
    }

    public static boolean isFailure(TestResult testResult, Boolean todoIsFailure) {
        boolean r = false;
        Directive directive = testResult.getDirective();
        StatusValues status = testResult.getStatus();
        if (directive != null) {
            if (directive.getDirectiveValue() == DirectiveValues.TODO && todoIsFailure != null && todoIsFailure.booleanValue()) {
                r = true;
            }
        } else if (status != null && status == StatusValues.NOT_OK) {
            r = true;
        }
        return r;
    }
}

