/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin.util;

import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tap4j.plugin.TapBuildAction;
import org.tap4j.plugin.TapResult;

public class GraphHelper {
    private GraphHelper() {
    }

    public static void redirectWhenGraphUnsupported(StaplerResponse rsp, StaplerRequest req) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
    }

    public static JFreeChart createChart(StaplerRequest req, CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)"TAP Tests", null, (String)"TAP Tests Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){
            private static final long serialVersionUID = 331915263367089058L;

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                return label.getRun().getNumber() + "/" + "tapResults" + "/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                TapBuildAction build = (TapBuildAction)label.getRun().getAction(TapBuildAction.class);
                TapResult report = build.getResult();
                report.tally();
                switch (row) {
                    case 0: {
                        return String.valueOf(report.getFailed()) + " Failure(s)";
                    }
                    case 1: {
                        return String.valueOf(report.getPassed()) + " Pass";
                    }
                    case 2: {
                        return String.valueOf(report.getSkipped()) + " Skip(s)";
                    }
                    case 3: {
                        return String.valueOf(report.getToDo()) + " ToDo(s)";
                    }
                }
                return "";
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        ar.setSeriesPaint(2, (Paint)ColorPalette.YELLOW);
        ar.setSeriesPaint(3, (Paint)Color.CYAN);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static JFreeChart createMethodChart(StaplerRequest req, final CategoryDataset dataset, final Map<ChartUtil.NumberOnlyBuildLabel, String> statusMap, final String methodUrl) {
        JFreeChart chart = ChartFactory.createBarChart(null, null, (String)"\ufffd Duration (secs)", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.removeLegend();
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer br = new BarRenderer(){
            private static final long serialVersionUID = 961671076462240008L;
            Map<String, Paint> statusPaintMap = new HashMap<String, Paint>();
            {
                this.statusPaintMap.put("PASS", ColorPalette.BLUE);
                this.statusPaintMap.put("SKIP", ColorPalette.YELLOW);
                this.statusPaintMap.put("FAIL", ColorPalette.RED);
                this.statusPaintMap.put("TODO", ColorPalette.GREY);
            }

            public Paint getItemPaint(int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                Paint paint = this.statusPaintMap.get(statusMap.get(label));
                return paint == null ? Color.gray : paint;
            }
        };
        br.setBaseToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                if ("UNKNOWN".equals(statusMap.get(label))) {
                    return "unknown";
                }
                return dataset.getValue(row, column) + " secs";
            }
        });
        br.setBaseItemURLGenerator(new CategoryURLGenerator(){

            public String generateURL(CategoryDataset dataset, int series, int category) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(category);
                if ("UNKNOWN".equals(statusMap.get(label))) {
                    return null;
                }
                return label.build.getUpUrl() + label.getRun().getNumber() + "/tap/" + methodUrl;
            }
        });
        br.setItemMargin(0.0);
        br.setMinimumBarLength(5.0);
        br.setBase(br.findRangeBounds(dataset).getUpperBound() / 100.0);
        plot.setRenderer((CategoryItemRenderer)br);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

