/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin.util;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class DiagnosticUtil {
    private static final String INNER_TABLE_HEADER = "<tr>\n<td colspan='4' class='yaml'>\n<table width=\"100%\" class=\"yaml\">";
    private static final String INNER_TABLE_FOOTER = "</table>\n</td>\n</tr>";

    private DiagnosticUtil() {
    }

    public static String createDiagnosticTable(String tapFile, Map<String, Object> diagnostic) {
        StringBuilder sb = new StringBuilder();
        DiagnosticUtil.createDiagnosticTableRecursively(tapFile, null, diagnostic, sb, 1);
        return sb.toString();
    }

    public static void createDiagnosticTableRecursively(String tapFile, String parentKey, Map<String, Object> diagnostic, StringBuilder sb, int depth) {
        sb.append(INNER_TABLE_HEADER);
        RENDER_TYPE renderType = DiagnosticUtil.getMapEntriesRenderType(diagnostic);
        if (renderType == RENDER_TYPE.IMAGE) {
            for (Map.Entry<String, Object> entry : diagnostic.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                sb.append("<tr>");
                for (int i = 0; i < depth; ++i) {
                    sb.append("<td width='5%' class='hidden'> </td>");
                }
                sb.append("<td style=\"width: auto;\">" + key + "</td>");
                if (key.equals("File-Content")) {
                    String fileName = "attachment";
                    Object o = diagnostic.get("File-Name");
                    if (o != null && o instanceof String) {
                        fileName = (String)o;
                    }
                    String downloadKey = fileName;
                    if (parentKey != null && depth > 3 && !parentKey.trim().equalsIgnoreCase("files") && !parentKey.trim().equalsIgnoreCase("extensions")) {
                        downloadKey = parentKey;
                    }
                    sb.append("<td><a href='downloadAttachment?f=" + tapFile + "&key=" + downloadKey + "'>" + fileName + "</a></td>");
                } else {
                    sb.append("<td><pre>" + StringEscapeUtils.escapeHtml((String)value.toString()) + "</pre></td>");
                }
                sb.append("</tr>");
            }
        } else {
            for (Map.Entry<String, Object> entry : diagnostic.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                sb.append("<tr>");
                for (int i = 0; i < depth; ++i) {
                    sb.append("<td width='5%' class='hidden'> </td>");
                }
                sb.append("<td style=\"width: auto;\">" + key + "</td>");
                if (value instanceof Map) {
                    sb.append("<td> </td>");
                    DiagnosticUtil.createDiagnosticTableRecursively(tapFile, key, (Map)value, sb, depth + 1);
                } else {
                    sb.append("<td><pre>" + StringEscapeUtils.escapeHtml((String)value.toString()) + "</pre></td>");
                }
                sb.append("</tr>");
            }
        }
        sb.append(INNER_TABLE_FOOTER);
    }

    private static RENDER_TYPE getMapEntriesRenderType(Map<String, Object> diagnostic) {
        RENDER_TYPE renderType = RENDER_TYPE.TEXT;
        Set<String> keys = diagnostic.keySet();
        if (keys.contains("File-Type") && (keys.contains("File-Location") || keys.contains("File-Content"))) {
            renderType = RENDER_TYPE.IMAGE;
        }
        return renderType;
    }

    private static enum RENDER_TYPE {
        TEXT,
        IMAGE;

    }
}

