/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin.model;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.Run;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.tap4j.model.Comment;
import org.tap4j.model.Directive;
import org.tap4j.model.TestSet;
import org.tap4j.plugin.TapResult;
import org.tap4j.plugin.TapTestResultAction;
import org.tap4j.plugin.model.TapStreamResult;
import org.tap4j.plugin.model.TestSetMap;
import org.tap4j.plugin.util.Util;
import org.tap4j.util.DirectiveValues;

public class TapTestResultResult
extends TestResult {
    private static final String DURATION_KEY = "duration_ms";
    private static final long serialVersionUID = -4499261655602135921L;
    private static final Logger LOGGER = Logger.getLogger(TapTestResultResult.class.getName());
    private final Run<?, ?> owner;
    private final org.tap4j.model.TestResult tapTestResult;
    private final TestSetMap testSetMap;
    private final Boolean todoIsFailure;
    private final Boolean includeCommentDiagnostics;
    private final Boolean validateNumberOfTests;

    public TapTestResultResult(Run<?, ?> owner, TestSetMap testSetMap, org.tap4j.model.TestResult tapTestResult, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests) {
        this.owner = owner;
        this.testSetMap = testSetMap;
        this.tapTestResult = tapTestResult;
        this.todoIsFailure = todoIsFailure;
        this.includeCommentDiagnostics = includeCommentDiagnostics;
        this.validateNumberOfTests = validateNumberOfTests;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Run<?, ?> getRun() {
        return this.owner;
    }

    public TestObject getParent() {
        TapStreamResult parent = null;
        TestSet testSet = this.tapTestResult.getSubtest();
        if (testSet != null) {
            TestSetMap subTest = new TestSetMap(this.testSetMap.getFileName(), testSet);
            ArrayList<TestSetMap> list = new ArrayList<TestSetMap>();
            list.add(subTest);
            parent = new TapStreamResult(this.owner, new TapResult("TAP Test Results", this.owner, list, this.todoIsFailure, this.includeCommentDiagnostics, this.validateNumberOfTests));
        }
        return parent;
    }

    public TestResult findCorrespondingResult(String id) {
        if (this.getDisplayName().equals(id)) {
            return this;
        }
        return null;
    }

    public String getName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.tapTestResult.getTestNumber());
        String tapTestResultDescription = this.tapTestResult.getDescription();
        if (StringUtils.isNotBlank((String)tapTestResultDescription)) {
            buf.append(" - ");
            buf.append(tapTestResultDescription);
        }
        return buf.toString();
    }

    public String getStatus() {
        boolean failure = Util.isFailure(this.tapTestResult, this.todoIsFailure);
        return failure ? "NOT OK" : "OK";
    }

    public String getSkip() {
        boolean skip = Util.isSkipped(this.tapTestResult);
        return skip ? "Yes" : "No";
    }

    public String getTodo() {
        String todo = "No";
        Directive directive = this.tapTestResult.getDirective();
        if (directive != null && directive.getDirectiveValue() == DirectiveValues.TODO) {
            todo = "Yes";
        }
        return todo;
    }

    public String getFullName() {
        return this.getName();
    }

    public String getRelativePathFrom(TestObject it) {
        if (it == this) {
            return ".";
        }
        StringBuilder buf = new StringBuilder();
        TapTestResultResult next = this;
        TapTestResultResult cur = this;
        while (next != null && it != next) {
            cur = next;
            String safeName = cur.getSafeName();
            if (!"(empty)".equals(safeName)) {
                buf.insert(0, '/');
                buf.insert(0, safeName);
            }
            next = cur.getParent();
        }
        if (it == next) {
            return buf.toString();
        }
        TapTestResultAction action = this.getTestResultActionDiverged();
        if (action == null) {
            return "";
        }
        buf.insert(0, '/');
        buf.insert(0, action.getUrlName());
        AbstractBuild myBuild = cur.getOwner();
        if (myBuild == null) {
            return "";
        }
        buf.insert(0, myBuild.getUrl());
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && myBuild instanceof Item) {
            buf.insert(0, '/');
            Item myBuildAsItem = (Item)myBuild;
            buf.insert(0, Functions.getRelativeLinkTo((Item)myBuildAsItem));
        } else {
            String hudsonRootUrl = Jenkins.getInstance().getRootUrl();
            if (hudsonRootUrl == null || hudsonRootUrl.length() == 0) {
                return "";
            }
            buf.insert(0, hudsonRootUrl);
        }
        return buf.toString();
    }

    public String getSafeName() {
        String safeName = this.testSetMap.getFileName() + "-" + this.tapTestResult.getTestNumber();
        try {
            safeName = URLEncoder.encode(safeName, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warning(uee.getMessage());
        }
        return safeName;
    }

    public String getTitle() {
        return this.getName();
    }

    public float getDuration() {
        Object duration;
        Map diagnostic = this.tapTestResult.getDiagnostic();
        if (diagnostic != null && !diagnostic.isEmpty() && (duration = diagnostic.get(DURATION_KEY)) != null) {
            Float durationMS = Float.valueOf(Float.parseFloat(duration.toString()));
            return durationMS.floatValue() / 1000.0f;
        }
        return super.getDuration();
    }

    public String toString() {
        List comments;
        StringWriter pw = new StringWriter();
        pw.append(this.tapTestResult.getStatus().toString());
        if (this.tapTestResult.getTestNumber() != null) {
            pw.append(' ').append(Integer.toString(this.tapTestResult.getTestNumber()));
        }
        if (StringUtils.isNotBlank((String)this.tapTestResult.getDescription())) {
            pw.append(' ').append(this.tapTestResult.getDescription());
        }
        if (this.tapTestResult.getDirective() != null) {
            pw.append(" # ").append(this.tapTestResult.getDirective().getDirectiveValue().toString());
            if (StringUtils.isNotBlank((String)this.tapTestResult.getDirective().getReason())) {
                pw.append(' ').append(this.tapTestResult.getDirective().getReason());
            }
        }
        if ((comments = this.tapTestResult.getComments()).size() > 0) {
            for (Comment comment : comments) {
                if (comment.isInline()) {
                    pw.append(' ');
                    pw.append("# ").append(comment.getText());
                    continue;
                }
                pw.append("\n");
                pw.append("# ").append(comment.getText());
            }
        }
        return pw.toString();
    }

    @CheckForNull
    private TapTestResultAction getTestResultActionDiverged() {
        Run<?, ?> owner = this.getRun();
        if (owner != null) {
            return (TapTestResultAction)owner.getAction(TapTestResultAction.class);
        }
        LOGGER.warning("owner is null when trying to getTestResultActionDiverged.");
        return null;
    }
}

