/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin.model;

import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.tap4j.model.TestSet;
import org.tap4j.plugin.TapResult;
import org.tap4j.plugin.model.TapTestResultResult;
import org.tap4j.plugin.model.TestSetMap;
import org.tap4j.util.StatusValues;

public class TapStreamResult
extends TabulatedResult {
    private static final long serialVersionUID = 8337146933697574082L;
    private final Run<?, ?> owner;
    private List<TestResult> children = new ArrayList<TestResult>();
    private TapResult tapResult;

    public TapStreamResult(Run<?, ?> owner, TapResult tapResult) {
        this.owner = owner;
        this.tapResult = tapResult;
        this.setChildrenInfo();
    }

    public String getDisplayName() {
        return "TAP Stream Results";
    }

    public Run<?, ?> getRun() {
        return this.owner;
    }

    public TestObject getParent() {
        return null;
    }

    public TestResult findCorrespondingResult(String id) {
        return null;
    }

    public Collection<? extends TestResult> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Exported(visibility=2)
    public int getFailCount() {
        return this.tapResult.getFailed();
    }

    @Exported(visibility=2)
    public int getTotalCount() {
        return this.tapResult.getTotal();
    }

    @Exported(visibility=2)
    public int getSkipCount() {
        return this.tapResult.getSkipped();
    }

    public int getToDoCount() {
        return this.tapResult.getToDo();
    }

    public List<CaseResult> getFailedTests() {
        return Collections.emptyList();
    }

    public List<TestResult> getFailedTests2() {
        ArrayList<TestResult> failedTests = new ArrayList<TestResult>();
        if (this.tapResult != null && this.tapResult.getTestSets().size() > 0) {
            for (TestSetMap tsm : this.tapResult.getTestSets()) {
                TestSet ts = tsm.getTestSet();
                for (org.tap4j.model.TestResult tr : ts.getTestResults()) {
                    if (tr.getStatus() != StatusValues.NOT_OK) continue;
                    failedTests.add(new TapTestResultResult(this.owner, tsm, tr, this.tapResult.getTodoIsFailure(), this.tapResult.getIncludeCommentDiagnostics(), this.tapResult.getValidateNumberOfTests()));
                }
            }
        }
        return failedTests;
    }

    public float getDuration() {
        return this.tapResult.getDuration();
    }

    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        TapTestResultResult tr = this.getTapTestResultResult(name);
        if (tr != null) {
            return tr;
        }
        return super.getDynamic(name, req, rsp);
    }

    public TapResult getTapResult() {
        return this.tapResult;
    }

    private TapTestResultResult getTapTestResultResult(String name) {
        if (name == null) {
            return null;
        }
        if (name.lastIndexOf("-") <= 0) {
            return null;
        }
        name = name.trim();
        int rightIndex = name.length();
        while (name.charAt(rightIndex - 1) == '/') {
            --rightIndex;
        }
        int leftIndex = name.lastIndexOf(47) + 1;
        String testResultName = name.substring(leftIndex, rightIndex);
        if (testResultName.indexOf(45) <= 0) {
            return null;
        }
        String testNumber = testResultName.substring(testResultName.lastIndexOf(45) + 1);
        String fileName = name.substring(0, name.lastIndexOf(45));
        for (TestSetMap tsm : this.tapResult.getTestSets()) {
            if (!tsm.getFileName().equals(fileName)) continue;
            TestSet ts = tsm.getTestSet();
            org.tap4j.model.TestResult desired = ts.getTestResult(Integer.valueOf(Integer.parseInt(testNumber)));
            return new TapTestResultResult(this.owner, tsm, desired, this.tapResult.getTodoIsFailure(), this.tapResult.getIncludeCommentDiagnostics(), this.tapResult.getValidateNumberOfTests());
        }
        return null;
    }

    public void merge(TapResult other) {
        this.tapResult = this.tapResult.copyWithExtraTestSets(other.getTestSets());
        this.tapResult.tally();
        this.children = new ArrayList<TestResult>();
        this.setChildrenInfo();
    }

    private void setChildrenInfo() {
        for (TestSetMap tsm : this.tapResult.getTestSets()) {
            TestSet ts = tsm.getTestSet();
            for (org.tap4j.model.TestResult tr : ts.getTestResults()) {
                this.children.add(new TapTestResultResult(this.owner, tsm, tr, this.tapResult.getTodoIsFailure(), this.tapResult.getIncludeCommentDiagnostics(), this.tapResult.getValidateNumberOfTests()));
            }
        }
    }
}

