/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin.model;

import java.util.Map;

public class TapAttachment {
    private final String fileName;
    private final byte[] content;
    private final int size;
    private final String fileType;

    public TapAttachment(String fileName, byte[] content, int size, String fileType) {
        this.fileName = fileName;
        this.content = content;
        this.size = size;
        this.fileType = fileType;
    }

    public TapAttachment(byte[] content, Map<String, Object> diagnostics) {
        this.content = content;
        int size = -1;
        String fileType = "";
        String fileName = "tapAttachment";
        for (String key : diagnostics.keySet()) {
            if (diagnostics.get(key) instanceof Map != Boolean.FALSE) continue;
            if (key.equalsIgnoreCase("file-size")) {
                try {
                    size = (int)Long.parseLong(diagnostics.get(key).toString());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (key.equalsIgnoreCase("file-type")) {
                fileType = (String)diagnostics.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("file-name")) continue;
            fileName = (String)diagnostics.get(key);
        }
        this.size = size;
        this.fileType = fileType;
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getSize() {
        return this.size;
    }

    public String getFileType() {
        return this.fileType;
    }
}

