/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.export.Exported;
import org.tap4j.plugin.TapProjectAction;
import org.tap4j.plugin.TapResult;
import org.tap4j.plugin.model.TapStreamResult;

public class TapTestResultAction
implements StaplerProxy,
SimpleBuildStep.LastBuildAction,
HealthReportingAction,
RunAction2 {
    public transient Run<?, ?> run;
    @Deprecated
    public transient AbstractBuild<?, ?> owner;
    private TapResult tapResult;

    @Deprecated
    protected TapTestResultAction(AbstractBuild<?, ?> owner, TapResult tapResult) {
        this((Run)owner, tapResult);
    }

    protected TapTestResultAction(Run r, TapResult tapResult) {
        this.setRunAndOwner(r);
        this.tapResult = tapResult;
    }

    public TapResult getTapResult() {
        return this.tapResult;
    }

    @Exported(visibility=2)
    public int getFailCount() {
        return this.tapResult.getFailed();
    }

    @Exported(visibility=2)
    public int getTotalCount() {
        return this.tapResult.getTotal();
    }

    @Exported(visibility=2)
    public int getSkipCount() {
        return this.tapResult.getSkipped();
    }

    public List<CaseResult> getFailedTests() {
        return Collections.emptyList();
    }

    public Object getTarget() {
        return this.getResult();
    }

    public TapStreamResult getResult() {
        return new TapStreamResult((Run<?, ?>)this.owner, this.tapResult);
    }

    @Exported(visibility=2)
    public String getUrlName() {
        return "tapTestReport";
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "TAP Test Results";
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.run.getParent();
        if (!Util.filter((List)job.getActions(), TapProjectAction.class).isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(new TapProjectAction(job));
    }

    public HealthReport getBuildHealth() {
        double scaleFactor = 1.0;
        int totalCount = this.getTotalCount();
        int failCount = this.getFailCount();
        int score = totalCount == 0 ? 100 : (int)(100.0 * Math.max(0.0, Math.min(1.0, 1.0 - 1.0 * (double)failCount / (double)totalCount)));
        Localizable displayName = Messages._AbstractTestResultAction_getDisplayName();
        Localizable description = totalCount == 0 ? Messages._AbstractTestResultAction_zeroTestDescription((Object)displayName) : Messages._AbstractTestResultAction_TestsDescription((Object)displayName, (Object)failCount, (Object)totalCount);
        return new HealthReport(score, description);
    }

    public void onAttached(Run<?, ?> r) {
        this.setRunAndOwner(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.setRunAndOwner(r);
    }

    private void setRunAndOwner(Run<?, ?> r) {
        this.run = r;
        this.owner = r instanceof AbstractBuild ? (AbstractBuild)r : null;
    }

    void mergeResult(TapResult additionalResult) {
        TapStreamResult original = this.getResult();
        original.merge(additionalResult);
        this.setFromTapStreamResult(original);
    }

    private void setFromTapStreamResult(TapStreamResult result) {
        this.tapResult = result.getTapResult();
    }
}

