/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.test.TestResultAggregator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.BooleanUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tap4j.model.Plan;
import org.tap4j.model.TestSet;
import org.tap4j.plugin.TapBuildAction;
import org.tap4j.plugin.TapParser;
import org.tap4j.plugin.TapProjectAction;
import org.tap4j.plugin.TapResult;
import org.tap4j.plugin.TapTestResultAction;
import org.tap4j.plugin.model.TestSetMap;

public class TapPublisher
extends Recorder
implements MatrixAggregatable,
SimpleBuildStep {
    private final String testResults;
    private final Boolean failIfNoResults;
    private final Boolean failedTestsMarkBuildAsFailure;
    private final Boolean outputTapToConsole;
    private final Boolean enableSubtests;
    private final Boolean discardOldReports;
    private final Boolean todoIsFailure;
    private final Boolean includeCommentDiagnostics;
    private final Boolean validateNumberOfTests;
    private final Boolean planRequired;
    private final Boolean verbose;
    private final Boolean showOnlyFailures;
    private final Boolean stripSingleParents;
    private final Boolean flattenTapResult;
    private final Boolean removeYamlIfCorrupted;
    private final Boolean skipIfBuildNotOk;

    @Deprecated
    public TapPublisher(String testResults, Boolean failIfNoResults, Boolean failedTestsMarkBuildAsFailure, Boolean outputTapToConsole, Boolean enableSubtests, Boolean discardOldReports, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose) {
        this(testResults, failIfNoResults, failedTestsMarkBuildAsFailure, outputTapToConsole, enableSubtests, discardOldReports, todoIsFailure, includeCommentDiagnostics, validateNumberOfTests, planRequired, verbose, Boolean.FALSE);
    }

    @Deprecated
    public TapPublisher(String testResults, Boolean failIfNoResults, Boolean failedTestsMarkBuildAsFailure, Boolean outputTapToConsole, Boolean enableSubtests, Boolean discardOldReports, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose, Boolean showOnlyFailures) {
        this(testResults, failIfNoResults, failedTestsMarkBuildAsFailure, outputTapToConsole, enableSubtests, discardOldReports, todoIsFailure, includeCommentDiagnostics, validateNumberOfTests, planRequired, verbose, Boolean.FALSE, Boolean.FALSE);
    }

    @Deprecated
    public TapPublisher(String testResults, Boolean failIfNoResults, Boolean failedTestsMarkBuildAsFailure, Boolean outputTapToConsole, Boolean enableSubtests, Boolean discardOldReports, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose, Boolean showOnlyFailures, Boolean stripSingleParents) {
        this(testResults, failIfNoResults, failedTestsMarkBuildAsFailure, outputTapToConsole, enableSubtests, discardOldReports, todoIsFailure, includeCommentDiagnostics, validateNumberOfTests, planRequired, verbose, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
    }

    @Deprecated
    public TapPublisher(String testResults, Boolean failIfNoResults, Boolean failedTestsMarkBuildAsFailure, Boolean outputTapToConsole, Boolean enableSubtests, Boolean discardOldReports, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose, Boolean showOnlyFailures, Boolean stripSingleParents, Boolean flattenTapResult) {
        this(testResults, failIfNoResults, failedTestsMarkBuildAsFailure, outputTapToConsole, enableSubtests, discardOldReports, todoIsFailure, includeCommentDiagnostics, validateNumberOfTests, planRequired, verbose, showOnlyFailures, stripSingleParents, flattenTapResult, Boolean.FALSE);
    }

    @Deprecated
    public TapPublisher(String testResults, Boolean failIfNoResults, Boolean failedTestsMarkBuildAsFailure, Boolean outputTapToConsole, Boolean enableSubtests, Boolean discardOldReports, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose, Boolean showOnlyFailures, Boolean stripSingleParents, Boolean flattenTapResult, Boolean skipIfBuildNotOk) {
        this(testResults, failIfNoResults, failedTestsMarkBuildAsFailure, outputTapToConsole, enableSubtests, discardOldReports, todoIsFailure, includeCommentDiagnostics, validateNumberOfTests, planRequired, verbose, showOnlyFailures, stripSingleParents, flattenTapResult, Boolean.FALSE, skipIfBuildNotOk);
    }

    @DataBoundConstructor
    public TapPublisher(String testResults, Boolean failIfNoResults, Boolean failedTestsMarkBuildAsFailure, Boolean outputTapToConsole, Boolean enableSubtests, Boolean discardOldReports, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose, Boolean showOnlyFailures, Boolean stripSingleParents, Boolean flattenTapResult, Boolean removeYamlIfCorrupted, Boolean skipIfBuildNotOk) {
        this.testResults = testResults;
        this.failIfNoResults = BooleanUtils.toBooleanDefaultIfNull((Boolean)failIfNoResults, (boolean)false);
        this.failedTestsMarkBuildAsFailure = BooleanUtils.toBooleanDefaultIfNull((Boolean)failedTestsMarkBuildAsFailure, (boolean)false);
        this.outputTapToConsole = BooleanUtils.toBooleanDefaultIfNull((Boolean)outputTapToConsole, (boolean)true);
        this.enableSubtests = BooleanUtils.toBooleanDefaultIfNull((Boolean)enableSubtests, (boolean)true);
        this.discardOldReports = BooleanUtils.toBooleanDefaultIfNull((Boolean)discardOldReports, (boolean)false);
        this.todoIsFailure = BooleanUtils.toBooleanDefaultIfNull((Boolean)todoIsFailure, (boolean)true);
        this.includeCommentDiagnostics = BooleanUtils.toBooleanDefaultIfNull((Boolean)includeCommentDiagnostics, (boolean)true);
        this.validateNumberOfTests = BooleanUtils.toBooleanDefaultIfNull((Boolean)validateNumberOfTests, (boolean)false);
        this.planRequired = BooleanUtils.toBooleanDefaultIfNull((Boolean)planRequired, (boolean)true);
        this.verbose = BooleanUtils.toBooleanDefaultIfNull((Boolean)verbose, (boolean)true);
        this.showOnlyFailures = BooleanUtils.toBooleanDefaultIfNull((Boolean)showOnlyFailures, (boolean)false);
        this.stripSingleParents = BooleanUtils.toBooleanDefaultIfNull((Boolean)stripSingleParents, (boolean)false);
        this.flattenTapResult = BooleanUtils.toBooleanDefaultIfNull((Boolean)flattenTapResult, (boolean)false);
        this.removeYamlIfCorrupted = BooleanUtils.toBooleanDefaultIfNull((Boolean)removeYamlIfCorrupted, (boolean)false);
        this.skipIfBuildNotOk = BooleanUtils.toBooleanDefaultIfNull((Boolean)skipIfBuildNotOk, (boolean)false);
    }

    public Object readResolve() {
        String _testResults = this.getTestResults();
        Boolean _failIfNoResults = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getFailIfNoResults(), (boolean)false);
        Boolean _failedTestsMarkBuildAsFailure = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getFailedTestsMarkBuildAsFailure(), (boolean)false);
        Boolean _outputTapToConsole = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getOutputTapToConsole(), (boolean)false);
        Boolean _enableSubtests = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getEnableSubtests(), (boolean)true);
        Boolean _discardOldReports = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getDiscardOldReports(), (boolean)false);
        Boolean _todoIsFailure = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getTodoIsFailure(), (boolean)true);
        Boolean _includeCommentDiagnostics = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getIncludeCommentDiagnostics(), (boolean)true);
        Boolean _validateNumberOfTests = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getValidateNumberOfTests(), (boolean)false);
        Boolean _planRequired = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getPlanRequired(), (boolean)true);
        Boolean _verbose = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getVerbose(), (boolean)true);
        Boolean _showOnlyFailures = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getShowOnlyFailures(), (boolean)false);
        Boolean _stripSingleParents = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getStripSingleParents(), (boolean)false);
        Boolean _flattenTapResult = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getFlattenTapResult(), (boolean)false);
        Boolean _removeYamlIfCorrupted = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.getRemoveYamlIfCorrupted(), (boolean)false);
        return new TapPublisher(_testResults, _failIfNoResults, _failedTestsMarkBuildAsFailure, _outputTapToConsole, _enableSubtests, _discardOldReports, _todoIsFailure, _includeCommentDiagnostics, _validateNumberOfTests, _planRequired, _verbose, _showOnlyFailures, _stripSingleParents, _flattenTapResult, _removeYamlIfCorrupted);
    }

    public Boolean getShowOnlyFailures() {
        return this.showOnlyFailures;
    }

    public Boolean getStripSingleParents() {
        return this.stripSingleParents;
    }

    public Boolean getFailIfNoResults() {
        return this.failIfNoResults;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public Boolean getFailedTestsMarkBuildAsFailure() {
        return this.failedTestsMarkBuildAsFailure;
    }

    public Boolean getOutputTapToConsole() {
        return this.outputTapToConsole;
    }

    public Boolean getEnableSubtests() {
        return this.enableSubtests;
    }

    public Boolean getDiscardOldReports() {
        return this.discardOldReports;
    }

    public Boolean getTodoIsFailure() {
        return this.todoIsFailure;
    }

    public Boolean getIncludeCommentDiagnostics() {
        return this.includeCommentDiagnostics;
    }

    public Boolean getValidateNumberOfTests() {
        return this.validateNumberOfTests;
    }

    public Boolean getPlanRequired() {
        return this.planRequired;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getFlattenTapResult() {
        return this.flattenTapResult;
    }

    public Boolean getRemoveYamlIfCorrupted() {
        return this.removeYamlIfCorrupted;
    }

    public Boolean getSkipIfBuildNotOk() {
        return this.skipIfBuildNotOk;
    }

    public static FilePath getReportsDirectory(Run build) {
        return new FilePath(new File(build.getRootDir().getAbsolutePath())).child("tap-master-files");
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TapProjectAction(project);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.performImpl(run, workspace, listener);
    }

    private boolean performImpl(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        if (this.isPerformPublisher(build)) {
            boolean appending;
            logger.println("TAP Reports Processing: START");
            EnvVars envVars = build.getEnvironment(listener);
            String antPattern = Util.replaceMacro((String)this.testResults, (Map)envVars);
            logger.println("Looking for TAP results report in workspace using pattern: " + antPattern);
            FilePath[] reports = this.locateReports(workspace, antPattern);
            if (this.getDiscardOldReports().booleanValue()) {
                reports = this.checkReports(build, reports, logger);
            }
            if (reports.length == 0) {
                if (this.getFailIfNoResults().booleanValue()) {
                    logger.println("Did not find any matching files. Setting build result to FAILURE.");
                    build.setResult(Result.FAILURE);
                    return Boolean.FALSE;
                }
                logger.println("Did not find any matching files.");
                return Boolean.TRUE;
            }
            boolean filesSaved = this.saveReports(workspace, TapPublisher.getReportsDirectory(build), reports, logger);
            if (!filesSaved) {
                logger.println("Failed to save TAP reports");
                return Boolean.TRUE;
            }
            TapResult testResult = null;
            try {
                testResult = this.loadResults(antPattern, build, logger);
                testResult.setShowOnlyFailures(this.getShowOnlyFailures());
                testResult.tally();
            }
            catch (Throwable t) {
                t.printStackTrace(logger);
            }
            TapTestResultAction trAction = (TapTestResultAction)build.getAction(TapTestResultAction.class);
            if (trAction == null) {
                appending = false;
                trAction = new TapTestResultAction(build, testResult);
            } else {
                appending = true;
                trAction.mergeResult(testResult);
            }
            if (!appending) {
                build.addAction((Action)trAction);
            }
            if (testResult.getTestSets().size() > 0 || testResult.getParseErrorTestSets().size() > 0) {
                TapBuildAction action = (TapBuildAction)build.getAction(TapBuildAction.class);
                if (action == null) {
                    action = new TapBuildAction(build, testResult);
                    build.addAction((Action)action);
                } else {
                    appending = true;
                    action.mergeResult(testResult);
                }
                if (testResult.hasParseErrors()) {
                    listener.getLogger().println("TAP parse errors found in the build. Marking build as UNSTABLE");
                    build.setResult(Result.UNSTABLE);
                }
                if (this.getValidateNumberOfTests().booleanValue() && !this.validateNumberOfTests(testResult.getTestSets())) {
                    listener.getLogger().println("Not all test cases were executed according to the test set plan. Marking build as UNSTABLE");
                    build.setResult(Result.UNSTABLE);
                }
                if (testResult.getFailed() > 0) {
                    if (this.getFailedTestsMarkBuildAsFailure().booleanValue()) {
                        listener.getLogger().println("There are failed test cases and the job is configured to mark the build as failure. Marking build as FAILURE");
                        build.setResult(Result.FAILURE);
                    } else {
                        listener.getLogger().println("There are failed test cases. Marking build as UNSTABLE");
                        build.setResult(Result.UNSTABLE);
                    }
                }
                if (appending) {
                    build.save();
                }
            } else {
                logger.println("Found matching files but did not find any TAP results.");
                return Boolean.TRUE;
            }
            logger.println("TAP Reports Processing: FINISH");
        } else {
            logger.println("Build result is not better or equal unstable. Skipping TAP publisher.");
        }
        return Boolean.TRUE;
    }

    private boolean isPerformPublisher(Run<?, ?> build) {
        Result result = build.getResult();
        if (result == null) {
            return true;
        }
        if (!this.getSkipIfBuildNotOk().booleanValue()) {
            return true;
        }
        return result.isBetterOrEqualTo(Result.UNSTABLE);
    }

    private boolean validateNumberOfTests(List<TestSetMap> testSets) {
        for (TestSetMap testSetMap : testSets) {
            int numberOfTests;
            int planned;
            TestSet testSet = testSetMap.getTestSet();
            Plan plan = testSet.getPlan();
            if (plan == null || (planned = plan.getLastTestNumber().intValue()) == (numberOfTests = testSet.getTestResults().size())) continue;
            return false;
        }
        return true;
    }

    private TapResult loadResults(String antPattern, Run owner, PrintStream logger) {
        FilePath tapDir = TapPublisher.getReportsDirectory(owner);
        try {
            FilePath[] results = tapDir.list(antPattern);
            TapParser parser = new TapParser(this.getOutputTapToConsole(), this.getEnableSubtests(), this.getTodoIsFailure(), this.getIncludeCommentDiagnostics(), this.getValidateNumberOfTests(), this.getPlanRequired(), this.getVerbose(), this.getStripSingleParents(), this.getFlattenTapResult(), this.getRemoveYamlIfCorrupted(), logger);
            TapResult result = parser.parse(results, owner);
            result.setOwner(owner);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            TapResult tr = new TapResult("", owner, Collections.emptyList(), this.getTodoIsFailure(), this.getIncludeCommentDiagnostics(), this.getValidateNumberOfTests());
            tr.setOwner(owner);
            return tr;
        }
    }

    private boolean saveReports(FilePath workspace, FilePath tapDir, FilePath[] reports, PrintStream logger) {
        logger.println("Saving reports...");
        try {
            tapDir.mkdirs();
            for (FilePath report : reports) {
                FilePath dst = this.getDistDir(workspace, tapDir, report);
                report.copyTo(dst);
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            return false;
        }
        return true;
    }

    private FilePath getDistDir(FilePath workspace, FilePath tapDir, FilePath orig) {
        if (orig == null) {
            return null;
        }
        StringBuilder difference = new StringBuilder();
        FilePath parent = orig.getParent();
        while (!parent.equals((Object)workspace)) {
            difference.insert(0, parent.getName() + File.separatorChar);
            if ((parent = parent.getParent()) != null) continue;
        }
        difference.append(orig.getName());
        return tapDir.child(difference.toString());
    }

    private FilePath[] checkReports(Run build, FilePath[] reports, PrintStream logger) {
        ArrayList<FilePath> filePathList = new ArrayList<FilePath>(reports.length);
        for (FilePath report : reports) {
            try {
                if (build.getTimestamp().getTimeInMillis() / 1000L <= report.lastModified() / 1000L) {
                    filePathList.add(report);
                    continue;
                }
                logger.println(report.getName() + " was last modified before this build started. Ignoring it.");
            }
            catch (IOException e) {
                e.printStackTrace(logger);
            }
            catch (InterruptedException e) {
                e.printStackTrace(logger);
            }
        }
        return filePathList.toArray(new FilePath[0]);
    }

    private FilePath[] locateReports(FilePath workspace, String testResults) throws IOException, InterruptedException {
        return workspace.list(testResults);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TestResultAggregator(build, launcher, listener);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(TapPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Publish TAP Results";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Boolean.TRUE;
        }
    }
}

