/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin;

import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.parser.ParserException;
import org.tap4j.parser.Tap13Parser;
import org.tap4j.plugin.TapResult;
import org.tap4j.plugin.model.ParseErrorTestSetMap;
import org.tap4j.plugin.model.TestSetMap;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public class TapParser {
    private static final Logger log = Logger.getLogger(TapParser.class.getName());
    private final Boolean outputTapToConsole;
    private final Boolean enableSubtests;
    private final Boolean todoIsFailure;
    private final PrintStream logger;
    private final Boolean includeCommentDiagnostics;
    private final Boolean validateNumberOfTests;
    private final Boolean planRequired;
    private final Boolean verbose;
    private final Boolean stripSingleParents;
    private final Boolean flattenTheTap;
    private final Boolean removeYamlIfCorrupted;
    private boolean hasFailedTests;
    private boolean parserErrors;

    public TapParser(Boolean outputTapToConsole, Boolean enableSubtests, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests, Boolean planRequired, Boolean verbose, Boolean stripSingleParents, Boolean flattenTheTap, Boolean removeYamlIfCorrupted, PrintStream logger) {
        this.outputTapToConsole = outputTapToConsole;
        this.enableSubtests = enableSubtests;
        this.todoIsFailure = todoIsFailure;
        this.parserErrors = false;
        this.includeCommentDiagnostics = includeCommentDiagnostics;
        this.validateNumberOfTests = validateNumberOfTests;
        this.planRequired = planRequired;
        this.verbose = verbose;
        this.stripSingleParents = stripSingleParents;
        this.flattenTheTap = flattenTheTap;
        this.removeYamlIfCorrupted = removeYamlIfCorrupted;
        this.logger = logger;
    }

    public Boolean hasParserErrors() {
        return this.parserErrors;
    }

    public Boolean getOutputTapToConsole() {
        return this.outputTapToConsole;
    }

    public Boolean getTodoIsFailure() {
        return this.todoIsFailure;
    }

    public boolean getParserErrors() {
        return this.parserErrors;
    }

    public boolean getStripSingleParents() {
        return this.stripSingleParents;
    }

    public Boolean getIncludeCommentDiagnostics() {
        return this.includeCommentDiagnostics;
    }

    public Boolean getValidateNumberOfTests() {
        return this.validateNumberOfTests;
    }

    public Boolean getPlanRequired() {
        return this.planRequired;
    }

    public Boolean getEnableSubtests() {
        return this.enableSubtests;
    }

    public boolean hasFailedTests() {
        return this.hasFailedTests;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public boolean getFlattenTheTap() {
        return this.flattenTheTap;
    }

    public Boolean getRemoveYamlIfCorrupted() {
        return this.enableSubtests;
    }

    private boolean containsNotOk(TestSet testSet) {
        for (TestResult testResult : testSet.getTestResults()) {
            if (!testResult.getStatus().equals((Object)StatusValues.NOT_OK) || testResult.getDirective() != null && DirectiveValues.SKIP == testResult.getDirective().getDirectiveValue()) continue;
            return true;
        }
        return false;
    }

    public TapResult parse(FilePath[] results, Run build) {
        this.parserErrors = Boolean.FALSE;
        this.hasFailedTests = Boolean.FALSE;
        LinkedList<TestSetMap> testSets = new LinkedList<TestSetMap>();
        if (null == results) {
            this.log("File paths not specified. paths var is null. Returning empty test results.");
        } else {
            for (FilePath path : results) {
                File tapFile = new File(path.getRemote());
                if (!tapFile.isFile()) {
                    this.log("'" + tapFile.getAbsolutePath() + "' points to an invalid test report");
                    continue;
                }
                this.log("Processing '" + tapFile.getAbsolutePath() + "'");
                try {
                    this.log("Parsing TAP test result [" + tapFile + "].");
                    Tap13Parser parser = new Tap13Parser("UTF-8", this.enableSubtests.booleanValue(), this.planRequired.booleanValue(), this.removeYamlIfCorrupted.booleanValue());
                    TestSet testSet = this.flattenTheSetAsRequired(this.stripSingleParentsAsRequired(parser.parseFile(tapFile)));
                    if (this.containsNotOk(testSet) || testSet.containsBailOut().booleanValue()) {
                        this.hasFailedTests = Boolean.TRUE;
                    }
                    TestSetMap map = new TestSetMap(tapFile.getAbsolutePath(), testSet);
                    testSets.add(map);
                    if (!this.outputTapToConsole.booleanValue()) continue;
                    try {
                        this.log(FileUtils.readFileToString((File)tapFile));
                    }
                    catch (RuntimeException re) {
                        this.log(re);
                    }
                    catch (IOException e) {
                        this.log(e);
                    }
                }
                catch (ParserException pe) {
                    testSets.add(new ParseErrorTestSetMap(tapFile.getAbsolutePath(), pe));
                    this.parserErrors = Boolean.TRUE;
                    this.log((Exception)((Object)pe));
                }
            }
        }
        TapResult testResult = new TapResult("TAP Test Results", build, testSets, this.todoIsFailure, this.includeCommentDiagnostics, this.validateNumberOfTests);
        return testResult;
    }

    private TestSet stripSingleParentsAsRequired(TestSet originalSet) {
        if (!this.stripSingleParents.booleanValue()) {
            return originalSet;
        }
        TestSet result = originalSet;
        while (this.hasSingleParent(result)) {
            result = ((TestResult)result.getTestResults().get(0)).getSubtest();
        }
        return result;
    }

    private TestSet flattenTheSetAsRequired(TestSet originalSet) {
        if (!this.flattenTheTap.booleanValue()) {
            return originalSet;
        }
        TestSet result = new TestSet();
        List resultsToProcess = originalSet.getTestResults();
        int testIndex = 1;
        while (!resultsToProcess.isEmpty()) {
            TestResult actualTestResult = (TestResult)resultsToProcess.remove(0);
            TestSet subtests = actualTestResult.getSubtest();
            if (subtests == null || subtests.getNumberOfTestResults() == 0) {
                actualTestResult.setTestNumber(Integer.valueOf(testIndex++));
                result.addTestResult(actualTestResult);
                continue;
            }
            List subtestResults = subtests.getTestResults();
            for (TestResult subtestResult : subtestResults) {
                subtestResult.setDescription(actualTestResult.getDescription() + subtestResult.getDescription());
                resultsToProcess.add(subtestResult);
            }
            Plan subtestPlan = subtests.getPlan();
            boolean planIsPresent = subtestPlan != null;
            int subtestCountAsPlanned = planIsPresent ? subtestPlan.getLastTestNumber() - subtestPlan.getInitialTestNumber() + 1 : -1;
            boolean subtestCountDiffersFromPlan = planIsPresent && subtestCountAsPlanned != subtestResults.size();
            if (!subtestCountDiffersFromPlan) continue;
            int missingTestCount = subtestCountAsPlanned - subtestResults.size();
            TestResult timeoutTestResult = new TestResult();
            timeoutTestResult.setStatus(StatusValues.NOT_OK);
            timeoutTestResult.setDescription(String.format("%s %s %d %s", actualTestResult.getDescription(), "failed:", missingTestCount, "subtest(s) missing"));
            resultsToProcess.add(timeoutTestResult);
        }
        return result;
    }

    private boolean hasSingleParent(TestSet testSet) {
        int planSpan;
        if (testSet == null) {
            return false;
        }
        if (testSet.getNumberOfTestResults() != 1) {
            return false;
        }
        int n = planSpan = testSet.getPlan() != null ? testSet.getPlan().getLastTestNumber() - testSet.getPlan().getInitialTestNumber() : 0;
        if (planSpan == 0) {
            return ((TestResult)testSet.getTestResults().get(0)).getSubtest() != null;
        }
        return false;
    }

    private void log(String str) {
        if (this.verbose.booleanValue() && this.logger != null) {
            this.logger.println(str);
        } else {
            log.fine(str);
        }
    }

    private void log(Exception ex) {
        if (this.logger != null) {
            ex.printStackTrace(this.logger);
        } else {
            log.severe(ex.toString());
        }
    }
}

