/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin;

import hudson.model.Action;
import hudson.model.Run;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;
import org.tap4j.plugin.TapResult;

public class TapBuildAction
implements Action,
Serializable,
StaplerProxy {
    private static final long serialVersionUID = 520981690971849654L;
    public static final String URL_NAME = "tapResults";
    public static final String ICON_NAME = "/plugin/tap/icons/tap-24.png";
    public static final String DISPLAY_NAME = "TAP Extended Test Results";
    private final Run build;
    private TapResult result;

    public TapBuildAction(Run build, TapResult result) {
        this.build = build;
        this.result = result;
    }

    public Object getTarget() {
        return this.result;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getIconFileName() {
        return ICON_NAME;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Run getBuild() {
        return this.build;
    }

    public TapResult getResult() {
        return this.result;
    }

    public TapResult getPreviousResult() {
        TapResult previousResult = null;
        TapBuildAction previousAction = this.getPreviousAction();
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    public TapBuildAction getPreviousAction() {
        Run previousBuild;
        TapBuildAction previousAction = null;
        if (this.build != null && (previousBuild = this.build.getPreviousBuild()) != null) {
            previousAction = (TapBuildAction)previousBuild.getAction(TapBuildAction.class);
        }
        return previousAction;
    }

    public void mergeResult(TapResult other) {
        this.result = this.result.copyWithExtraTestSets(other.getTestSets());
        this.result.tally();
    }
}

