/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.container.maven.shade;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.talend.sdk.component.container.maven.shade.ArtifactTransformer;

public class PluginTransformer
extends ArtifactTransformer {
    private String pluginListResource = "TALEND-INF/plugins.properties";

    public void modifyOutputStream(JarOutputStream jarOutputStream) throws IOException {
        if (this.artifacts.isEmpty()) {
            return;
        }
        Properties properties = this.artifacts.stream().filter(this::isComponent).collect(Properties::new, (props, artifact) -> {
            String filename = String.format("%s-%s%s.%s", artifact.getArtifactId(), artifact.getVersion(), Optional.ofNullable(artifact.getClassifier()).filter(c -> !c.isEmpty()).map(c -> '-' + c).orElse(""), Optional.ofNullable(artifact.getType()).orElse("jar"));
            String pluginName = artifact.getArtifactId() + Optional.ofNullable(artifact.getClassifier()).filter(c -> !c.isEmpty()).map(c -> '-' + c).orElse("");
            props.setProperty(pluginName, String.format("%s/%s/%s/%s", artifact.getGroupId().replace(".", "/"), artifact.getArtifactId(), artifact.getVersion(), filename));
        }, Hashtable::putAll);
        jarOutputStream.putNextEntry(new ZipEntry(this.pluginListResource));
        properties.store(jarOutputStream, "plugin list");
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        super.processResource(resource, is, relocators, time);
    }

    public void processResource(String s, InputStream inputStream, List<Relocator> list) throws IOException {
        throw new UnsupportedOperationException("#processResource()");
    }

    public void setPluginListResource(String pluginListResource) {
        this.pluginListResource = pluginListResource;
    }
}

