/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.container.maven.shade;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.talend.sdk.component.container.maven.shade.ArtifactTransformer;

public class ContainerDependenciesTransformer
extends ArtifactTransformer {
    private String repositoryBase = "MAVEN-INF/repository/";
    private String ignoredPaths = "META-INF/";
    private Collection<String> ignoredPathsRuntime = null;

    public void modifyOutputStream(JarOutputStream jarOutputStream) {
        HashSet existing = new HashSet();
        this.artifacts.forEach(artifact -> {
            try {
                String path = String.format("%s%s/%s/%s/%s-%s%s.%s", this.repositoryBase, artifact.getGroupId().replace(".", "/"), artifact.getArtifactId(), artifact.getVersion(), artifact.getArtifactId(), artifact.getVersion(), Optional.ofNullable(artifact.getClassifier()).map(c -> '-' + c).orElse(""), Optional.ofNullable(artifact.getType()).orElse("jar"));
                StringBuilder current = new StringBuilder();
                String[] parts = path.split("/");
                for (int i = 0; i < parts.length - 1; ++i) {
                    current.append(parts[i]).append("/");
                    String folderPath = current.toString();
                    if (this.isExcluded(folderPath) || !existing.add(folderPath)) continue;
                    try {
                        jarOutputStream.putNextEntry(new ZipEntry(folderPath));
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (existing.add(path)) {
                    if (artifact.getFile() == null) {
                        throw new IllegalArgumentException("No file specified for " + artifact);
                    }
                    jarOutputStream.putNextEntry(new ZipEntry(path));
                    Files.copy(artifact.getFile().toPath(), jarOutputStream);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private boolean isExcluded(String folderPath) {
        if (this.ignoredPathsRuntime == null) {
            this.ignoredPathsRuntime = this.ignoredPaths == null ? Collections.emptySet() : (Collection)Optional.of(this.ignoredPaths).map(p -> p.split(",")).map(Stream::of).orElseGet(Stream::empty).collect(Collectors.toSet());
        }
        return this.ignoredPathsRuntime.contains(folderPath);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        super.processResource(resource, is, relocators, time);
    }

    public void processResource(String s, InputStream inputStream, List<Relocator> list) throws IOException {
        throw new UnsupportedOperationException("#processResource()");
    }

    public void setRepositoryBase(String repositoryBase) {
        this.repositoryBase = repositoryBase;
    }

    public void setIgnoredPaths(String ignoredPaths) {
        this.ignoredPaths = ignoredPaths;
    }
}

