/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.container.maven.shade;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public abstract class ArtifactTransformer
implements ResourceTransformer {
    private MavenSession session;
    private String scope = "compile+runtime,-provided";
    private String include;
    private String exclude;
    private boolean includeTransitiveDependencies = true;
    private boolean includeProjectComponentDependencies = false;
    protected List<UserArtifact> userArtifacts;
    protected List<Artifact> artifacts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTransformedResource() {
        MavenProject project;
        this.artifacts = new ArrayList<Artifact>();
        ArtifactFilter filter = this.getFilter();
        if (this.userArtifacts != null && !this.userArtifacts.isEmpty()) {
            DependencyGraphBuilder graphBuilder;
            ProjectBuilder projectBuilder;
            ArtifactResolver resolver;
            PlexusContainer container = this.session.getContainer();
            try {
                resolver = (ArtifactResolver)ArtifactResolver.class.cast(container.lookup(ArtifactResolver.class, "default"));
                projectBuilder = (ProjectBuilder)ProjectBuilder.class.cast(container.lookup(ProjectBuilder.class, "default"));
                graphBuilder = this.includeTransitiveDependencies ? (DependencyGraphBuilder)DependencyGraphBuilder.class.cast(container.lookup(DependencyGraphBuilder.class, "default")) : null;
            }
            catch (ComponentLookupException e) {
                throw new IllegalArgumentException(e);
            }
            this.artifacts.addAll(this.userArtifacts.stream().flatMap(coords -> {
                try {
                    final String type = Optional.ofNullable(((UserArtifact)coords).type).filter(s -> !s.isEmpty()).orElse("jar");
                    DefaultArtifact art = new DefaultArtifact(((UserArtifact)coords).groupId, ((UserArtifact)coords).artifactId, ((UserArtifact)coords).version, ((UserArtifact)coords).scope, type, Optional.ofNullable(((UserArtifact)coords).classifier).orElse(""), (ArtifactHandler)new DefaultArtifactHandler(){
                        {
                            this.setExtension(type);
                        }
                    });
                    Artifact artifact = this.doResolve(resolver, (Artifact)art, this.session).getArtifact();
                    if (this.includeTransitiveDependencies) {
                        MavenProject fakeProject;
                        try {
                            fakeProject = projectBuilder.build(this.doResolve(resolver, (Artifact)new DefaultArtifact(art.getGroupId(), art.getArtifactId(), art.getVersion(), art.getScope(), "pom", null, (ArtifactHandler)new DefaultArtifactHandler(){
                                {
                                    this.setExtension("pom");
                                }
                            }), this.session).getArtifact().getFile(), this.session.getProjectBuildingRequest()).getProject();
                        }
                        catch (ProjectBuildingException e) {
                            throw new IllegalStateException(e);
                        }
                        fakeProject.setArtifact(artifact);
                        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                        request.setProject(fakeProject);
                        try {
                            DependencyNode transitives = graphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, filter);
                            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
                            transitives.accept((DependencyNodeVisitor)new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)new ArtifactDependencyNodeFilter(filter)));
                            return Stream.concat(Stream.of(artifact), visitor.getNodes().stream().map(DependencyNode::getArtifact).map(a -> {
                                try {
                                    return this.doResolve(resolver, (Artifact)a, this.session).getArtifact();
                                }
                                catch (ArtifactResolverException e) {
                                    throw new IllegalStateException(e);
                                }
                            }));
                        }
                        catch (DependencyGraphBuilderException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    return Stream.of(artifact);
                }
                catch (ArtifactResolverException e) {
                    throw new IllegalArgumentException(e);
                }
            }).collect(Collectors.toSet()));
        }
        if (this.includeProjectComponentDependencies && (project = this.session.getCurrentProject()).getArtifacts() != null && !project.getArtifacts().isEmpty()) {
            project.setArtifactFilter(filter);
            try {
                this.artifacts.addAll(project.getArtifacts());
            }
            finally {
                project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Collections.singletonList("runtime")));
            }
        }
        return !this.artifacts.isEmpty();
    }

    private ArtifactResult doResolve(ArtifactResolver resolver, Artifact art, MavenSession session) throws ArtifactResolverException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        session.getTopLevelProject().getPluginRepositories().stream().map(this::toArtifactRepo).filter(arg_0 -> ArtifactTransformer.lambda$doResolve$4((ProjectBuildingRequest)request, arg_0)).forEach(arg_0 -> ArtifactTransformer.lambda$doResolve$5((ProjectBuildingRequest)request, arg_0));
        return resolver.resolveArtifact((ProjectBuildingRequest)request, art);
    }

    private ArtifactRepository toArtifactRepo(Repository repository) {
        ArtifactRepositoryPolicy releases;
        ArtifactRepositoryPolicy snapshots;
        if (repository.getSnapshots() == null) {
            snapshots = null;
        } else {
            snapshots = new ArtifactRepositoryPolicy();
            snapshots.setChecksumPolicy(repository.getSnapshots().getChecksumPolicy());
            snapshots.setEnabled(repository.getSnapshots().isEnabled());
            snapshots.setUpdatePolicy(repository.getSnapshots().getUpdatePolicy());
        }
        if (repository.getReleases() == null) {
            releases = null;
        } else {
            releases = new ArtifactRepositoryPolicy();
            releases.setChecksumPolicy(repository.getReleases().getChecksumPolicy());
            releases.setEnabled(repository.getReleases().isEnabled());
            releases.setUpdatePolicy(repository.getReleases().getUpdatePolicy());
        }
        return new MavenArtifactRepository(repository.getId(), repository.getUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshots, releases);
    }

    private ArtifactFilter getFilter() {
        ArrayList<Object> filters = new ArrayList<Object>(2);
        if (this.include != null) {
            filters.add(new IncludesArtifactFilter(Stream.of(this.include.split(",")).collect(Collectors.toList())));
        }
        if (this.exclude != null) {
            filters.add(new ExcludesArtifactFilter(Stream.of(this.exclude.split(",")).collect(Collectors.toList())));
        }
        if (this.scope != null) {
            filters.addAll(Stream.of(this.scope.split(",")).map(singleScope -> singleScope.startsWith("-") ? new ArtifactFilter(){
                private final ArtifactFilter delegate;
                final /* synthetic */ String val$singleScope;
                {
                    this.val$singleScope = string;
                    this.delegate = ArtifactTransformer.this.newScopeFilter(this.val$singleScope.substring(1));
                }

                public boolean include(Artifact artifact) {
                    return !this.delegate.include(artifact);
                }
            } : this.newScopeFilter((String)singleScope)).collect(Collectors.toList()));
        }
        return new AndArtifactFilter(filters);
    }

    public boolean canTransformResource(String resource) {
        return false;
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
    }

    private ArtifactFilter newScopeFilter(String singleScope) {
        return "provided".equals(singleScope) ? artifact -> "provided".equals(artifact.getScope()) : new ScopeArtifactFilter(singleScope);
    }

    protected boolean isComponent(Artifact artifact) {
        boolean bl;
        File file = artifact.getFile();
        if (file.isDirectory()) {
            return new File(file, "TALEND-INF/dependencies.txt").exists();
        }
        JarFile jar = new JarFile(file);
        try {
            bl = jar.getEntry("TALEND-INF/dependencies.txt") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        jar.close();
        return bl;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setIncludeTransitiveDependencies(boolean includeTransitiveDependencies) {
        this.includeTransitiveDependencies = includeTransitiveDependencies;
    }

    public void setIncludeProjectComponentDependencies(boolean includeProjectComponentDependencies) {
        this.includeProjectComponentDependencies = includeProjectComponentDependencies;
    }

    public void setUserArtifacts(List<UserArtifact> userArtifacts) {
        this.userArtifacts = userArtifacts;
    }

    private static /* synthetic */ void lambda$doResolve$5(ProjectBuildingRequest request, ArtifactRepository it) {
        request.getRemoteRepositories().add(it);
    }

    private static /* synthetic */ boolean lambda$doResolve$4(ProjectBuildingRequest request, ArtifactRepository it) {
        return request.getPluginArtifactRepositories().stream().noneMatch(a -> String.valueOf(a.getId()).equalsIgnoreCase(it.getId()));
    }

    public static final class UserArtifact {
        private String groupId;
        private String artifactId;
        private String version;
        private String scope;
        private String classifier;
        private String type;
        private String file;

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getScope() {
            return this.scope;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getType() {
            return this.type;
        }

        public String getFile() {
            return this.file;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserArtifact)) {
                return false;
            }
            UserArtifact other = (UserArtifact)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            return !(this$file == null ? other$file != null : !this$file.equals(other$file));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            return result;
        }

        public String toString() {
            return "ArtifactTransformer.UserArtifact(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", classifier=" + this.getClassifier() + ", type=" + this.getType() + ", file=" + this.getFile() + ")";
        }
    }
}

