/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.tools.validator.Validator;

public class OptionNameValidator
implements Validator {
    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        return finder.findAnnotatedFields(Option.class).stream().filter(field -> {
            String name = this.nameOption((Field)field);
            return name.contains(".") || name.startsWith("$");
        }).distinct().map(field -> {
            String name = this.nameOption((Field)field);
            return "Option name `" + name + "` is invalid, you can't start an option name with a '$' and it can't contain a '.'. Please fix it on field `" + field.getDeclaringClass().getName() + "#" + field.getName() + "`";
        }).sorted();
    }

    private String nameOption(Field field) {
        return field.getAnnotation(Option.class).value();
    }
}

