/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.tools.spi.ValidationExtension;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class ExtensionValidator
implements Validator {
    private final ValidationExtension extension;
    private final Validators.ValidatorHelper helper;

    public ExtensionValidator(ValidationExtension extension, Validators.ValidatorHelper helper) {
        this.extension = extension;
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(final AnnotationFinder finder, final List<Class<?>> components) {
        ValidationExtension.ValidationContext context = new ValidationExtension.ValidationContext(){

            @Override
            public AnnotationFinder finder() {
                return finder;
            }

            @Override
            public List<Class<?>> components() {
                return components;
            }

            @Override
            public List<ParameterMeta> parameters(Class<?> component) {
                return ExtensionValidator.this.helper.buildOrGetParameters(component);
            }
        };
        ValidationExtension.ValidationResult result = this.extension.validate(context);
        Stream<String> errors = result == null || result.getErrors() == null ? Stream.empty() : result.getErrors().stream();
        return errors.filter(Objects::nonNull);
    }
}

