/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.internationalization.ParameterBundle;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ConditionParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ConfigurationTypeParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.util.DefaultValueInspector;
import org.talend.sdk.component.tools.AsciidoctorExecutor;
import org.talend.sdk.component.tools.BaseTask;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class AsciidocDocumentationGenerator
extends BaseTask {
    private final File output;
    private final String levelPrefix;
    private final DefaultValueInspector defaultValueInspector = new DefaultValueInspector();
    private final Map<String, String> formats;
    private final Map<String, String> attributes;
    private final File templateDir;
    private final File workDir;
    private final String templateEngine;
    private final String title;
    private final String version;
    private final Log log;
    private final Locale locale;
    private final AbsolutePathResolver resolver = new AbsolutePathResolver();
    private final ParameterModelService parameterModelService = new ParameterModelService(Arrays.asList((parameterName, parameterType, annotation) -> annotation.annotationType() == Documentation.class ? Collections.singletonMap("documentation", ((Documentation)Documentation.class.cast(annotation)).value()) : Collections.emptyMap(), new ConditionParameterEnricher(), new ConfigurationTypeParameterEnricher()), new PropertyEditorRegistry()){};

    public AsciidocDocumentationGenerator(File[] classes, File output, String title, int level, Map<String, String> formats, Map<String, String> attributes, File templateDir, String templateEngine, Object log, File workDir, String version, Locale locale) {
        super(classes);
        this.locale = locale;
        this.title = title;
        this.output = output;
        this.formats = formats;
        this.attributes = attributes;
        this.templateDir = templateDir;
        this.templateEngine = templateEngine;
        this.workDir = workDir;
        this.version = version;
        this.levelPrefix = IntStream.range(0, level).mapToObj(i -> "=").collect(Collectors.joining(""));
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        Throwable throwable;
        AnnotationFinder finder = this.newFinder();
        String doc = this.findComponents(finder).map(this::toAsciidoc).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        this.output.getParentFile().mkdirs();
        try {
            throwable = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));){
                writer.write(doc);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.log.info("Generated " + this.output.getAbsolutePath());
        throwable = null;
        try (AsciidoctorExecutor asciidoctorExecutor = new AsciidoctorExecutor();){
            Optional.ofNullable(this.formats).ifPresent(f -> f.forEach((format, output) -> {
                switch (format.toLowerCase(Locale.ENGLISH)) {
                    case "html": {
                        asciidoctorExecutor.render(this.workDir, this.version, this.log, "html5", this.output, new File((String)output), this.title, this.attributes, this.templateDir, this.templateEngine);
                        break;
                    }
                    case "pdf": {
                        asciidoctorExecutor.render(this.workDir, this.version, this.log, "pdf", this.output, new File((String)output), this.title, this.attributes, this.templateDir, this.templateEngine);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown format: '" + format + "', supported: [html, pdf]");
                    }
                }
            }));
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    protected Stream<Class<?>> findComponents(AnnotationFinder finder) {
        return this.componentMarkers().flatMap(a -> finder.findAnnotatedClasses(a).stream());
    }

    private String toAsciidoc(Class<?> aClass) {
        List parameterMetas = this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor(aClass), Optional.ofNullable(aClass.getPackage()).map(Package::getName).orElse(""), new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools")));
        return this.levelPrefix + " " + this.componentMarkers().filter(aClass::isAnnotationPresent).map(aClass::getAnnotation).map(this::asComponent).findFirst().orElseThrow(NoSuchElementException::new).name() + "\n\n" + this.getDoc(aClass) + (parameterMetas.isEmpty() ? "" : this.levelPrefix + "= Configuration\n\n" + this.toAsciidocRows(this.sort(parameterMetas), null, null, new HashMap<String, String>()).collect(Collectors.joining("\n", "[cols=\"d,d,m,a,e\",options=\"header\"]\n|===\n|Display Name|Description|Default Value|Enabled If|Configuration Path|Configuration Type\n", "\n|===\n\n")));
    }

    private String getDoc(Class<?> component) {
        Collection docKeys = Stream.of(this.getComponentPrefix(component), component.getSimpleName()).map(it -> it + "._documentation").collect(Collectors.toList());
        return Optional.ofNullable(this.findResourceBundle(component)).map(bundle -> docKeys.stream().filter(bundle::containsKey).map(bundle::getString).findFirst().map(v -> v + "\n\n").orElse(null)).orElseGet(() -> Optional.ofNullable(component.getAnnotation(Documentation.class)).map(Documentation::value).map(v -> v + "\n\n").orElse(""));
    }

    private String getComponentPrefix(Class<?> component) {
        try {
            return this.components(component).map(c -> this.findFamily((BaseTask.Component)c, component) + "." + c.name()).orElseGet(component::getSimpleName);
        }
        catch (RuntimeException e) {
            return component.getSimpleName();
        }
    }

    private Collection<ParameterMeta> sort(Collection<ParameterMeta> parameterMetas) {
        return parameterMetas.stream().sorted(Comparator.comparing(ParameterMeta::getPath)).collect(Collectors.toList());
    }

    private Stream<String> toAsciidocRows(Collection<ParameterMeta> parameterMetas, DefaultValueInspector.Instance parentInstance, ParameterBundle parentBundle, Map<String, String> types) {
        return parameterMetas.stream().flatMap(p -> {
            DefaultValueInspector.Instance instance = this.defaultValueInspector.createDemoInstance(Optional.ofNullable(parentInstance).map(DefaultValueInspector.Instance::getValue).orElse(null), p);
            return Stream.concat(Stream.of(this.toAsciidoctor((ParameterMeta)p, instance, parentBundle, types)), this.toAsciidocRows(p.getNestedParameters(), instance, this.findBundle((ParameterMeta)p), types));
        });
    }

    private String toAsciidoctor(ParameterMeta p, DefaultValueInspector.Instance instance, ParameterBundle parent, Map<String, String> types) {
        ParameterBundle bundle = this.findBundle(p);
        String type = this.findEnclosingConfigurationType(p, types);
        return "|" + bundle.displayName(parent).orElse(p.getName()) + '|' + bundle.documentation(parent).orElseGet(() -> this.findDocumentation(p)) + '|' + Optional.ofNullable(this.findDefault(p, instance)).orElse("-") + '|' + this.renderConditions(p.getPath(), p.getMetadata()) + '|' + p.getPath() + '|' + Optional.ofNullable(type).orElse("-");
    }

    private String findEnclosingConfigurationType(ParameterMeta p, Map<String, String> types) {
        String type = (String)p.getMetadata().get("tcomp::configurationtype::type");
        if (type != null) {
            types.put(p.getPath(), type);
        } else {
            int sep;
            String currentPath = p.getPath();
            while (type == null && (sep = currentPath.lastIndexOf(46)) >= 0) {
                currentPath = currentPath.substring(0, sep);
                type = types.get(currentPath);
            }
        }
        return type;
    }

    private String findDefault(ParameterMeta p, DefaultValueInspector.Instance instance) {
        if (instance == null || instance.getValue() == null || instance.isCreated()) {
            return null;
        }
        switch (p.getType()) {
            case NUMBER: 
            case BOOLEAN: 
            case STRING: 
            case ENUM: {
                return Optional.ofNullable(instance.getValue()).map(String::valueOf).map(it -> it.isEmpty() ? "<empty>" : it).orElse(null);
            }
            case ARRAY: {
                return String.valueOf(Collection.class.isInstance(instance.getValue()) ? ((Collection)Collection.class.cast(instance.getValue())).size() : Array.getLength(instance.getValue()));
            }
        }
        return null;
    }

    private String renderConditions(String path, Map<String, String> metadata) {
        String globalOperator = metadata.getOrDefault("tcomp::condition::ifs::operator", "AND");
        Collection conditionEntries = metadata.keySet().stream().filter(it -> it.startsWith("tcomp::condition::if::target")).map(it -> new Condition((String)metadata.get(it), (String)metadata.get(it.replace("::target", "::value")), Boolean.parseBoolean((String)metadata.get(it.replace("::target", "::negate"))), (String)metadata.get(it.replace("::target", "::evaluationStrategy")))).collect(Collectors.toList());
        switch (conditionEntries.size()) {
            case 0: {
                return "Always enabled";
            }
            case 1: {
                return this.renderCondition(path, (Condition)conditionEntries.iterator().next());
            }
        }
        String conditions = conditionEntries.stream().map(c -> this.renderCondition(path, (Condition)c)).map(c -> "- " + c).collect(Collectors.joining("\n", "\n", "\n"));
        switch (globalOperator.toUpperCase(Locale.ROOT)) {
            case "OR": {
                return "One of these conditions is meet:\n" + conditions;
            }
        }
        return "All of the following conditions are met:\n" + conditions;
    }

    private String renderCondition(String paramPath, Condition condition) {
        String path = this.resolver.doResolveProperty(paramPath, condition.target);
        String values = Stream.of(condition.value.split(",")).map(v -> '`' + v + '`').collect(Collectors.joining(" or "));
        switch (Optional.ofNullable(condition.strategy).orElse("default").toLowerCase(Locale.ROOT)) {
            case "length": {
                if (condition.negate) {
                    if (values.equals("`0`")) {
                        return '`' + path + "` is not empty";
                    }
                    return "the length of `" + path + "` is not " + values;
                }
                if (values.equals("`0`")) {
                    return '`' + path + "` is empty";
                }
                return "the length of `" + path + "` is " + values;
            }
            case "contains": {
                if (condition.negate) {
                    return '`' + path + "` does not contain " + values;
                }
                return '`' + path + "` contains " + values;
            }
            case "contains(lowercase=true)": {
                if (condition.negate) {
                    return "the lowercase value of `" + path + "` does not contain " + values;
                }
                return "the lowercase value of `" + path + "` contains " + values;
            }
        }
        if (condition.negate) {
            return '`' + path + "` is not equal to " + values;
        }
        return '`' + path + "` is equal to " + values;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findDocumentation(ParameterMeta p) {
        String inline = (String)p.getMetadata().get("documentation");
        if (inline == null) return p.getName() + " configuration";
        if (!inline.startsWith("resource:")) return inline;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(inline.substring("resource:".length()));
        if (stream == null) throw new IllegalArgumentException("No resource: '" + inline + "'");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Bad resource: '" + inline + "'", e);
        }
    }

    private ParameterBundle findBundle(ParameterMeta p) {
        return p.findBundle(Thread.currentThread().getContextClassLoader(), this.locale);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    private static class AbsolutePathResolver {
        private AbsolutePathResolver() {
        }

        public String resolveProperty(String propPath, String paramRef) {
            return this.doResolveProperty(propPath, this.normalizeParamRef(paramRef));
        }

        private String normalizeParamRef(String paramRef) {
            return (!paramRef.contains(".") ? "../" : "") + paramRef;
        }

        private String doResolveProperty(String propPath, String paramRef) {
            if (".".equals(paramRef)) {
                return propPath;
            }
            if (paramRef.startsWith("..")) {
                String current = propPath;
                String ref = paramRef;
                while (ref.startsWith("..")) {
                    int lastDot = current.lastIndexOf(46);
                    if (lastDot < 0) {
                        lastDot = 0;
                    }
                    current = current.substring(0, lastDot);
                    if ((ref = ref.substring("..".length(), ref.length())).startsWith("/")) {
                        ref = ref.substring(1);
                    }
                    if (!current.isEmpty()) continue;
                    break;
                }
                return Stream.of(current, ref.replace('/', '.')).filter(it -> !it.isEmpty()).collect(Collectors.joining("."));
            }
            if (paramRef.startsWith(".") || paramRef.startsWith("./")) {
                return propPath + '.' + paramRef.replaceFirst("\\./?", "").replace('/', '.');
            }
            return paramRef;
        }
    }

    private static class Condition {
        private final String target;
        private final String value;
        private final boolean negate;
        private final String strategy;

        public Condition(String target, String value, boolean negate, String strategy) {
            this.target = target;
            this.value = value;
            this.negate = negate;
            this.strategy = strategy;
        }
    }
}

