/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.talend.sdk.component.tools.webapp.UIConfiguration;

@Dependent
@WebFilter(urlPatterns={"/*"}, asyncSupported=true, filterName="ResourceProxy")
public class ResourceProxy
implements Filter {
    @Inject
    private UIConfiguration uiConfiguration;
    private volatile String js;
    private volatile String css;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest http = (HttpServletRequest)HttpServletRequest.class.cast(request);
        String uri = http.getRequestURI().substring(http.getContextPath().length());
        if (uri.startsWith("/main-")) {
            if (uri.endsWith(".js") && this.uiConfiguration.getJsLocation().isPresent()) {
                this.serveJs(response);
                return;
            }
            if (uri.endsWith(".css") && this.uiConfiguration.getCssLocation().isPresent()) {
                this.serveCss(response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveCss(ServletResponse response) throws IOException {
        if (this.css == null) {
            ResourceProxy resourceProxy = this;
            synchronized (resourceProxy) {
                if (this.css == null) {
                    this.css = this.load(this.uiConfiguration.getCssLocation().orElseThrow(IllegalArgumentException::new));
                }
            }
        }
        response.getWriter().write(this.css);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveJs(ServletResponse response) throws IOException {
        if (this.js == null) {
            ResourceProxy resourceProxy = this;
            synchronized (resourceProxy) {
                if (this.js == null) {
                    this.js = this.load(this.uiConfiguration.getJsLocation().orElseThrow(IllegalArgumentException::new));
                }
            }
        }
        response.getWriter().write(this.js);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String load(String url) {
        try (InputStream stream = new URL(url).openStream();){
            int count;
            byte[] buffer = new byte[16384];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (-1 != (count = stream.read(buffer))) {
                byteArrayOutputStream.write(buffer, 0, count);
            }
            String string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

