/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.talend.sdk.component.form.api.Client;
import org.talend.sdk.component.form.internal.jaxrs.JAXRSClient;

@ApplicationScoped
public class LazyClient
implements Client<Object> {
    private volatile Client<Object> client;
    private ExecutorService executorService;
    @Produces
    private volatile WebTarget webTarget;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lazyInit(Supplier<String> base) {
        if (this.client == null) {
            LazyClient lazyClient = this;
            synchronized (lazyClient) {
                if (this.client == null) {
                    String baseValue = base.get();
                    final AtomicInteger counter = new AtomicInteger(1);
                    this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 32, new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread thread = new Thread(r, "jaxrs-client-actions-" + counter.getAndIncrement());
                            thread.setDaemon(false);
                            thread.setPriority(5);
                            thread.setContextClassLoader(LazyClient.class.getClassLoader());
                            return thread;
                        }
                    });
                    javax.ws.rs.client.Client jaxrsClient = ((ClientBuilder)ClientBuilder.newBuilder().property("executorService", (Object)this.executorService)).build();
                    this.webTarget = jaxrsClient.target(baseValue);
                    this.client = new JAXRSClient(jaxrsClient, baseValue, true);
                }
            }
        }
    }

    @PreDestroy
    private void onDestroy() {
        Optional.ofNullable(this.executorService).ifPresent(ExecutorService::shutdownNow);
        this.client.close();
    }

    public CompletionStage<Map<String, Object>> action(String family, String type, String action, String lang, Map<String, Object> params, Object context) {
        return this.client.action(family, type, action, lang, params, context);
    }

    public void close() {
        this.client.close();
    }

    @Dependent
    @WebFilter(urlPatterns={"/api/v1/*"}, asyncSupported=true)
    public static class LazyInitializer
    implements Filter {
        @Inject
        private LazyClient lazyClient;

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.lazyClient.lazyInit(() -> {
                HttpServletRequest servletRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
                return String.format("%s://%s:%d/%s", servletRequest.getScheme(), servletRequest.getServerName(), servletRequest.getServerPort(), "api/v1");
            });
            chain.doFilter(request, response);
        }
    }
}

