/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.tomcat;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.apache.meecrowave.Meecrowave;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateCertificateAndActivateHttps
implements Meecrowave.ConfigurationCustomizer {
    private static final Logger log = LoggerFactory.getLogger(GenerateCertificateAndActivateHttps.class);

    public void accept(Meecrowave.Builder builder) {
        Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue("talend.component.server.ssl.active", Boolean.class).orElse(false).booleanValue()) {
            log.debug("Automatic ssl setup is not active, skipping");
            return;
        }
        log.debug("Automatic ssl setup is active");
        String password = config.getOptionalValue("talend.component.server.ssl.password", String.class).orElse("changeit");
        String location = config.getOptionalValue("talend.component.server.ssl.keystore.location", String.class).orElse(new File(System.getProperty("meecrowave.base", "."), "conf/ssl.p12").getAbsolutePath());
        String alias = config.getOptionalValue("talend.component.server.ssl.keystore.alias", String.class).orElse("talend");
        String keystoreType = config.getOptionalValue("talend.component.server.ssl.keystore.type", String.class).orElse("PKCS12");
        File keystoreLocation = new File(location);
        if (!keystoreLocation.exists() || config.getOptionalValue("talend.component.server.ssl.keystore.generation.force", Boolean.class).orElse(false).booleanValue()) {
            String generateCommand = config.getOptionalValue("talend.component.server.ssl.keystore.generation.command", String.class).orElse(null);
            if (keystoreLocation.getParentFile() == null || !keystoreLocation.getParentFile().exists() && !keystoreLocation.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("Can't create '" + keystoreLocation + "'");
            }
            try {
                if (generateCommand != null) {
                    log.debug("Generating certificate for HTTPS using a custom command");
                    this.doExec(GenerateCertificateAndActivateHttps.parseCommand(generateCommand));
                } else {
                    log.debug("Generating certificate for HTTPS");
                    this.doExec(new String[]{this.findKeyTool(), "-genkey", "-keyalg", config.getOptionalValue("talend.component.server.ssl.keypair.algorithm", String.class).orElse("RSA"), "-alias", alias, "-keystore", keystoreLocation.getAbsolutePath(), "-storepass", password, "-keypass", password, "-noprompt", "-dname", config.getOptionalValue("talend.component.server.ssl.certificate.dname", String.class).orElseGet(() -> "CN=Talend,OU=www.talend.com,O=component-server,C=" + this.getLocalId()), "-storetype", keystoreType, "-keysize", config.getOptionalValue("talend.component.server.ssl.keypair.size", Integer.class).map(String::valueOf).orElse("2048")});
                }
            }
            catch (InterruptedException ie) {
                log.error(ie.getMessage(), (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        builder.setSkipHttp(true);
        builder.setSsl(true);
        builder.setHttpsPort(config.getOptionalValue("talend.component.server.ssl.port", Integer.class).orElseGet(() -> ((Meecrowave.Builder)builder).getHttpPort()).intValue());
        builder.setKeystorePass(password);
        builder.setKeystoreFile(keystoreLocation.getAbsolutePath());
        builder.setKeystoreType(keystoreType);
        builder.setKeyAlias(alias);
        log.info("Configured HTTPS using '{}' on port {}", (Object)builder.getKeystoreFile(), (Object)builder.getHttpsPort());
    }

    private String getLocalId() {
        try {
            return InetAddress.getLocalHost().getHostName().replace('.', '_');
        }
        catch (UnknownHostException e) {
            return "local";
        }
    }

    private void doExec(String[] command) throws InterruptedException, IOException {
        Process process = new ProcessBuilder(command).start();
        new Thread(new KeyToolStream("stdout", process.getInputStream())).start();
        new Thread(new KeyToolStream("stderr", process.getErrorStream())).start();
        int status = process.waitFor();
        if (status != 0) {
            throw new IllegalStateException("Can't generate the certificate, exist code=" + status + ", check out stdout/stderr for details");
        }
    }

    private String findKeyTool() {
        String path;
        String ext = System.getProperty("os.name", "ignore").toLowerCase(Locale.ROOT).contains("win") ? ".exe" : "";
        File javaHome = new File(System.getProperty("java.home", "."));
        if (javaHome.exists()) {
            File keyTool = new File(javaHome, "bin/keytool" + ext);
            if (keyTool.exists()) {
                return keyTool.getAbsolutePath();
            }
            File jreKeyTool = new File(javaHome, "jre/bin/keytool" + ext);
            if (jreKeyTool.exists()) {
                return jreKeyTool.getAbsolutePath();
            }
        }
        if ((path = Optional.ofNullable(System.getenv("PATH")).orElseGet(() -> System.getenv().keySet().stream().filter(it -> it.equalsIgnoreCase("path")).findFirst().map(System::getenv).orElse(null))) != null) {
            return Stream.of(path.split(File.pathSeparator)).map(it -> new File((String)it, "keytool")).filter(File::exists).findFirst().map(File::getAbsolutePath).orElse(null);
        }
        throw new IllegalStateException("Didn't find keytool");
    }

    private static String[] parseCommand(String cmd) {
        if (cmd == null || cmd.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(cmd, "\"' ", true);
        ArrayList<String> v = new ArrayList<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    v.add(current.toString());
                    current = new StringBuffer();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new RuntimeException("unbalanced quotes in " + cmd);
        }
        return v.toArray(new String[0]);
    }

    private static class KeyToolStream
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(KeyToolStream.class);
        private final String name;
        private final InputStream stream;
        private final ByteArrayOutputStream builder = new ByteArrayOutputStream();

        private KeyToolStream(String name, InputStream stream) {
            this.name = name;
            this.stream = stream;
        }

        @Override
        public void run() {
            try {
                int num;
                byte[] buf = new byte[64];
                while ((num = this.stream.read(buf)) != -1) {
                    for (int i = 0; i < num; ++i) {
                        if (buf[i] == 13 || buf[i] == 10) {
                            this.doLog();
                            this.builder.reset();
                            continue;
                        }
                        this.builder.write(buf[i]);
                    }
                }
                if (this.builder.size() > 0) {
                    this.doLog();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void doLog() {
            String string = this.builder.toString().trim();
            if (string.isEmpty()) {
                return;
            }
            log.info("[" + this.name + "] " + string);
        }
    }
}

