/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.talend.sdk.component.container.Container;

@ApplicationScoped
public class IconResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon resolve(Container container, String icon) {
        if (icon == null) {
            return null;
        }
        Cache cache = (Cache)container.get(Cache.class);
        if (cache == null) {
            Container container2 = container;
            synchronized (container2) {
                cache = (Cache)container.get(Cache.class);
                if (cache == null) {
                    cache = new Cache();
                    container.set(Cache.class, (Object)cache);
                }
            }
        }
        return cache.icons.computeIfAbsent(icon, k -> this.doLoad((ClassLoader)container.getLoader(), icon)).orElse(null);
    }

    public Optional<Icon> doLoad(ClassLoader loader, String icon) {
        return Stream.of(icon + "_icon32.png", "icons/" + icon + "_icon32.png", "icons/svg/" + icon + "_icon32.png", "icons/svg-deprecated/" + icon + "_icon32.png").map(path -> {
            InputStream resource = loader.getResourceAsStream((String)path);
            if (resource == null) {
                return null;
            }
            return new Icon("image/png", this.toBytes(resource));
        }).filter(Objects::nonNull).findFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] toBytes(InputStream resource) {
        try (BufferedInputStream stream = new BufferedInputStream(resource);){
            int read;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(stream.available());
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
                if (read <= 0) continue;
                byteArrayOutputStream.write(buffer, 0, read);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Icon {
        private final String type;
        private final byte[] bytes;

        public Icon(String type, byte[] bytes) {
            this.type = type;
            this.bytes = bytes;
        }

        public String getType() {
            return this.type;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Icon)) {
                return false;
            }
            Icon other = (Icon)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return Arrays.equals(this.getBytes(), other.getBytes());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Icon;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + Arrays.hashCode(this.getBytes());
            return result;
        }

        public String toString() {
            return "IconResolver.Icon(type=" + this.getType() + ", bytes=" + Arrays.toString(this.getBytes()) + ")";
        }
    }

    private static class Cache {
        private final ConcurrentMap<String, Optional<Icon>> icons = new ConcurrentHashMap<String, Optional<Icon>>();

        private Cache() {
        }
    }
}

