/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public final class RecordImpl
implements Record {
    private static final RecordConverters RECORD_CONVERTERS = new RecordConverters();
    private final Map<String, Object> values;
    @JsonbTransient
    private final Schema schema;

    private RecordImpl(Map<String, Object> values, Schema schema) {
        this.values = values;
        this.schema = schema;
    }

    public <T> T get(Class<T> expectedType, String name) {
        Object value = this.values.get(name);
        if (value == null || expectedType.isInstance(value)) {
            return expectedType.cast(value);
        }
        return RECORD_CONVERTERS.coerce(expectedType, value, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).setProperty("johnzon.cdi.activated", (Object)false));){
            String string = new RecordConverters().toType(this, JsonObject.class, () -> Json.createBuilderFactory(Collections.emptyMap()), JsonProvider::provider, () -> jsonb).toString();
            return string;
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static class BuilderImpl
    implements Record.Builder {
        private final Map<String, Object> values = new HashMap<String, Object>(8);
        private final List<Schema.Entry> entries = new ArrayList<Schema.Entry>(8);

        public Record build() {
            return new RecordImpl(Collections.unmodifiableMap(this.values), new SchemaImpl(Schema.Type.RECORD, null, Collections.unmodifiableList(this.entries)));
        }

        public Record.Builder withString(String name, String value) {
            return this.withString(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.STRING).withNullable(true).build(), value);
        }

        public Record.Builder withString(Schema.Entry entry, String value) {
            this.assertType(entry.getType(), Schema.Type.STRING);
            return this.append(entry, value);
        }

        public Record.Builder withBytes(String name, byte[] value) {
            return this.withBytes(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.BYTES).withNullable(true).build(), value);
        }

        public Record.Builder withBytes(Schema.Entry entry, byte[] value) {
            this.assertType(entry.getType(), Schema.Type.BYTES);
            return this.append(entry, value);
        }

        public Record.Builder withDateTime(String name, Date value) {
            return this.withDateTime(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.DATETIME).withNullable(true).build(), value);
        }

        public Record.Builder withDateTime(Schema.Entry entry, Date value) {
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("date '" + entry.getName() + "' is not allowed to be null");
            }
            return this.withTimestamp(entry, value == null ? -1L : value.getTime());
        }

        public Record.Builder withDateTime(String name, ZonedDateTime value) {
            return this.withDateTime(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.DATETIME).withNullable(true).build(), value);
        }

        public Record.Builder withDateTime(Schema.Entry entry, ZonedDateTime value) {
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("datetime '" + entry.getName() + "' is not allowed to be null");
            }
            return this.withTimestamp(entry, value == null ? -1L : value.toInstant().toEpochMilli());
        }

        public Record.Builder withTimestamp(String name, long value) {
            return this.withTimestamp(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.DATETIME).withNullable(false).build(), value);
        }

        public Record.Builder withTimestamp(Schema.Entry entry, long value) {
            this.assertType(entry.getType(), Schema.Type.DATETIME);
            return this.append(entry, value);
        }

        public Record.Builder withInt(String name, int value) {
            return this.withInt(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.INT).withNullable(false).build(), value);
        }

        public Record.Builder withInt(Schema.Entry entry, int value) {
            this.assertType(entry.getType(), Schema.Type.INT);
            return this.append(entry, value);
        }

        public Record.Builder withLong(String name, long value) {
            return this.withLong(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.LONG).withNullable(false).build(), value);
        }

        public Record.Builder withLong(Schema.Entry entry, long value) {
            this.assertType(entry.getType(), Schema.Type.LONG);
            return this.append(entry, value);
        }

        public Record.Builder withFloat(String name, float value) {
            return this.withFloat(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.FLOAT).withNullable(false).build(), value);
        }

        public Record.Builder withFloat(Schema.Entry entry, float value) {
            this.assertType(entry.getType(), Schema.Type.FLOAT);
            return this.append(entry, Float.valueOf(value));
        }

        public Record.Builder withDouble(String name, double value) {
            return this.withDouble(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.DOUBLE).withNullable(false).build(), value);
        }

        public Record.Builder withDouble(Schema.Entry entry, double value) {
            this.assertType(entry.getType(), Schema.Type.DOUBLE);
            return this.append(entry, value);
        }

        public Record.Builder withBoolean(String name, boolean value) {
            return this.withBoolean(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.BOOLEAN).withNullable(false).build(), value);
        }

        public Record.Builder withBoolean(Schema.Entry entry, boolean value) {
            this.assertType(entry.getType(), Schema.Type.BOOLEAN);
            return this.append(entry, value);
        }

        public Record.Builder withRecord(Schema.Entry entry, Record value) {
            this.assertType(entry.getType(), Schema.Type.RECORD);
            if (entry.getElementSchema() == null) {
                throw new IllegalArgumentException("No schema for the nested record");
            }
            return this.append(entry, value);
        }

        public <T> Record.Builder withArray(Schema.Entry entry, Collection<T> values) {
            this.assertType(entry.getType(), Schema.Type.ARRAY);
            if (entry.getElementSchema() == null) {
                throw new IllegalArgumentException("No schema for the collection items");
            }
            return this.append(entry, values);
        }

        private void assertType(Schema.Type actual, Schema.Type expected) {
            if (actual != expected) {
                throw new IllegalArgumentException("Expected entry type: " + expected + ", got: " + actual);
            }
        }

        private <T> Record.Builder append(Schema.Entry entry, T value) {
            if (value != null) {
                this.values.put(entry.getName(), value);
            } else if (!entry.isNullable()) {
                throw new IllegalArgumentException(entry.getName() + " is not nullable but got a null value");
            }
            this.entries.add(entry);
            return this;
        }
    }
}

