/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.internationalization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.talend.sdk.component.api.internationalization.Language;
import org.talend.sdk.component.runtime.reflect.Defaults;

public class InternationalizationServiceFactory {
    public <T> T create(Class<T> api, ClassLoader loader) {
        if (!api.isInterface()) {
            throw new IllegalArgumentException(api + " is not an interface");
        }
        if (Stream.of(api.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).anyMatch(m -> m.getReturnType() != String.class)) {
            throw new IllegalArgumentException(api + " methods must return a String");
        }
        if (Stream.of(api.getMethods()).flatMap(m -> Stream.of(m.getParameters())).anyMatch(p -> p.isAnnotationPresent(Language.class) && p.getType() != Locale.class)) {
            throw new IllegalArgumentException("@Language can only be used with Locales");
        }
        String pck = api.getPackage().getName();
        return api.cast(Proxy.newProxyInstance(loader, new Class[]{api}, (InvocationHandler)new InternationalizedHandler(api.getName() + '.', (pck == null || pck.isEmpty() ? "" : pck + '.') + "Messages")));
    }

    private static class MethodMeta {
        private final Function<Object[], Locale> localeExtractor;
        private final Function<Object[], Object[]> parameterFactory;

        public MethodMeta(Function<Object[], Locale> localeExtractor, Function<Object[], Object[]> parameterFactory) {
            this.localeExtractor = localeExtractor;
            this.parameterFactory = parameterFactory;
        }
    }

    private static class InternationalizedHandler
    implements InvocationHandler {
        private static final Object[] NO_ARG = new Object[0];
        private final String prefix;
        private final String messages;
        private final ConcurrentMap<Locale, ResourceBundle> bundles = new ConcurrentHashMap<Locale, ResourceBundle>();
        private final transient ConcurrentMap<Method, MethodMeta> methods = new ConcurrentHashMap<Method, MethodMeta>();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                return Defaults.of(declaringClass).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
            }
            if (Object.class == method.getDeclaringClass()) {
                switch (method.getName()) {
                    case "equals": {
                        return args != null && args.length == 1 && method.getDeclaringClass().isInstance(args[0]) && Proxy.isProxyClass(args[0].getClass()) && this == Proxy.getInvocationHandler(args[0]);
                    }
                    case "hashCode": {
                        return this.hashCode();
                    }
                }
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            MethodMeta methodMeta = this.methods.computeIfAbsent(method, m -> new MethodMeta(this.createLocaleExtractor((Method)m), this.createParameterFactory((Method)m)));
            Locale locale = (Locale)methodMeta.localeExtractor.apply(args);
            String template = this.getTemplate(locale, method);
            return new MessageFormat(template, locale).format(methodMeta.parameterFactory.apply(args));
        }

        private Function<Object[], Object[]> createParameterFactory(Method method) {
            ArrayList<Integer> included = new ArrayList<Integer>();
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isAnnotationPresent(Language.class)) continue;
                included.add(i);
            }
            if (included.size() == method.getParameterCount()) {
                return Function.identity();
            }
            if (included.size() == 0) {
                return a -> NO_ARG;
            }
            return args -> {
                Object[] modified = new Object[included.size()];
                int current = 0;
                Iterator iterator = included.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    modified[current++] = args[i];
                }
                return modified;
            };
        }

        private Function<Object[], Locale> createLocaleExtractor(Method method) {
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Parameter p2 = parameters[i];
                if (!p2.isAnnotationPresent(Language.class)) continue;
                int idx = i;
                if (String.class == p2.getType()) {
                    return params -> new Locale(Optional.ofNullable(params[idx]).map(String::valueOf).orElse("en"));
                }
                return params -> (Locale)Locale.class.cast(params[idx]);
            }
            return p -> Locale.getDefault();
        }

        private String getTemplate(Locale locale, Method method) {
            String key;
            ResourceBundle bundle = this.bundles.computeIfAbsent(locale, l -> ResourceBundle.getBundle(this.messages, l, Thread.currentThread().getContextClassLoader()));
            return bundle.containsKey(key = this.prefix + method.getName()) ? bundle.getString(key) : method.getName();
        }

        public InternationalizedHandler(String prefix, String messages) {
            this.prefix = prefix;
            this.messages = messages;
        }
    }
}

