/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.form.model.uischema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.json.bind.annotation.JsonbTransient;

public class UiSchema {
    private String key;
    private String title;
    private String widget;
    private String itemWidget;
    private String type;
    private String description;
    private String tooltip;
    private Collection<UiSchema> items;
    private Map<String, Object> options;
    private Boolean autoFocus;
    private Boolean disabled;
    private Boolean readOnly;
    private Boolean required;
    private Boolean restricted;
    private String placeholder;
    private Collection<Trigger> triggers;
    private Collection<? extends TitleMapContent> titleMap;
    private Map<String, Collection<Object>> condition;
    @JsonbTransient
    private Consumer<UiSchema> onCopyCallback;
    @JsonbTransient
    private AtomicReference<Boolean> isStatic = new AtomicReference();

    public UiSchema copy(boolean frozenStructure) {
        if (frozenStructure && this.hasNoCallback()) {
            return this;
        }
        UiSchema copy = UiSchema.uiSchema().withKey(this.key).withTitle(this.title).withWidget(this.widget).withItemWidget(this.itemWidget).withType(this.type).withItems(this.items == null ? null : (Collection)this.items.stream().map(it -> it.copy(frozenStructure)).collect(Collectors.toList())).withOptions(this.options).withAutoFocus(this.autoFocus).withDisabled(this.disabled).withReadOnly(this.readOnly).withRequired(this.required).withRestricted(this.restricted).withPlaceholder(this.placeholder).withTriggers(this.triggers).withTitleMap(this.titleMap).withDescription(this.description).withTooltip(this.tooltip).withCondition(this.condition).build();
        if (this.onCopyCallback != null) {
            this.onCopyCallback.accept(copy);
        }
        return copy;
    }

    private boolean hasNoCallback() {
        Boolean hasNoCallback = this.isStatic.get();
        if (hasNoCallback == null) {
            hasNoCallback = this.onCopyCallback == null && (this.items == null || this.items.stream().noneMatch(UiSchema::hasNoCallback));
            this.isStatic.compareAndSet(null, hasNoCallback);
        }
        return hasNoCallback;
    }

    public static Builder uiSchema() {
        return new Builder();
    }

    public static Trigger.Builder trigger() {
        return new Trigger.Builder();
    }

    public static NameValue.Builder nameValue() {
        return new NameValue.Builder();
    }

    public static Parameter.Builder parameter() {
        return new Parameter.Builder();
    }

    public static ConditionBuilder condition() {
        return new ConditionBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWidget() {
        return this.widget;
    }

    public String getItemWidget() {
        return this.itemWidget;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Collection<UiSchema> getItems() {
        return this.items;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Boolean getAutoFocus() {
        return this.autoFocus;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    public Collection<? extends TitleMapContent> getTitleMap() {
        return this.titleMap;
    }

    public Map<String, Collection<Object>> getCondition() {
        return this.condition;
    }

    public Consumer<UiSchema> getOnCopyCallback() {
        return this.onCopyCallback;
    }

    public AtomicReference<Boolean> getIsStatic() {
        return this.isStatic;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWidget(String widget) {
        this.widget = widget;
    }

    public void setItemWidget(String itemWidget) {
        this.itemWidget = itemWidget;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setItems(Collection<UiSchema> items) {
        this.items = items;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setAutoFocus(Boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setTriggers(Collection<Trigger> triggers) {
        this.triggers = triggers;
    }

    public void setTitleMap(Collection<? extends TitleMapContent> titleMap) {
        this.titleMap = titleMap;
    }

    public void setCondition(Map<String, Collection<Object>> condition) {
        this.condition = condition;
    }

    public void setOnCopyCallback(Consumer<UiSchema> onCopyCallback) {
        this.onCopyCallback = onCopyCallback;
    }

    public void setIsStatic(AtomicReference<Boolean> isStatic) {
        this.isStatic = isStatic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiSchema)) {
            return false;
        }
        UiSchema other = (UiSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$autoFocus = this.getAutoFocus();
        Boolean other$autoFocus = other.getAutoFocus();
        if (this$autoFocus == null ? other$autoFocus != null : !((Object)this$autoFocus).equals(other$autoFocus)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        Boolean this$required = this.getRequired();
        Boolean other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        Boolean this$restricted = this.getRestricted();
        Boolean other$restricted = other.getRestricted();
        if (this$restricted == null ? other$restricted != null : !((Object)this$restricted).equals(other$restricted)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$widget = this.getWidget();
        String other$widget = other.getWidget();
        if (this$widget == null ? other$widget != null : !this$widget.equals(other$widget)) {
            return false;
        }
        String this$itemWidget = this.getItemWidget();
        String other$itemWidget = other.getItemWidget();
        if (this$itemWidget == null ? other$itemWidget != null : !this$itemWidget.equals(other$itemWidget)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$tooltip = this.getTooltip();
        String other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        Collection<UiSchema> this$items = this.getItems();
        Collection<UiSchema> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Map<String, Object> this$options = this.getOptions();
        Map<String, Object> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$placeholder = this.getPlaceholder();
        String other$placeholder = other.getPlaceholder();
        if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
            return false;
        }
        Collection<Trigger> this$triggers = this.getTriggers();
        Collection<Trigger> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        Collection<? extends TitleMapContent> this$titleMap = this.getTitleMap();
        Collection<? extends TitleMapContent> other$titleMap = other.getTitleMap();
        if (this$titleMap == null ? other$titleMap != null : !((Object)this$titleMap).equals(other$titleMap)) {
            return false;
        }
        Map<String, Collection<Object>> this$condition = this.getCondition();
        Map<String, Collection<Object>> other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        Consumer<UiSchema> this$onCopyCallback = this.getOnCopyCallback();
        Consumer<UiSchema> other$onCopyCallback = other.getOnCopyCallback();
        if (this$onCopyCallback == null ? other$onCopyCallback != null : !this$onCopyCallback.equals(other$onCopyCallback)) {
            return false;
        }
        AtomicReference<Boolean> this$isStatic = this.getIsStatic();
        AtomicReference<Boolean> other$isStatic = other.getIsStatic();
        return !(this$isStatic == null ? other$isStatic != null : !this$isStatic.equals(other$isStatic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoFocus = this.getAutoFocus();
        result = result * 59 + ($autoFocus == null ? 43 : ((Object)$autoFocus).hashCode());
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        Boolean $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        Boolean $restricted = this.getRestricted();
        result = result * 59 + ($restricted == null ? 43 : ((Object)$restricted).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $widget = this.getWidget();
        result = result * 59 + ($widget == null ? 43 : $widget.hashCode());
        String $itemWidget = this.getItemWidget();
        result = result * 59 + ($itemWidget == null ? 43 : $itemWidget.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        Collection<UiSchema> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Map<String, Object> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $placeholder = this.getPlaceholder();
        result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
        Collection<Trigger> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        Collection<? extends TitleMapContent> $titleMap = this.getTitleMap();
        result = result * 59 + ($titleMap == null ? 43 : ((Object)$titleMap).hashCode());
        Map<String, Collection<Object>> $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        Consumer<UiSchema> $onCopyCallback = this.getOnCopyCallback();
        result = result * 59 + ($onCopyCallback == null ? 43 : $onCopyCallback.hashCode());
        AtomicReference<Boolean> $isStatic = this.getIsStatic();
        result = result * 59 + ($isStatic == null ? 43 : $isStatic.hashCode());
        return result;
    }

    public String toString() {
        return "UiSchema(key=" + this.getKey() + ", title=" + this.getTitle() + ", widget=" + this.getWidget() + ", itemWidget=" + this.getItemWidget() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", tooltip=" + this.getTooltip() + ", items=" + this.getItems() + ", options=" + this.getOptions() + ", autoFocus=" + this.getAutoFocus() + ", disabled=" + this.getDisabled() + ", readOnly=" + this.getReadOnly() + ", required=" + this.getRequired() + ", restricted=" + this.getRestricted() + ", placeholder=" + this.getPlaceholder() + ", triggers=" + this.getTriggers() + ", titleMap=" + this.getTitleMap() + ", condition=" + this.getCondition() + ", onCopyCallback=" + this.getOnCopyCallback() + ", isStatic=" + this.getIsStatic() + ")";
    }

    public static final class Builder {
        private String key;
        private String title;
        private String widget;
        private String itemWidget;
        private String type;
        private String description;
        private String tooltip;
        private Collection<UiSchema> items;
        private Map<String, Object> options;
        private Boolean autoFocus;
        private Boolean disabled;
        private Boolean readOnly;
        private Boolean required;
        private Boolean restricted;
        private String placeholder;
        private Collection<Trigger> triggers;
        private Collection<? extends TitleMapContent> titleMap;
        private Map<String, Collection<Object>> condition;
        private Consumer<UiSchema> copyCallback;

        public Builder withCondition(Map<String, Collection<Object>> condition) {
            if (this.condition != null) {
                throw new IllegalStateException("conditions already set");
            }
            this.condition = condition;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder withWidget(String widget) {
            this.widget = widget;
            return this;
        }

        public Builder withItemWidget(String widget) {
            this.itemWidget = widget;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withItems(Collection<UiSchema> items) {
            if (items == null) {
                return this;
            }
            if (this.items == null) {
                this.items = new ArrayList<UiSchema>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder withItems(UiSchema ... items) {
            if (items == null) {
                return this;
            }
            return this.withItems(Arrays.asList(items));
        }

        public Builder withOptions(String name, String value) {
            if (this.options == null) {
                return this;
            }
            if (this.options == null) {
                this.options = new LinkedHashMap<String, Object>();
            }
            this.options.put(name, value);
            return this;
        }

        public Builder withOptions(Map<String, ?> options) {
            if (options == null) {
                return this;
            }
            if (this.options == null) {
                this.options = new LinkedHashMap<String, Object>();
            }
            this.options.putAll(options);
            return this;
        }

        public Builder withAutoFocus(Boolean autoFocus) {
            this.autoFocus = autoFocus;
            return this;
        }

        public Builder withDisabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder withRequired(Boolean required) {
            this.required = required;
            return this;
        }

        public Builder withRestricted(Boolean restricted) {
            this.restricted = restricted;
            return this;
        }

        public Builder withPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder withTriggers(Trigger ... triggers) {
            if (triggers == null) {
                return this;
            }
            return this.withTriggers(Arrays.asList(triggers));
        }

        public Builder withTriggers(Collection<Trigger> triggers) {
            if (triggers == null) {
                return this;
            }
            if (this.triggers == null) {
                this.triggers = new ArrayList<Trigger>();
            }
            this.triggers.addAll(triggers);
            return this;
        }

        public Builder withTitleMap(NameValue ... titleMap) {
            if (titleMap == null) {
                return this;
            }
            return this.withTitleMap(Arrays.asList(titleMap));
        }

        public Builder withTitleMap(Collection<? extends TitleMapContent> titleMap) {
            if (titleMap == null) {
                return this;
            }
            this.titleMap = new ArrayList<TitleMapContent>(titleMap);
            return this;
        }

        public Builder withCopyCallback(Consumer<UiSchema> copyCallback) {
            this.copyCallback = copyCallback;
            return this;
        }

        public UiSchema build() {
            UiSchema uiSchema = new UiSchema();
            uiSchema.setKey(this.key);
            uiSchema.setTitle(this.title);
            uiSchema.setWidget(this.widget);
            uiSchema.setType(this.type);
            uiSchema.setItems(this.items);
            uiSchema.setOptions(this.options);
            uiSchema.setAutoFocus(this.autoFocus);
            uiSchema.setDisabled(this.disabled);
            uiSchema.setReadOnly(this.readOnly);
            uiSchema.setRequired(this.required);
            uiSchema.setRestricted(this.restricted);
            uiSchema.setPlaceholder(this.placeholder);
            uiSchema.setTriggers(this.triggers);
            uiSchema.setTitleMap(this.titleMap);
            uiSchema.setDescription(this.description);
            uiSchema.setTooltip(this.tooltip);
            uiSchema.setItemWidget(this.itemWidget);
            uiSchema.setCondition(this.condition);
            uiSchema.setOnCopyCallback(this.copyCallback);
            return uiSchema;
        }
    }

    public static class Trigger {
        private String action;
        private String family;
        private String type;
        private String onEvent;
        private Boolean remote;
        private Collection<Option> options;
        private Collection<Parameter> parameters;

        public String getAction() {
            return this.action;
        }

        public String getFamily() {
            return this.family;
        }

        public String getType() {
            return this.type;
        }

        public String getOnEvent() {
            return this.onEvent;
        }

        public Boolean getRemote() {
            return this.remote;
        }

        public Collection<Option> getOptions() {
            return this.options;
        }

        public Collection<Parameter> getParameters() {
            return this.parameters;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setOnEvent(String onEvent) {
            this.onEvent = onEvent;
        }

        public void setRemote(Boolean remote) {
            this.remote = remote;
        }

        public void setOptions(Collection<Option> options) {
            this.options = options;
        }

        public void setParameters(Collection<Parameter> parameters) {
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Trigger)) {
                return false;
            }
            Trigger other = (Trigger)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$remote = this.getRemote();
            Boolean other$remote = other.getRemote();
            if (this$remote == null ? other$remote != null : !((Object)this$remote).equals(other$remote)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$family = this.getFamily();
            String other$family = other.getFamily();
            if (this$family == null ? other$family != null : !this$family.equals(other$family)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$onEvent = this.getOnEvent();
            String other$onEvent = other.getOnEvent();
            if (this$onEvent == null ? other$onEvent != null : !this$onEvent.equals(other$onEvent)) {
                return false;
            }
            Collection<Option> this$options = this.getOptions();
            Collection<Option> other$options = other.getOptions();
            if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
                return false;
            }
            Collection<Parameter> this$parameters = this.getParameters();
            Collection<Parameter> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Trigger;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $remote = this.getRemote();
            result = result * 59 + ($remote == null ? 43 : ((Object)$remote).hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $family = this.getFamily();
            result = result * 59 + ($family == null ? 43 : $family.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $onEvent = this.getOnEvent();
            result = result * 59 + ($onEvent == null ? 43 : $onEvent.hashCode());
            Collection<Option> $options = this.getOptions();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            Collection<Parameter> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        public String toString() {
            return "UiSchema.Trigger(action=" + this.getAction() + ", family=" + this.getFamily() + ", type=" + this.getType() + ", onEvent=" + this.getOnEvent() + ", remote=" + this.getRemote() + ", options=" + this.getOptions() + ", parameters=" + this.getParameters() + ")";
        }

        public static final class Builder {
            private String action;
            private String family;
            private String type;
            private String onEvent;
            private Boolean remote;
            private Collection<Option> options;
            private Collection<Parameter> parameters;

            public Builder withRemote(boolean remote) {
                this.remote = remote;
                return this;
            }

            public Builder withOnEvent(String onEvent) {
                this.onEvent = onEvent;
                return this;
            }

            public Builder withAction(String action) {
                this.action = action;
                return this;
            }

            public Builder withFamily(String family) {
                this.family = family;
                return this;
            }

            public Builder withType(String type) {
                this.type = type;
                return this;
            }

            public Builder withOption(Option value) {
                if (this.options == null) {
                    this.options = new ArrayList<Option>();
                }
                this.options.add(value);
                return this;
            }

            public Builder withOptions(Collection<Option> options) {
                if (this.options == null) {
                    this.options = new ArrayList<Option>();
                }
                this.options.addAll(options);
                return this;
            }

            public Builder withParameter(String key, String path) {
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Parameter>();
                }
                Parameter parameter = UiSchema.parameter().withKey(key).withPath(path).build();
                this.parameters.add(parameter);
                return this;
            }

            public Builder withParameters(Collection<Parameter> parameters) {
                if (this.parameters == null) {
                    this.parameters = new ArrayList<Parameter>();
                }
                this.parameters.addAll(parameters);
                return this;
            }

            public Trigger build() {
                Trigger parameter = new Trigger();
                parameter.setAction(this.action);
                parameter.setFamily(this.family);
                parameter.setType(this.type);
                parameter.setParameters(this.parameters);
                parameter.setOptions(this.options);
                parameter.setOnEvent(this.onEvent);
                parameter.setRemote(this.remote == null || this.remote != false);
                return parameter;
            }
        }
    }

    public static class NameValue
    implements TitleMapContent {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameValue)) {
                return false;
            }
            NameValue other = (NameValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NameValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "UiSchema.NameValue(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        public static final class Builder {
            private String name;
            private String value;

            public Builder withName(String name) {
                this.name = name;
                return this;
            }

            public Builder withValue(String value) {
                this.value = value;
                return this;
            }

            public NameValue build() {
                NameValue nameValue = new NameValue();
                nameValue.setName(this.name);
                nameValue.setValue(this.value);
                return nameValue;
            }
        }
    }

    public static class Parameter {
        private String key;
        private String path;

        public String getKey() {
            return this.key;
        }

        public String getPath() {
            return this.path;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "UiSchema.Parameter(key=" + this.getKey() + ", path=" + this.getPath() + ")";
        }

        public static final class Builder {
            private String key;
            private String path;

            public Builder withKey(String key) {
                this.key = key;
                return this;
            }

            public Builder withPath(String path) {
                this.path = path;
                return this;
            }

            public Parameter build() {
                Parameter parameter = new Parameter();
                parameter.setKey(this.key);
                parameter.setPath(this.path);
                return parameter;
            }
        }
    }

    public static final class ConditionBuilder {
        private final Map<String, Collection<Object>> values = new LinkedHashMap<String, Collection<Object>>();

        public ConditionValuesBuilder withOperator(String operator) {
            return new ConditionValuesBuilder(this, operator);
        }

        public Map<String, Collection<Object>> build() {
            if (this.values.isEmpty()) {
                throw new IllegalArgumentException("Empty condition, did you think about calling up()?");
            }
            return Collections.unmodifiableMap(this.values);
        }
    }

    public static class Option {
        private String path;
        private String type;

        public String getPath() {
            return this.path;
        }

        public String getType() {
            return this.type;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Option)) {
                return false;
            }
            Option other = (Option)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Option;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "UiSchema.Option(path=" + this.getPath() + ", type=" + this.getType() + ")";
        }

        public static class Builder {
            private String path;
            private String type;

            public Builder withPath(String path) {
                this.path = path;
                return this;
            }

            public Builder withType(String type) {
                this.type = type;
                return this;
            }

            public Option build() {
                Option option = new Option();
                option.setPath(this.path);
                option.setType(this.type);
                return option;
            }
        }
    }

    public static class TitledNameValue
    implements TitleMapContent {
        private String title;
        private Collection<NameValue> suggestions;

        public String getTitle() {
            return this.title;
        }

        public Collection<NameValue> getSuggestions() {
            return this.suggestions;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setSuggestions(Collection<NameValue> suggestions) {
            this.suggestions = suggestions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TitledNameValue)) {
                return false;
            }
            TitledNameValue other = (TitledNameValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Collection<NameValue> this$suggestions = this.getSuggestions();
            Collection<NameValue> other$suggestions = other.getSuggestions();
            return !(this$suggestions == null ? other$suggestions != null : !((Object)this$suggestions).equals(other$suggestions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TitledNameValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Collection<NameValue> $suggestions = this.getSuggestions();
            result = result * 59 + ($suggestions == null ? 43 : ((Object)$suggestions).hashCode());
            return result;
        }

        public String toString() {
            return "UiSchema.TitledNameValue(title=" + this.getTitle() + ", suggestions=" + this.getSuggestions() + ")";
        }

        public static final class Builder {
            private String title;
            private Collection<NameValue> suggestions;

            public Builder withTitle(String title) {
                this.title = title;
                return this;
            }

            public Builder withSuggestions(Collection<NameValue> nameValue) {
                this.suggestions = nameValue;
                return this;
            }

            public TitledNameValue build() {
                TitledNameValue titledNameValue = new TitledNameValue();
                titledNameValue.setTitle(this.title);
                titledNameValue.setSuggestions(this.suggestions);
                return titledNameValue;
            }
        }
    }

    public static interface TitleMapContent {
    }

    public static final class ConditionValuesBuilder {
        private final ConditionBuilder builder;
        private final String operator;
        private final Collection<Object> values = new ArrayList<Object>(2);

        public <T> ConditionValuesBuilder withVar(String var) {
            this.values.add(Collections.singletonMap("var", var));
            return this;
        }

        public <T> ConditionValuesBuilder withValues(Collection<T> values) {
            this.values.addAll(values);
            return this;
        }

        public <T> ConditionValuesBuilder withValue(T value) {
            this.values.add(value);
            return this;
        }

        public ConditionBuilder up() {
            if (this.values.isEmpty()) {
                throw new IllegalArgumentException("No value set, call withValue()");
            }
            this.builder.values.put(this.operator, this.values);
            return this.builder;
        }

        public Map<String, Collection<Object>> build() {
            return this.up().build();
        }

        public ConditionValuesBuilder(ConditionBuilder builder, String operator) {
            this.builder = builder;
            this.operator = operator;
        }
    }
}

