/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.form.model.jsonschema;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;
import org.talend.sdk.component.form.model.jsonschema.PojoJsonSchemaBuilder;

public class JsonSchema {
    public static final String DEFAULT_TYPE = "object";
    private String id;
    private String title;
    private String description;
    @JsonbProperty(value="$schema")
    private String schema;
    @JsonbProperty(value="$ref")
    private String ref;
    private String type = "object";
    private Integer minItems;
    private Integer maxItems;
    private Integer minLength;
    private Integer maxLength;
    private Double minimum;
    private Double maximum;
    private Boolean uniqueItems;
    private String pattern;
    @JsonbProperty(value="default")
    private Object defaultValue;
    private Collection<String> required;
    private Map<String, JsonSchema> properties;
    private JsonSchema items;
    @JsonbProperty(value="enum")
    private Collection<String> enumValues;

    public static Builder jsonSchema() {
        return new Builder();
    }

    public static Builder jsonSchemaFrom(Class<?> pojo) {
        return new PojoJsonSchemaBuilder().create(pojo);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRef() {
        return this.ref;
    }

    public String getType() {
        return this.type;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Collection<String> getRequired() {
        return this.required;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    public JsonSchema getItems() {
        return this.items;
    }

    public Collection<String> getEnumValues() {
        return this.enumValues;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(Collection<String> required) {
        this.required = required;
    }

    public void setProperties(Map<String, JsonSchema> properties) {
        this.properties = properties;
    }

    public void setItems(JsonSchema items) {
        this.items = items;
    }

    public void setEnumValues(Collection<String> enumValues) {
        this.enumValues = enumValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonSchema)) {
            return false;
        }
        JsonSchema other = (JsonSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minItems = this.getMinItems();
        Integer other$minItems = other.getMinItems();
        if (this$minItems == null ? other$minItems != null : !((Object)this$minItems).equals(other$minItems)) {
            return false;
        }
        Integer this$maxItems = this.getMaxItems();
        Integer other$maxItems = other.getMaxItems();
        if (this$maxItems == null ? other$maxItems != null : !((Object)this$maxItems).equals(other$maxItems)) {
            return false;
        }
        Integer this$minLength = this.getMinLength();
        Integer other$minLength = other.getMinLength();
        if (this$minLength == null ? other$minLength != null : !((Object)this$minLength).equals(other$minLength)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Double this$minimum = this.getMinimum();
        Double other$minimum = other.getMinimum();
        if (this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum)) {
            return false;
        }
        Double this$maximum = this.getMaximum();
        Double other$maximum = other.getMaximum();
        if (this$maximum == null ? other$maximum != null : !((Object)this$maximum).equals(other$maximum)) {
            return false;
        }
        Boolean this$uniqueItems = this.getUniqueItems();
        Boolean other$uniqueItems = other.getUniqueItems();
        if (this$uniqueItems == null ? other$uniqueItems != null : !((Object)this$uniqueItems).equals(other$uniqueItems)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Collection<String> this$required = this.getRequired();
        Collection<String> other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        Map<String, JsonSchema> this$properties = this.getProperties();
        Map<String, JsonSchema> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        JsonSchema this$items = this.getItems();
        JsonSchema other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Collection<String> this$enumValues = this.getEnumValues();
        Collection<String> other$enumValues = other.getEnumValues();
        return !(this$enumValues == null ? other$enumValues != null : !((Object)this$enumValues).equals(other$enumValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minItems = this.getMinItems();
        result = result * 59 + ($minItems == null ? 43 : ((Object)$minItems).hashCode());
        Integer $maxItems = this.getMaxItems();
        result = result * 59 + ($maxItems == null ? 43 : ((Object)$maxItems).hashCode());
        Integer $minLength = this.getMinLength();
        result = result * 59 + ($minLength == null ? 43 : ((Object)$minLength).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Double $minimum = this.getMinimum();
        result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
        Double $maximum = this.getMaximum();
        result = result * 59 + ($maximum == null ? 43 : ((Object)$maximum).hashCode());
        Boolean $uniqueItems = this.getUniqueItems();
        result = result * 59 + ($uniqueItems == null ? 43 : ((Object)$uniqueItems).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Collection<String> $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        Map<String, JsonSchema> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        JsonSchema $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Collection<String> $enumValues = this.getEnumValues();
        result = result * 59 + ($enumValues == null ? 43 : ((Object)$enumValues).hashCode());
        return result;
    }

    public String toString() {
        return "JsonSchema(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", schema=" + this.getSchema() + ", ref=" + this.getRef() + ", type=" + this.getType() + ", minItems=" + this.getMinItems() + ", maxItems=" + this.getMaxItems() + ", minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ", minimum=" + this.getMinimum() + ", maximum=" + this.getMaximum() + ", uniqueItems=" + this.getUniqueItems() + ", pattern=" + this.getPattern() + ", defaultValue=" + this.getDefaultValue() + ", required=" + this.getRequired() + ", properties=" + this.getProperties() + ", items=" + this.getItems() + ", enumValues=" + this.getEnumValues() + ")";
    }

    public static final class Builder {
        private String id;
        private String title;
        private String description;
        private String schema;
        private String ref;
        private String type = "object";
        private Integer minItems;
        private Integer maxItems;
        private Integer minLength;
        private Integer maxLength;
        private Double minimum;
        private Double maximum;
        private Boolean uniqueItems;
        private String pattern;
        private Object defaultValue;
        private Collection<String> required;
        private Map<String, JsonSchema> properties;
        private Collection<String> enumValues;
        private JsonSchema items;

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withItems(JsonSchema schemas) {
            this.items = schemas;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder withRef(String ref) {
            this.ref = ref;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withMinItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder withMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder withMinLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder withMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder withMinimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder withMaximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder withUniqueItems(Boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withRequired(Collection<String> required) {
            this.required = required;
            return this;
        }

        public Builder withRequired(String ... required) {
            this.required = Arrays.asList(required);
            return this;
        }

        public Builder withProperty(String name, JsonSchema schema) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, JsonSchema>();
            }
            this.properties.put(name, schema);
            return this;
        }

        public Builder withProperties(Map<String, JsonSchema> properties) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, JsonSchema>();
            }
            this.properties.putAll(properties);
            return this;
        }

        public Builder withEnumValues(Collection<String> enumValues) {
            this.enumValues = enumValues;
            return this;
        }

        public Builder withEnumValues(String ... enumValues) {
            this.enumValues = Arrays.asList(enumValues);
            return this;
        }

        public JsonSchema build() {
            JsonSchema jsonSchema = new JsonSchema();
            jsonSchema.setId(this.id);
            jsonSchema.setTitle(this.title);
            jsonSchema.setDescription(this.description);
            jsonSchema.setSchema(this.schema);
            jsonSchema.setRef(this.ref);
            jsonSchema.setType(this.type);
            jsonSchema.setMinItems(this.minItems);
            jsonSchema.setMaxItems(this.maxItems);
            jsonSchema.setMinLength(this.minLength);
            jsonSchema.setMaxLength(this.maxLength);
            jsonSchema.setMinimum(this.minimum);
            jsonSchema.setMaximum(this.maximum);
            jsonSchema.setUniqueItems(this.uniqueItems);
            jsonSchema.setPattern(this.pattern);
            jsonSchema.setDefaultValue(this.defaultValue);
            jsonSchema.setRequired(this.required);
            jsonSchema.setProperties(this.properties);
            jsonSchema.setEnumValues(this.enumValues);
            jsonSchema.setItems(this.items);
            return jsonSchema;
        }
    }
}

