/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.form.model.jsonschema;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.talend.sdk.component.form.model.jsonschema.JsonSchema;
import org.talend.sdk.component.form.model.jsonschema.JsonSchemaIgnore;
import org.talend.sdk.component.form.model.jsonschema.JsonSchemaProperty;

class PojoJsonSchemaBuilder {
    private final Map<Class<?>, JsonSchema> schemas = new HashMap();

    public JsonSchema.Builder create(Class<?> pojo) {
        JsonSchema.Builder builder = JsonSchema.jsonSchema().withTitle(pojo.getSimpleName()).withType("object");
        HashSet excludes = new HashSet();
        for (Class<?> current = pojo; current != Object.class && current != null; current = current.getSuperclass()) {
            Stream.of(current.getDeclaredFields()).filter(f -> !f.getName().equals("$jacocoData")).filter(f -> {
                int modifiers = f.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
            }).filter(f -> !f.isAnnotationPresent(JsonSchemaIgnore.class)).filter(f -> excludes.add(f.getName())).sorted(Comparator.comparing(Field::getName)).forEach(field -> {
                String name = Optional.ofNullable(field.getAnnotation(JsonSchemaProperty.class)).map(JsonSchemaProperty::value).orElseGet(field::getName);
                builder.withProperty(name, this.buildSchema((Field)field));
            });
        }
        return builder;
    }

    private JsonSchema buildSchema(Field field) {
        Type genericType = field.getGenericType();
        if (Class.class.isInstance(genericType) && CharSequence.class.isAssignableFrom((Class)Class.class.cast(genericType)) || genericType == Character.TYPE || genericType == Character.class) {
            return this.schemas.computeIfAbsent((Class<?>)Class.class.cast(genericType), (Function<Class<?>, JsonSchema>)((Function<Class, JsonSchema>)k -> JsonSchema.jsonSchema().withType("string").build()));
        }
        if (genericType == Long.TYPE || genericType == Long.class || genericType == Integer.TYPE || genericType == Integer.class || genericType == Byte.TYPE || genericType == Byte.class || genericType == Short.TYPE || genericType == Short.class || genericType == Double.TYPE || genericType == Double.class || genericType == Float.TYPE || genericType == Float.class || genericType == BigDecimal.class || genericType == BigInteger.class) {
            return this.schemas.computeIfAbsent((Class<?>)Class.class.cast(genericType), (Function<Class<?>, JsonSchema>)((Function<Class, JsonSchema>)k -> JsonSchema.jsonSchema().withType("number").build()));
        }
        if (genericType == Boolean.TYPE || genericType == Boolean.class) {
            return this.schemas.computeIfAbsent((Class<?>)Class.class.cast(genericType), (Function<Class<?>, JsonSchema>)((Function<Class, JsonSchema>)k -> JsonSchema.jsonSchema().withType("boolean").build()));
        }
        if (Class.class.isInstance(genericType)) {
            Class clazz = (Class)Class.class.cast(genericType);
            return Optional.ofNullable(this.schemas.get(clazz)).orElseGet(() -> {
                JsonSchema jsonSchema = this.create(clazz).build();
                this.schemas.put(clazz, jsonSchema);
                return jsonSchema;
            });
        }
        if (ParameterizedType.class.isInstance(genericType)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(genericType);
            Type rawType = pt.getRawType();
            if (!Class.class.isInstance(rawType)) {
                throw new IllegalArgumentException("Unsupported raw type: " + pt + ", this must be a Class");
            }
            Class rawClazz = (Class)Class.class.cast(rawType);
            if (Collection.class.isAssignableFrom(rawClazz) && pt.getActualTypeArguments().length == 1) {
                Type itemType = pt.getActualTypeArguments()[0];
                if (!Class.class.isInstance(itemType)) {
                    throw new IllegalArgumentException("Unsupported generic type for item type: " + pt + ", this must be a Class");
                }
                Class itemClass = (Class)Class.class.cast(itemType);
                JsonSchema nested = Optional.ofNullable(this.schemas.get(itemType)).orElseGet(() -> {
                    JsonSchema jsonSchema = this.create(itemClass).build();
                    this.schemas.put(itemClass, jsonSchema);
                    return jsonSchema;
                });
                return JsonSchema.jsonSchema().withType("array").withItems(nested).build();
            }
            if (Map.class.isAssignableFrom(rawClazz) && pt.getActualTypeArguments().length == 2) {
                Type keyType = pt.getActualTypeArguments()[0];
                Type valueType = pt.getActualTypeArguments()[1];
                if (!Class.class.isInstance(keyType) || !Class.class.isInstance(valueType)) {
                    throw new IllegalArgumentException("Unsupported generic type for key or value type: " + pt + ", these must be Class instances");
                }
                return JsonSchema.jsonSchema().withType("object").build();
            }
            throw new IllegalArgumentException("Unsupported raw type: " + pt + ", this must be a Collection or Map");
        }
        throw new IllegalArgumentException("Unsupported generic type: " + genericType);
    }

    public Map<Class<?>, JsonSchema> getSchemas() {
        return this.schemas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PojoJsonSchemaBuilder)) {
            return false;
        }
        PojoJsonSchemaBuilder other = (PojoJsonSchemaBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Class<?>, JsonSchema> this$schemas = this.getSchemas();
        Map<Class<?>, JsonSchema> other$schemas = other.getSchemas();
        return !(this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PojoJsonSchemaBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<?>, JsonSchema> $schemas = this.getSchemas();
        result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
        return result;
    }

    public String toString() {
        return "PojoJsonSchemaBuilder(schemas=" + this.getSchemas() + ")";
    }
}

