/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.common.objects.ConnectorMessages;

public class ConnectorMessagesImpl
implements ConnectorMessages {
    private Map<Locale, Map<String, String>> _catalogs = new HashMap<Locale, Map<String, String>>();

    public String format(String key, String dflt, Object ... args) {
        String message;
        if (key == null) {
            return dflt;
        }
        Locale locale = CurrentLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (dflt == null) {
            dflt = key;
        }
        if ((message = this.getCatalogMessage(locale, key)) == null) {
            message = this.getCatalogMessage(new Locale(locale.getLanguage(), locale.getCountry()), key);
        }
        if (message == null) {
            message = this.getCatalogMessage(new Locale(locale.getLanguage()), key);
        }
        if (message == null) {
            message = this.getCatalogMessage(new Locale(""), key);
        }
        if (message == null) {
            message = this.getFrameworkMessage(locale, key);
        }
        if (message == null) {
            return dflt;
        }
        MessageFormat formater = new MessageFormat(message, locale);
        return formater.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    private String getCatalogMessage(Locale locale, String key) {
        Map<String, String> catalog = this._catalogs.get(locale);
        return catalog != null ? catalog.get(key) : null;
    }

    private String getFrameworkMessage(Locale locale, String key) {
        String baseName = ConnectorMessagesImpl.class.getPackage().getName() + ".Messages";
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public Map<Locale, Map<String, String>> getCatalogs() {
        return this._catalogs;
    }

    public void setCatalogs(Map<Locale, Map<String, String>> catalogs) {
        if (catalogs == null) {
            catalogs = new HashMap<Locale, Map<String, String>>();
        }
        this._catalogs = catalogs;
    }
}

