/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.InputStream;
import org.synchronoss.cloud.nio.multipart.BlockingIOAdapter;
import org.synchronoss.cloud.nio.multipart.DefaultPartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.multipart.MultipartContext;
import org.synchronoss.cloud.nio.multipart.NioMultipartParser;
import org.synchronoss.cloud.nio.multipart.NioMultipartParserListener;
import org.synchronoss.cloud.nio.multipart.PartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.multipart.util.collect.CloseableIterator;
import org.synchronoss.cloud.nio.stream.storage.DeferredFileStreamStorageFactory;

public class Multipart {
    private Multipart() {
    }

    public static Builder multipart(MultipartContext context) {
        return new Builder(context);
    }

    public static class Builder {
        private static final PartBodyStreamStorageFactory defaultPartBodyStreamStorageFactory = new DefaultPartBodyStreamStorageFactory(DeferredFileStreamStorageFactory.DEFAULT_ROOT_FOLDER, 10240);
        private int bufferSize = 16384;
        private int headersSizeLimit = 16384;
        private int nestedMultipartsAllowed = 1;
        private String rootFolder = DeferredFileStreamStorageFactory.DEFAULT_ROOT_FOLDER;
        private int bodySizeThreshold = 10240;
        private PartBodyStreamStorageFactory partBodyStreamStorageFactory;
        private MultipartContext context;

        private Builder(MultipartContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null");
            }
            this.context = context;
        }

        public Builder withBufferSize(int bufferSize) {
            if (bufferSize < 0) {
                throw new IllegalArgumentException("Buffer size cannot be lower than zero");
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withHeadersSizeLimit(int headersSizeLimit) {
            if (this.bufferSize < 0) {
                throw new IllegalArgumentException("Headers size limit cannot be lower than zero");
            }
            this.headersSizeLimit = headersSizeLimit;
            return this;
        }

        public Builder saveTemporaryFilesTo(String rootFolder) {
            this.rootFolder = rootFolder;
            return this;
        }

        public Builder withMaxMemoryUsagePerBodyPart(int bodySizeThreshold) {
            this.bodySizeThreshold = bodySizeThreshold;
            return this;
        }

        public Builder usePartBodyStreamStorageFactory(PartBodyStreamStorageFactory partBodyStreamStorageFactory) {
            this.partBodyStreamStorageFactory = partBodyStreamStorageFactory;
            return this;
        }

        public Builder limitNestingPartsTo(int nestedMultipartsAllowed) {
            if (nestedMultipartsAllowed < 1) {
                throw new IllegalArgumentException("Nested multiparts limit must be grater than 0");
            }
            this.nestedMultipartsAllowed = nestedMultipartsAllowed;
            return this;
        }

        private PartBodyStreamStorageFactory partStreamsFactory() {
            if (this.partBodyStreamStorageFactory == null) {
                if (DeferredFileStreamStorageFactory.DEFAULT_ROOT_FOLDER.equals(this.rootFolder) && 10240 == this.bodySizeThreshold) {
                    return defaultPartBodyStreamStorageFactory;
                }
                return new DefaultPartBodyStreamStorageFactory(this.rootFolder, this.bodySizeThreshold);
            }
            return this.partBodyStreamStorageFactory;
        }

        public NioMultipartParser forNIO(NioMultipartParserListener listener) {
            return new NioMultipartParser(this.context, listener, this.partStreamsFactory(), this.bufferSize, this.headersSizeLimit, this.nestedMultipartsAllowed);
        }

        public CloseableIterator<BlockingIOAdapter.ParserToken> forBlockingIO(InputStream inputStream) {
            return BlockingIOAdapter.parse(inputStream, this.context, this.partStreamsFactory(), this.bufferSize, this.headersSizeLimit, this.nestedMultipartsAllowed);
        }
    }
}

