/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.lang.Strings;
import org.switchyard.runtime.RuntimeMessages;
import org.switchyard.serial.graph.AccessType;
import org.switchyard.serial.graph.BaseFactory;
import org.switchyard.serial.graph.Strategy;
import org.switchyard.serial.graph.node.Node;

@Strategy(access=AccessType.FIELD, factory=ContextPropertyFactory.class)
public class ContextProperty
implements Property {
    private String _name;
    private Scope _scope;
    private Object _value;
    private Set<String> _labels = Collections.synchronizedSet(new TreeSet());

    private ContextProperty() {
    }

    ContextProperty(String name, Scope scope, Object value) {
        if (name == null || scope == null) {
            throw RuntimeMessages.MESSAGES.propertyNameAndScopeCannotBeNull();
        }
        this._name = name;
        this._scope = scope;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public Scope getScope() {
        return this._scope;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this._labels);
    }

    public Property addLabels(String ... labels) {
        for (String label : labels) {
            if ((label = this.normalizeLabel(label)) == null) continue;
            this._labels.add(label);
        }
        return this;
    }

    public Property addLabels(Set<String> labels) {
        for (String label : labels) {
            if ((label = this.normalizeLabel(label)) == null) continue;
            this._labels.add(label);
        }
        return this;
    }

    public Property removeLabels(String ... labels) {
        for (String label : labels) {
            if ((label = this.normalizeLabel(label)) == null) continue;
            this._labels.remove(label);
        }
        return this;
    }

    public boolean hasLabel(String label) {
        return (label = this.normalizeLabel(label)) != null && this._labels.contains(label);
    }

    private String normalizeLabel(String label) {
        if ((label = Strings.trimToNull((String)label)) != null) {
            label = label.toLowerCase();
        }
        return label;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContextProperty)) {
            return false;
        }
        ContextProperty comp = (ContextProperty)obj;
        return this._name.equals(comp.getName()) && this._scope.equals((Object)comp.getScope()) && (this._value == null ? comp.getValue() == null : this._value.equals(comp.getValue()));
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this._name.hashCode();
        hash = hash * 31 + this._scope.hashCode();
        hash = hash * 31 + (this._value != null ? this._value.hashCode() : 0);
        return hash;
    }

    public String toString() {
        String labels = Strings.concat((String)", ", (String[])this._labels.toArray(new String[this._labels.size()]));
        labels = "{" + (labels != null ? labels : "") + "}";
        return "[name=" + this._name + ", scope=" + this._scope + ", value=" + this._value + ", labels=" + labels + "]";
    }

    public static final class ContextPropertyFactory
    extends BaseFactory<ContextProperty> {
        public ContextProperty create(Class<ContextProperty> type, Node node) {
            return new ContextProperty();
        }
    }
}

