/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard;

import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.label.BehaviorLabel;

public final class ContextUtil {
    private ContextUtil() {
    }

    public static Context copy(Context source, Context destination) {
        for (Property property : source.getProperties()) {
            if (property.hasLabel(BehaviorLabel.TRANSIENT.label())) continue;
            String[] labels = property.getLabels().toArray(new String[property.getLabels().size()]);
            destination.setProperty(property.getName(), property.getValue()).addLabels(labels);
        }
        return destination;
    }

    public static void checkScope(Scope source, Scope target) {
        if (source != target) {
            throw new IllegalArgumentException("Scope " + (Object)((Object)target) + " is different than expected " + (Object)((Object)source));
        }
    }
}

