/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.bpm;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bpm.task.Task;
import org.switchyard.component.bpm.task.TaskClient;
import org.switchyard.component.bpm.task.TaskServer;
import org.switchyard.component.bpm.task.TaskService;
import org.switchyard.component.bpm.task.TaskStatus;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class BPMMixIn
extends AbstractTestMixIn {
    private final boolean _managedLifecycle;
    private final TaskService _service;
    private TaskServer _server = null;
    private TaskClient _client = null;
    private String _host = "127.0.0.1";
    private int _port = 9123;
    private String _groupsPath = "/roles.properties";

    public BPMMixIn() {
        this(true);
    }

    public BPMMixIn(boolean managedLifecycle) {
        this._managedLifecycle = managedLifecycle;
        this._service = TaskService.instance();
    }

    public String getHost() {
        return this._host;
    }

    public BPMMixIn setHost(String host) {
        this._host = host;
        return this;
    }

    public int getPort() {
        return this._port;
    }

    public BPMMixIn setPort(int port) {
        this._port = port;
        return this;
    }

    public String getGroupsPath() {
        return this._groupsPath;
    }

    public BPMMixIn setGroupsPath(String groupsPath) {
        this._groupsPath = groupsPath;
        return this;
    }

    public void initialize() {
        if (this._managedLifecycle) {
            this.startTaskServer();
        }
    }

    public void uninitialize() {
        if (this._managedLifecycle) {
            this.stopTaskServer();
        }
    }

    public void startTaskServer() {
        if (this._server == null) {
            this._server = this._service.newTaskServer();
            this._server.setHost(this.getHost());
            this._server.setPort(this.getPort());
            this._server.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTaskServer() {
        if (this._server != null) {
            try {
                this._server.stop();
            }
            finally {
                this._server = null;
            }
        }
    }

    public void connectTaskClient() {
        if (this._client == null) {
            this._client = this._service.newTaskClient();
            this._client.setHost(this.getHost());
            this._client.setPort(this.getPort());
            this._client.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectTaskClient() {
        if (this._client != null) {
            try {
                this._client.disconnect();
            }
            finally {
                this._client = null;
            }
        }
    }

    public Map<String, List<String>> getUsersGroups() {
        return this.getUsersGroups(this.getGroupsPath());
    }

    public Map<String, List<String>> getUsersGroups(String groupsPath) {
        Properties usersGroupsProps;
        HashMap<String, List<String>> usersGroupsMap = new HashMap<String, List<String>>();
        try {
            usersGroupsProps = (Properties)new PropertiesPuller().pull(groupsPath, BPMMixIn.class);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
        for (Object userKey : usersGroupsProps.keySet()) {
            String user = (String)userKey;
            if ("Administrator".equals(user)) continue;
            List groups = Strings.splitTrimToNull((String)usersGroupsProps.getProperty(user), (String)",");
            usersGroupsMap.put(user, groups);
        }
        return usersGroupsMap;
    }

    public void completeHumanTasks() {
        this.completeHumanTasks(this.getUsersGroups());
    }

    public void completeHumanTasks(String groupsPath) {
        this.completeHumanTasks(this.getUsersGroups(groupsPath));
    }

    public void completeHumanTasks(Map<String, List<String>> usersGroups) {
        boolean keepWorking;
        while (keepWorking = this.doCompleteHumanTasks(usersGroups)) {
        }
    }

    private boolean doCompleteHumanTasks(Map<String, List<String>> usersGroups) {
        boolean keepWorking = false;
        for (String userId : usersGroups.keySet()) {
            List<String> groupIds = usersGroups.get(userId);
            List tasks = this._client.getTasksAssignedAsPotentialOwner(userId, groupIds);
            for (Task task : tasks) {
                if (TaskStatus.COMPLETED.equals((Object)task.getStatus())) continue;
                Long taskId = task.getId();
                this._client.claim(taskId, userId, groupIds);
                this._client.start(taskId, userId);
                this._client.complete(taskId, userId);
                keepWorking = true;
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            throw new SwitchYardException((Throwable)ie);
        }
        return keepWorking;
    }
}

