/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.deploy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ServerLocator;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.hornetq.ServerLocatorBuilder;
import org.switchyard.component.hornetq.config.model.HornetQBindingModel;
import org.switchyard.component.hornetq.config.model.HornetQConfigModel;
import org.switchyard.component.hornetq.config.model.HornetQConnectorConfigModel;
import org.switchyard.component.hornetq.config.model.HornetQDiscoveryGroupConfigModel;
import org.switchyard.component.hornetq.deploy.InboundHandler;
import org.switchyard.component.hornetq.deploy.OutboundHandler;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.domain.PropertiesModel;
import org.switchyard.config.model.domain.PropertyModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class HornetQActivator
extends BaseActivator {
    private Map<QName, Set<InboundHandler>> _bindings = new HashMap<QName, Set<InboundHandler>>();
    private Map<QName, Set<OutboundHandler>> _refBindings = new HashMap<QName, Set<OutboundHandler>>();

    public HornetQActivator() {
        super(new String[]{"hornetq"});
    }

    public ExchangeHandler init(QName serviceName, Model config) {
        if (this.isServiceBinding(config)) {
            return this.handleServiceBindings((CompositeServiceModel)config, serviceName);
        }
        if (this.isReferenceBinding(config)) {
            return this.handleReferenceBinding(config, serviceName);
        }
        throw new SwitchYardException("No HornetQ bindings, references, or implementations found for [" + serviceName + "] in config [" + config + "]");
    }

    private boolean isReferenceBinding(Model config) {
        return config instanceof CompositeReferenceModel;
    }

    private boolean isServiceBinding(Model config) {
        return config instanceof CompositeServiceModel;
    }

    private ExchangeHandler handleServiceBindings(CompositeServiceModel serviceModel, QName serviceName) {
        List bindings = serviceModel.getBindings();
        for (BindingModel bindingModel : bindings) {
            if (!(bindingModel instanceof HornetQBindingModel)) continue;
            HornetQBindingModel hbm = (HornetQBindingModel)bindingModel;
            ServerLocator serverLocator = this.buildServerLocator(hbm.getHornetQConfig());
            InboundHandler inboundHandler = new InboundHandler(hbm, serverLocator);
            Set<InboundHandler> inboundHandlers = this.getInboundHandlersForService(serviceName);
            if (inboundHandlers.contains(inboundHandler)) continue;
            inboundHandlers.add(inboundHandler);
            this._bindings.put(serviceName, inboundHandlers);
            return inboundHandler;
        }
        return null;
    }

    private ExchangeHandler handleReferenceBinding(Model config, QName serviceName) {
        CompositeReferenceModel refModel = (CompositeReferenceModel)config;
        List bindings = refModel.getBindings();
        for (BindingModel bindingModel : bindings) {
            if (!(bindingModel instanceof HornetQBindingModel)) continue;
            HornetQBindingModel hbm = (HornetQBindingModel)bindingModel;
            ServerLocator serverLocator = this.buildServerLocator(hbm.getHornetQConfig());
            OutboundHandler outboundHandler = new OutboundHandler(hbm, serverLocator);
            Set<OutboundHandler> outboundHandlersForService = this.getOutboundHandlersForService(serviceName);
            if (outboundHandlersForService.contains((Object)outboundHandler)) continue;
            outboundHandlersForService.add(outboundHandler);
            this._refBindings.put(serviceName, outboundHandlersForService);
            return outboundHandler;
        }
        return null;
    }

    private Set<InboundHandler> getInboundHandlersForService(QName serviceName) {
        Set<InboundHandler> handlers = this._bindings.get(serviceName);
        if (handlers == null) {
            handlers = new HashSet<InboundHandler>();
        }
        return handlers;
    }

    private Set<OutboundHandler> getOutboundHandlersForService(QName serviceName) {
        Set<OutboundHandler> handlers = this._refBindings.get(serviceName);
        if (handlers == null) {
            handlers = new HashSet<OutboundHandler>();
        }
        return handlers;
    }

    private ServerLocator buildServerLocator(HornetQConfigModel configModel) {
        ServerLocatorBuilder slb = new ServerLocatorBuilder();
        slb.ackBatchSize(configModel.getAckBatchSize());
        slb.autoGroup(configModel.isAutoGroup());
        slb.blockOnAcknowledge(configModel.isBlockOnAcknowledge());
        slb.blockOnDurableSend(configModel.isBlockOnDurableSend());
        slb.blockOnNonDurableSend(configModel.isBlockOnNonDurableSend());
        slb.cacheLargeMessagesOnConsumers(configModel.isCacheLargeMessagesClient());
        slb.callTimeout(configModel.getCallTimeout());
        slb.clientFailureCheckPeriod(configModel.getClientFailureCheckPeriod());
        slb.compressLargeMessage(configModel.isCompressLargeMessage());
        slb.confirmationWindowSize(configModel.getConfirmationWindowSize());
        slb.connectionLoadBalancingPolicyClassName(configModel.getConnectionLoadBalancingPolicyClassName());
        slb.connectionTTL(configModel.getConnectionTTL());
        slb.consumerMaxRate(configModel.getConsumerMaxRate());
        slb.consumerWindowSize(configModel.getConsumerWindowSize());
        slb.disableFinalizedCheck(configModel.isDisableFinalizeCheck());
        slb.discoveryGroupConfiguration(this.getDiscoveryGroupConfiguration(configModel.getDiscoveryGroup()));
        slb.failoverOnInitialConnection(configModel.isFailoverOnInitialConnection());
        slb.groupID(configModel.getGroupID());
        slb.initialMessagePacketSize(configModel.getInitialMessagePacketSize());
        slb.initialReconnectAttempts(configModel.getInitialConnectAttempts());
        slb.maxRetryInterval(configModel.getMaxRetryInterval());
        slb.minLargeMessageSize(configModel.getMinLargeMessageSize());
        slb.preAcknowledge(configModel.isPreAcknowledge());
        slb.producerMaxRate(configModel.getProducerMaxRate());
        slb.producerWindowSize(configModel.getProducerWindowSize());
        slb.reconnectAttempts(configModel.getReconnectAttempts());
        slb.retryInterval(configModel.getRetryInterval());
        slb.retryIntervalMultiplier(configModel.getRetryIntervalMultiplier());
        slb.scheduledThreadPoolMaxSize(configModel.getScheduledThreadPoolMaxSize());
        slb.threadPoolMaxSize(configModel.getThreadPoolMaxSize());
        slb.transportConfigurations(this.getTransportConfiguration(configModel.getConnectorConfiguration()));
        slb.useGlobalPools(configModel.isUseGlobalPools());
        slb.useHA(configModel.isUseHA());
        return slb.build();
    }

    private TransportConfiguration getTransportConfiguration(HornetQConnectorConfigModel config) {
        if (config == null) {
            return null;
        }
        PropertiesModel propertiesModel = config.getProperties();
        HashMap<String, String> connectorProperties = new HashMap<String, String>();
        if (propertiesModel != null) {
            for (PropertyModel propertyModel : propertiesModel.getProperties()) {
                connectorProperties.put(propertyModel.getName(), propertyModel.getValue());
            }
        }
        return new TransportConfiguration(config.getConnectorClassName(), connectorProperties);
    }

    private DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(HornetQDiscoveryGroupConfigModel config) {
        Long initialWaitTimeout;
        Long refreshTimeout;
        if (config == null) {
            return null;
        }
        DiscoveryGroupConfiguration discoveryGroupConfiguration = new DiscoveryGroupConfiguration(config.getGroupAddress(), config.getGroupPort().intValue());
        String localBindAddress = config.getLocalBindAddress();
        if (localBindAddress != null) {
            discoveryGroupConfiguration.setLocalBindAdress(localBindAddress);
        }
        if ((refreshTimeout = config.getRefreshTimeout()) != null) {
            discoveryGroupConfiguration.setRefreshTimeout(refreshTimeout.longValue());
        }
        if ((initialWaitTimeout = config.getInitialWaitTimeout()) != null) {
            discoveryGroupConfiguration.setDiscoveryInitialWaitTimeout(initialWaitTimeout.longValue());
        }
        return discoveryGroupConfiguration;
    }

    public void start(ServiceReference serviceReference) {
        Set<OutboundHandler> outboundHandlers;
        Set<InboundHandler> handlers = this._bindings.get(serviceReference.getName());
        if (handlers != null) {
            for (InboundHandler inboundHandler : handlers) {
                try {
                    inboundHandler.start(serviceReference);
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
            }
        }
        if ((outboundHandlers = this._refBindings.get(serviceReference.getName())) != null) {
            for (OutboundHandler outboundHandler : outboundHandlers) {
                outboundHandler.start();
            }
        }
    }

    public void stop(ServiceReference serviceReference) {
        Set<OutboundHandler> outboundHandlers;
        Set<InboundHandler> handlers = this._bindings.get(serviceReference.getName());
        if (handlers != null) {
            for (InboundHandler inboundHandler : handlers) {
                try {
                    inboundHandler.stop(serviceReference);
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
            }
        }
        if ((outboundHandlers = this._refBindings.get(serviceReference.getName())) != null) {
            for (OutboundHandler outboundHandler : outboundHandlers) {
                outboundHandler.stop();
            }
        }
    }

    public void destroy(ServiceReference service) {
    }
}

