/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import org.kie.KieServices;
import org.kie.builder.KnowledgeBuilder;
import org.kie.io.KieResources;
import org.kie.io.Resource;
import org.kie.io.ResourceType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.config.model.resource.ResourceModel;
import org.switchyard.config.model.resource.ResourcesModel;

public final class Resources {
    public static void installTypes(ClassLoader loader) {
        org.switchyard.common.io.resource.ResourceType.install((ClassLoader)loader);
    }

    public static void addResources(KnowledgeComponentImplementationModel model, ClassLoader loader, KnowledgeBuilder builder) {
        ResourcesModel resourcesModel;
        ManifestModel manifestModel = model.getManifest();
        if (manifestModel != null && (resourcesModel = manifestModel.getResources()) != null) {
            KieResources kieResources = KieServices.Factory.get().getResources();
            for (ResourceModel syResource : resourcesModel.getResources()) {
                ResourceType kieResourceType;
                Resource kieResource = kieResources.newUrlResource(syResource.getLocationURL(loader));
                if (kieResource == null || (kieResourceType = Resources.convertResourceType(syResource.getType())) == null) continue;
                builder.add(kieResource, kieResourceType);
            }
        }
    }

    public static void addResource(org.switchyard.common.io.resource.Resource syResource, ClassLoader loader, KnowledgeBuilder builder) {
        ResourceType kieResourceType;
        KieResources kieResources = KieServices.Factory.get().getResources();
        Resource kieResource = kieResources.newUrlResource(syResource.getLocationURL(loader));
        if (kieResource != null && (kieResourceType = Resources.convertResourceType(syResource.getType())) != null) {
            builder.add(kieResource, kieResourceType);
        }
    }

    public static ResourceType convertResourceType(org.switchyard.common.io.resource.ResourceType syResourceType) {
        if (syResourceType != null) {
            String resourceTypeName = syResourceType.getName();
            if ("BPMN".equals(resourceTypeName)) {
                resourceTypeName = "BPMN2";
            } else if ("XLS".equals(resourceTypeName)) {
                resourceTypeName = "DTABLE";
            }
            return ResourceType.getResourceType((String)resourceTypeName);
        }
        return null;
    }

    private Resources() {
    }
}

