/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.runtime.Globals;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.ActionType;
import org.switchyard.component.common.knowledge.config.model.ActionModel;
import org.switchyard.component.common.knowledge.config.model.ActionsModel;
import org.switchyard.component.common.knowledge.config.model.GlobalModel;
import org.switchyard.component.common.knowledge.config.model.GlobalsModel;
import org.switchyard.component.common.knowledge.config.model.InputModel;
import org.switchyard.component.common.knowledge.config.model.InputsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.OutputModel;
import org.switchyard.component.common.knowledge.config.model.OutputsModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeAction;
import org.switchyard.component.common.knowledge.expression.ContextMap;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionFactory;
import org.switchyard.component.common.knowledge.expression.ExpressionMapping;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.exception.SwitchYardException;

public final class Actions {
    public static void registerActions(KnowledgeComponentImplementationModel model, Map<String, KnowledgeAction> actions, KnowledgeAction defaultAction) {
        ActionsModel actionsModel = model.getActions();
        if (actionsModel != null) {
            for (ActionModel actionModel : actionsModel.getActions()) {
                String eventId;
                ActionType type;
                String operation = Strings.trimToNull((String)actionModel.getOperation());
                if (operation == null) {
                    operation = "default";
                }
                if ((type = actionModel.getType()) == null) {
                    type = defaultAction.getType();
                }
                if ((eventId = actionModel.getEventId()) == null) {
                    eventId = defaultAction.getEventId();
                }
                KnowledgeAction action = new KnowledgeAction(type, eventId);
                Actions.mapExpressions(actionModel, action);
                if (actions.containsKey(operation)) {
                    throw new SwitchYardException(String.format("cannot register %s action due to duplicate operation: %s", type, operation));
                }
                actions.put(operation, action);
            }
        }
        if (!actions.containsKey("default")) {
            actions.put("default", defaultAction);
        }
    }

    private static void mapExpressions(ActionModel actionModel, KnowledgeAction action) {
        OutputsModel outputsModel;
        InputsModel inputsModel;
        GlobalsModel globalsModel = actionModel.getGlobals();
        if (globalsModel != null) {
            for (GlobalModel globalModel : globalsModel.getGlobals()) {
                action.getGlobalExpressionMappings().add(new ExpressionMapping(globalModel));
            }
        }
        if ((inputsModel = actionModel.getInputs()) != null) {
            for (InputModel inputModel : inputsModel.getInputs()) {
                action.getInputExpressionMappings().add(new ExpressionMapping(inputModel));
            }
        }
        if ((outputsModel = actionModel.getOutputs()) != null) {
            for (OutputModel outputModel : outputsModel.getOutputs()) {
                action.getOutputExpressionMappings().add(new ExpressionMapping(outputModel));
            }
        }
    }

    public static void setGlobals(Message message, KnowledgeAction action, KnowledgeSession session) {
        Globals globals = session.getGlobals();
        Map<String, Object> map = Actions.getMap(message, action.getGlobalExpressionMappings(), null);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            globals.set(entry.getKey(), entry.getValue());
        }
    }

    public static Object getInput(Message message, KnowledgeAction action) {
        List<Object> list = Actions.getList(message, action.getInputExpressionMappings());
        switch (list.size()) {
            case 0: {
                return message.getContent();
            }
            case 1: {
                return list.get(0);
            }
        }
        return list;
    }

    public static List<Object> getInputList(Message message, KnowledgeAction action) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<ExpressionMapping> inputs = action.getInputExpressionMappings();
        if (inputs.size() > 0) {
            list.addAll(Actions.getList(message, inputs));
        } else {
            Actions.expand(message.getContent(), list);
        }
        return list;
    }

    public static Map<String, Object> getInputMap(Message message, KnowledgeAction action) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ExpressionMapping> inputs = action.getInputExpressionMappings();
        if (inputs.size() > 0) {
            map.putAll(Actions.getMap(message, inputs, null));
        } else {
            Object content = message.getContent();
            if (content != null) {
                map.put("Parameter", content);
            }
        }
        return map;
    }

    public static Object getOutput(Message message, KnowledgeAction action) {
        List<Object> list = Actions.getList(message, action.getOutputExpressionMappings());
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        return list;
    }

    public static void setOutputs(Message message, KnowledgeAction action, Map<String, Object> contextOverrides) {
        HashMap<String, ArrayList<ExpressionMapping>> toListMap = new HashMap<String, ArrayList<ExpressionMapping>>();
        for (ExpressionMapping expressionMapping : action.getOutputExpressionMappings()) {
            String to = expressionMapping.getTo();
            if (to == null) continue;
            ArrayList<ExpressionMapping> toList = (ArrayList<ExpressionMapping>)toListMap.get(to);
            if (toList == null) {
                toList = new ArrayList<ExpressionMapping>();
                toListMap.put(to, toList);
            }
            toList.add(expressionMapping);
        }
        if (toListMap.size() == 0) {
            Object output = contextOverrides.get("Result");
            if (output != null) {
                message.setContent(output);
            }
        } else {
            for (Map.Entry entry : toListMap.entrySet()) {
                ArrayList<Object> output;
                ArrayList<Object> from_list = new ArrayList<Object>();
                ExpressionMapping to_em = null;
                for (ExpressionMapping from_em : (List)entry.getValue()) {
                    Object from_value;
                    if (to_em == null) {
                        to_em = from_em;
                    }
                    if ((from_value = Actions.run(message, from_em.getFromExpression(), contextOverrides)) == null) continue;
                    from_list.add(from_value);
                }
                switch (from_list.size()) {
                    case 0: {
                        output = null;
                        break;
                    }
                    case 1: {
                        output = from_list.get(0);
                        break;
                    }
                    default: {
                        output = from_list;
                    }
                }
                String output_var = Actions.toVariable(output);
                contextOverrides.put(output_var, output);
                String output_to = to_em.getTo() + " = " + output_var;
                Expression output_to_expr = ExpressionFactory.INSTANCE.create(output_to, null, to_em.getPropertyResolver());
                Actions.run(message, output_to_expr, contextOverrides);
            }
        }
    }

    private static List<Object> getList(Message message, List<ExpressionMapping> expressionMappings) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (expressionMappings == null || expressionMappings.size() == 0) {
            Actions.expand(message.getContent(), list);
        } else {
            Map<String, List<Object>> listMap = Actions.getListMap(message, expressionMappings, true, Actions.toVariable(message));
            for (List<Object> value : listMap.values()) {
                Actions.expand(value, list);
            }
        }
        return list;
    }

    private static Map<String, Object> getMap(Message message, List<ExpressionMapping> expressionMappings, Map<String, Object> contextOverrides) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, List<Object>> listMap = Actions.getListMap(message, expressionMappings, false, Actions.toVariable(message), contextOverrides);
        for (Map.Entry<String, List<Object>> entry : listMap.entrySet()) {
            List<Object> list = entry.getValue();
            map.put(entry.getKey(), list != null && list.size() > 0 ? list.get(0) : null);
        }
        return map;
    }

    public static Map<String, List<Object>> getListMap(Message message, List<ExpressionMapping> expressionMappings, boolean expand, String undefinedVariable) {
        return Actions.getListMap(message, expressionMappings, expand, undefinedVariable, null);
    }

    private static Map<String, List<Object>> getListMap(Message message, List<ExpressionMapping> expressionMappings, boolean expand, String undefinedVariable, Map<String, Object> contextOverrides) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        if (expressionMappings != null) {
            for (ExpressionMapping em : expressionMappings) {
                String variable = em.getTo();
                if (variable == null && undefinedVariable != null) {
                    variable = undefinedVariable;
                }
                if (variable == null) continue;
                ArrayList<Object> list = (ArrayList<Object>)map.get(variable);
                if (list == null) {
                    list = new ArrayList<Object>();
                    map.put(variable, list);
                }
                Object value = Actions.run(message, em.getFromExpression(), contextOverrides);
                if (expand) {
                    Actions.expand(value, list);
                    continue;
                }
                if (value == null) continue;
                list.add(value);
            }
        }
        return map;
    }

    private static Object run(Message message, Expression expression, Map<String, Object> contextOverrides) {
        HashMap<String, Object> expressionContext = new HashMap<String, Object>();
        expressionContext.put("context", new ContextMap(message.getContext(), Scope.MESSAGE));
        expressionContext.put("message", message);
        if (contextOverrides != null) {
            for (Map.Entry<String, Object> contextOverride : contextOverrides.entrySet()) {
                expressionContext.put(contextOverride.getKey(), contextOverride.getValue());
            }
        }
        return expression.run(expressionContext);
    }

    private static void expand(Object value, List<Object> list) {
        if (value != null) {
            if (value instanceof Iterable) {
                for (Object o : (Iterable)value) {
                    if (o == null) continue;
                    list.add(o);
                }
            } else {
                list.add(value);
            }
        }
    }

    public static String toVariable(Object object) {
        return ("_var" + System.identityHashCode(object)).replaceFirst("-", "_");
    }

    private Actions() {
    }
}

