/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.switchyard.component.camel.common.CommonCamelMessages;

public final class TransactionManagerFactory {
    public static final String JBOSS_USER_TRANSACTION = "java:jboss/UserTransaction";
    public static final String JBOSS_TRANSACTION_MANANGER = "java:jboss/TransactionManager";
    public static final String JBOSS_TRANSACTION_SYNC_REG = "java:jboss/TransactionSynchronizationRegistry";
    public static final String OSGI_TRANSACTION_MANAGER = "osgi:service/javax.transaction.TransactionManager";
    public static final String TM = "jtaTransactionManager";
    private static final TransactionManagerFactory INSTANCE = new TransactionManagerFactory();

    private TransactionManagerFactory() {
    }

    public static TransactionManagerFactory getInstance() {
        return INSTANCE;
    }

    public PlatformTransactionManager create() {
        JtaTransactionManager transactionManager;
        if (this.isBound(JBOSS_USER_TRANSACTION)) {
            transactionManager = new JtaTransactionManager();
            transactionManager.setUserTransactionName(JBOSS_USER_TRANSACTION);
            transactionManager.setTransactionManagerName(JBOSS_TRANSACTION_MANANGER);
            transactionManager.setTransactionSynchronizationRegistryName(JBOSS_TRANSACTION_SYNC_REG);
        } else if (this.isBound(OSGI_TRANSACTION_MANAGER)) {
            transactionManager = new JtaTransactionManager((TransactionManager)this.lookupInJndi(OSGI_TRANSACTION_MANAGER));
        } else if (this.isBound("java:comp/UserTransaction")) {
            transactionManager = new JtaTransactionManager();
            transactionManager.setUserTransactionName("java:comp/UserTransaction");
        } else {
            throw CommonCamelMessages.MESSAGES.couldNotCreateAJtaTransactionManagerAsNoTransactionManagerWasFoundJBOSSUSERTRANSACTION(JBOSS_USER_TRANSACTION, OSGI_TRANSACTION_MANAGER, "java:comp/UserTransaction");
        }
        transactionManager.afterPropertiesSet();
        return transactionManager;
    }

    private boolean isBound(String jndiName) {
        return this.lookupInJndi(jndiName) != null;
    }

    private Object lookupInJndi(String name) {
        InitialContext context = null;
        try {
            context = new InitialContext();
            Object object = context.lookup(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_7 = null;
            return var4_7;
        }
        catch (Exception e) {
            throw CommonCamelMessages.MESSAGES.unexpectedExceptionRetrieving(name, e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    throw CommonCamelMessages.MESSAGES.unexpectedErrorClosingInitialContext(e);
                }
            }
        }
    }
}

