/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ServiceReference;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;

public final class ServiceReferences {
    private static final ConcurrentHashMap<QName, ServiceReference> REFS = new ConcurrentHashMap();

    private ServiceReferences() {
    }

    public static ServiceReference add(QName serviceName, ServiceReference ref) {
        return REFS.putIfAbsent(serviceName, ref);
    }

    public static ServiceReference get(QName serviceName) {
        return REFS.get(serviceName);
    }

    public static ServiceReference remove(QName serviceName) {
        return REFS.remove(serviceName);
    }

    public static void clear() {
        REFS.clear();
    }

    public static QName getOutputTypeForExchange(ServiceReference ref, Exchange exchange) {
        ServiceInterface serviceInterface = ref.getInterface();
        if (serviceInterface.getType().equals("java")) {
            return exchange.getContract().getInvokerInvocationMetaData().getOutputType();
        }
        return null;
    }

    public static QName getOutputTypeForOperation(ServiceReference ref, String operationName) {
        ServiceInterface serviceInterface = ref.getInterface();
        ServiceOperation operation = serviceInterface.getOperation(operationName);
        return operation.getOutputType();
    }
}

