/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchYardProducer;
import org.switchyard.component.camel.SwitchyardComponent;
import org.switchyard.component.camel.composer.CamelComposition;
import org.switchyard.composer.MessageComposer;

public class SwitchyardEndpoint
extends DefaultEndpoint {
    private String _namespace;
    private String _operationName;
    private MessageComposer<Message> _messageComposer;
    private SwitchYardConsumer _consumer;

    public SwitchyardEndpoint(String endpointUri, SwitchyardComponent component, String namespace, String operationName) {
        super(endpointUri, (Component)component);
        this._namespace = namespace;
        this._operationName = operationName;
    }

    public synchronized SwitchyardEndpoint setMessageComposer(MessageComposer<Message> messageComposer) {
        this._messageComposer = messageComposer;
        return this;
    }

    public synchronized MessageComposer<Message> getMessageComposer() {
        if (this._messageComposer == null) {
            this._messageComposer = CamelComposition.getMessageComposer();
        }
        return this._messageComposer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this._operationName == null) {
            this._consumer = new SwitchYardConsumer((Endpoint)this, processor, this.getMessageComposer());
            return this._consumer;
        }
        return null;
    }

    public SwitchYardConsumer getConsumer() {
        return this._consumer;
    }

    public Producer createProducer() throws Exception {
        return new SwitchYardProducer((Endpoint)this, this._namespace, this._operationName, this.getMessageComposer());
    }

    public boolean isSingleton() {
        return true;
    }
}

